/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.exceptions;

import com.crabshue.commons.exceptions.context.CommonErrorContext;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.exceptions.utils.ExceptionUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public abstract class AbstractException
extends ContextedRuntimeException {
    protected AbstractException() {
    }

    public AbstractException(ErrorType errorType) {
        super(errorType.name());
        this.addContextValue(CommonErrorContext.EXCEPTION_MESSAGE, (Object)errorType);
    }

    public AbstractException(ErrorType errorType, Throwable cause) {
        super(errorType.name(), cause);
        this.addContextValue(CommonErrorContext.EXCEPTION_MESSAGE, (Object)errorType);
        this.addContextValue(CommonErrorContext.CAUSE, (Object)ExceptionUtils.buildMessageFromThrowable(cause));
    }

    public AbstractException(ErrorType errorType, String message) {
        super(message);
        this.addContextValue(CommonErrorContext.EXCEPTION_MESSAGE, (Object)errorType);
    }

    public AbstractException(ErrorType errorType, String message, Throwable cause) {
        super(message, cause);
        this.addContextValue(CommonErrorContext.EXCEPTION_MESSAGE, (Object)errorType);
        this.addContextValue(CommonErrorContext.CAUSE, (Object)ExceptionUtils.buildMessageFromThrowable(cause));
    }

    public AbstractException addContextValue(String label, Object value) {
        return (AbstractException)super.addContextValue(label, value);
    }

    public AbstractException addContextValue(ErrorContext label, Object value) {
        return (AbstractException)super.addContextValue(label.name(), value);
    }
}

