/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyResultSet;
import cn.beecp.pool.ProxyStatementBase;
import cn.beecp.pool.exception.TestSQLFailException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolStaticCenter {
    public static final int NCPUS = Runtime.getRuntime().availableProcessors();
    public static final Logger CommonLog = LoggerFactory.getLogger(PoolStaticCenter.class);
    public static final String Separator_MiddleLine = "-";
    public static final String Separator_UnderLine = "_";
    public static final String CONFIG_TM_JNDI = "transactionManagerName";
    public static final String CONFIG_CONNECT_PROP = "connectProperties";
    public static final String CONFIG_CONNECT_PROP_SIZE = "connectProperties.size";
    public static final String CONFIG_CONNECT_PROP_KEY_PREFIX = "connectProperties.";
    public static final int POOL_NEW = 0;
    public static final int POOL_READY = 1;
    public static final int POOL_CLOSED = 2;
    public static final int POOL_CLEARING = 3;
    static final int CON_IDLE = 0;
    static final int CON_USING = 1;
    static final int CON_CLOSED = 2;
    static final int THREAD_WORKING = 0;
    static final int THREAD_WAITING = 1;
    static final int THREAD_EXIT = 2;
    static final int PS_AUTO = 0;
    static final int PS_TRANS = 1;
    static final int PS_READONLY = 2;
    static final int PS_CATALOG = 3;
    static final int PS_SCHEMA = 4;
    static final int PS_NETWORK = 5;
    static final String DESC_RM_INIT = "init";
    static final String DESC_RM_BAD = "bad";
    static final String DESC_RM_ABORT = "abort";
    static final String DESC_RM_IDLE = "idle";
    static final String DESC_RM_CLOSED = "closed";
    static final String DESC_RM_CLEAR = "clear";
    static final String DESC_RM_DESTROY = "destroy";
    static final Connection CLOSED_CON = (Connection)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{Connection.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw new SQLException("No operations allowed after connection closed");
        }
    });
    static final CallableStatement CLOSED_CSTM = (CallableStatement)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{CallableStatement.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw new SQLException("No operations allowed after statement closed");
        }
    });
    static final ResultSet CLOSED_RSLT = (ResultSet)Proxy.newProxyInstance(PoolStaticCenter.class.getClassLoader(), new Class[]{ResultSet.class}, new InvocationHandler(){

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("isClosed".equals(method.getName())) {
                return Boolean.TRUE;
            }
            throw new SQLException("No operations allowed after resultSet closed");
        }
    });
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private static final Object[] EMPTY_PARAMETERS = new Object[0];

    static boolean stringEquals(String a, String b) {
        return a != null ? a.equals(b) : b == null;
    }

    public static String trimString(String value) {
        return value == null ? null : value.trim();
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int l = str.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isWhitespace((int)str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void oclose(ResultSet r) {
        try {
            r.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing resultSet:", e);
        }
    }

    public static void oclose(Statement s) {
        try {
            s.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing statement:", e);
        }
    }

    public static void oclose(Connection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing connection:", e);
        }
    }

    public static void oclose(XAConnection c) {
        try {
            c.close();
        }
        catch (Throwable e) {
            CommonLog.debug("Warning:Error at closing connection:", e);
        }
    }

    static ProxyConnectionBase createProxyConnection(PooledConnection pooledConnection) throws SQLException {
        return new ProxyConnection(pooledConnection);
    }

    static ResultSet createProxyResultSet(ResultSet resultSet, ProxyStatementBase proxyStatementBase, PooledConnection pooledConnection) throws SQLException {
        return new ProxyResultSet(resultSet, proxyStatementBase, pooledConnection);
    }

    static void checkJdbcProxyClass() {
        String[] classNames = new String[]{"cn.beecp.pool.Borrower", "cn.beecp.pool.PooledConnection", "cn.beecp.pool.ProxyConnection", "cn.beecp.pool.ProxyStatement", "cn.beecp.pool.ProxyPsStatement", "cn.beecp.pool.ProxyCsStatement", "cn.beecp.pool.ProxyDatabaseMetaData", "cn.beecp.pool.ProxyResultSet"};
        try {
            for (String className : classNames) {
                Class.forName(className);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Jdbc proxy classes missed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateTestSql(String poolName, Connection rawCon, String testSql, int validTestTimeout, boolean isDefaultAutoCommit) throws SQLException {
        boolean changed = false;
        Statement st = null;
        try {
            if (isDefaultAutoCommit) {
                try {
                    rawCon.setAutoCommit(false);
                    changed = true;
                }
                catch (Throwable e) {
                    throw new SQLException("Failed to setAutoCommit(false)", e);
                }
            }
            st = rawCon.createStatement();
            boolean supportQueryTimeout = false;
            try {
                st.setQueryTimeout(validTestTimeout);
                supportQueryTimeout = true;
            }
            catch (Throwable e) {
                CommonLog.warn("BeeCP({})driver not support 'queryTimeout',cause:", (Object)poolName, (Object)e);
            }
            try {
                st.execute(testSql);
            }
            catch (Throwable e) {
                throw new TestSQLFailException("Failed to execute test sql:" + testSql, e);
            }
            finally {
                rawCon.rollback();
            }
            boolean bl = supportQueryTimeout;
            return bl;
        }
        finally {
            if (st != null) {
                PoolStaticCenter.oclose(st);
            }
            if (changed) {
                rawCon.setAutoCommit(true);
            }
        }
    }

    public static Driver loadDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create jdbc driver by class:" + driverClassName, e);
        }
    }

    public static Map<String, Method> getClassSetMethodMap(Class beanClass) {
        Method[] methods = beanClass.getMethods();
        LinkedHashMap<String, Method> methodMap = new LinkedHashMap<String, Method>(methods.length);
        for (Method method : methods) {
            String methodName = method.getName();
            if (method.getParameterTypes().length != 1 || !methodName.startsWith("set") || methodName.length() <= 3) continue;
            methodMap.put(methodName.substring(3), method);
        }
        return methodMap;
    }

    public static String getPropertyValue(Properties properties, String propertyName) {
        String value = PoolStaticCenter.readPropertyValue(properties, propertyName);
        if (value != null) {
            return value;
        }
        String newPropertyName = propertyName.substring(0, 1).toLowerCase(Locale.US) + propertyName.substring(1);
        value = PoolStaticCenter.readPropertyValue(properties, newPropertyName);
        if (value != null) {
            return value;
        }
        value = PoolStaticCenter.readPropertyValue(properties, PoolStaticCenter.propertyNameToFieldId(newPropertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        return PoolStaticCenter.readPropertyValue(properties, PoolStaticCenter.propertyNameToFieldId(newPropertyName, Separator_UnderLine));
    }

    private static Object getFieldValue(Map<String, Object> valueMap, String propertyName) {
        Object value = valueMap.get(propertyName);
        if (value != null) {
            return value;
        }
        String newPropertyName = propertyName.substring(0, 1).toLowerCase(Locale.US) + propertyName.substring(1);
        value = valueMap.get(newPropertyName);
        if (value != null) {
            return value;
        }
        value = valueMap.get(PoolStaticCenter.propertyNameToFieldId(newPropertyName, Separator_MiddleLine));
        if (value != null) {
            return value;
        }
        return valueMap.get(PoolStaticCenter.propertyNameToFieldId(newPropertyName, Separator_UnderLine));
    }

    public static String propertyNameToFieldId(String property, String separator) {
        char[] chars = property.toCharArray();
        StringBuilder sb = new StringBuilder(chars.length);
        for (char c : chars) {
            if (Character.isUpperCase(c)) {
                sb.append(separator).append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String readPropertyValue(Properties configProperties, String propertyName) {
        String value = configProperties.getProperty(propertyName, null);
        if (value != null) {
            CommonLog.info("beecp.{}={}", (Object)propertyName, (Object)value);
            return value.trim();
        }
        return null;
    }

    public static void setPropertiesValue(Object bean, Map<String, Object> valueMap) throws BeeDataSourceConfigException {
        if (bean == null) {
            throw new BeeDataSourceConfigException("Bean can't be null");
        }
        PoolStaticCenter.setPropertiesValue(bean, PoolStaticCenter.getClassSetMethodMap(bean.getClass()), valueMap);
    }

    public static void setPropertiesValue(Object bean, Map<String, Method> setMethodMap, Map<String, Object> valueMap) throws BeeDataSourceConfigException {
        if (bean == null) {
            throw new BeeDataSourceConfigException("Bean can't be null");
        }
        if (setMethodMap == null || setMethodMap.isEmpty() || valueMap == null || valueMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Method> entry : setMethodMap.entrySet()) {
            String propertyName = entry.getKey();
            Method setMethod = entry.getValue();
            Object setValue = PoolStaticCenter.getFieldValue(valueMap, propertyName);
            if (setValue == null) continue;
            Class<?> type = setMethod.getParameterTypes()[0];
            try {
                setValue = PoolStaticCenter.convert(propertyName, setValue, type);
            }
            catch (BeeDataSourceConfigException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new BeeDataSourceConfigException("Failed to convert config value to property(" + propertyName + ")type:" + type.getName(), e);
            }
            try {
                setMethod.invoke(bean, setValue);
            }
            catch (IllegalAccessException e) {
                throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause != null) {
                    throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, cause);
                }
                throw new BeeDataSourceConfigException("Failed to inject config value to property:" + propertyName, e);
            }
        }
    }

    private static Object convert(String propName, Object setValue, Class type) {
        if (type.isInstance(setValue)) {
            return setValue;
        }
        if (type == String.class) {
            return setValue.toString();
        }
        String text = setValue.toString();
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(text.toCharArray()[0]);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(text);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.parseByte(text);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.parseShort(text);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(text);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(text);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(Float.parseFloat(text));
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(text);
        }
        if (type == BigInteger.class) {
            return new BigInteger(text);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(text);
        }
        if (type == Class.class) {
            try {
                return Class.forName(text);
            }
            catch (ClassNotFoundException e) {
                throw new BeeDataSourceConfigException("Not found class:" + text);
            }
        }
        if (type.isArray() || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return null;
        }
        try {
            Object objInstance = Class.forName(text).newInstance();
            if (!type.isInstance(objInstance)) {
                throw new BeeDataSourceConfigException("Config value can't mach property(" + propName + ")type:" + type.getName());
            }
            return objInstance;
        }
        catch (BeeDataSourceConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BeeDataSourceConfigException("Failed to create property(" + propName + ")value by type:" + text, e);
        }
    }

    public static Object createClassInstance(Class objectClass, Class parentClass, String objectClassType) throws Exception {
        Class[] classArray;
        if (parentClass != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = parentClass;
        } else {
            classArray = null;
        }
        return PoolStaticCenter.createClassInstance(objectClass, classArray, objectClassType);
    }

    public static Object createClassInstance(Class objectClass, Class[] parentClasses, String objectClassType) throws Exception {
        if (Modifier.isAbstract(objectClass.getModifiers())) {
            throw new BeeDataSourceConfigException("Error " + objectClassType + " class[" + objectClass.getName() + "],which can't be an abstract class");
        }
        if (!Modifier.isPublic(objectClass.getModifiers())) {
            throw new BeeDataSourceConfigException("Error " + objectClassType + " class[" + objectClass.getName() + "],which must be a public class");
        }
        boolean isSubClass = false;
        if (parentClasses != null && parentClasses.length > 0) {
            for (Class parentClass : parentClasses) {
                if (parentClass == null || !parentClass.isAssignableFrom(objectClass)) continue;
                isSubClass = true;
                break;
            }
            if (!isSubClass) {
                throw new BeeDataSourceConfigException("Error " + objectClassType + " class[" + objectClass.getName() + "],which must extend from one of class[" + PoolStaticCenter.getClassName(parentClasses) + "]");
            }
        }
        return objectClass.getConstructor(EMPTY_CLASSES).newInstance(EMPTY_PARAMETERS);
    }

    private static String getClassName(Class[] classes) {
        StringBuilder buf = new StringBuilder(classes.length * 10);
        for (Class clazz : classes) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(clazz.getName());
        }
        return buf.toString();
    }
}

