/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.ProxyDatabaseMetaDataBase;
import cn.beecp.pool.ProxyResultSetBase;
import cn.beecp.pool.ProxyStatementBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;

final class ProxyClassGenerator {
    private static String folder = "BeeCP/target/classes";

    ProxyClassGenerator() {
    }

    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            folder = args[0];
        }
        ProxyClassGenerator.writeProxyFile(folder);
    }

    public static void writeProxyFile(String folder) throws Exception {
        CtClass[] ctClasses;
        ProxyClassGenerator builder = new ProxyClassGenerator();
        for (CtClass ctClass : ctClasses = builder.createJdbcProxyClasses()) {
            ctClass.writeFile(folder);
        }
    }

    public CtClass[] createJdbcProxyClasses() throws Exception {
        try {
            CtMethod[] ctMethods;
            ClassPool classPool = ClassPool.getDefault();
            classPool.importPackage("java.sql");
            classPool.importPackage("cn.beecp.pool");
            classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
            CtClass ctConnectionClass = classPool.get(Connection.class.getName());
            CtClass ctProxyConnectionBaseClass = classPool.get(ProxyConnectionBase.class.getName());
            String ctProxyConnectionClassName = "cn.beecp.pool.ProxyConnection";
            CtClass ctProxyConnectionClass = classPool.makeClass(ctProxyConnectionClassName, ctProxyConnectionBaseClass);
            ctProxyConnectionClass.setModifiers(17);
            CtClass[] conCreateParam = new CtClass[]{classPool.get("cn.beecp.pool.PooledConnection")};
            CtConstructor ctConstructor = new CtConstructor(conCreateParam, ctProxyConnectionClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyConnectionClass.addConstructor(ctConstructor);
            CtClass ctStatementClass = classPool.get(Statement.class.getName());
            CtClass ctProxyStatementBaseClass = classPool.get(ProxyStatementBase.class.getName());
            String ctProxyStatementClassName = "cn.beecp.pool.ProxyStatement";
            CtClass ctProxyStatementClass = classPool.makeClass(ctProxyStatementClassName, ctProxyStatementBaseClass);
            ctProxyStatementClass.setModifiers(1);
            CtClass[] statementCreateParam = new CtClass[]{classPool.get("java.sql.Statement"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementCreateParam, ctProxyStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyStatementClass.addConstructor(ctConstructor);
            CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
            String ctProxyPsStatementClassName = "cn.beecp.pool.ProxyPsStatement";
            CtClass ctProxyPsStatementClass = classPool.makeClass(ctProxyPsStatementClassName, ctProxyStatementClass);
            ctProxyPsStatementClass.setInterfaces(new CtClass[]{ctPreparedStatementClass});
            ctProxyPsStatementClass.setModifiers(1);
            CtClass[] statementPsCreateParam = new CtClass[]{classPool.get("java.sql.PreparedStatement"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementPsCreateParam, ctProxyPsStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyPsStatementClass.addConstructor(ctConstructor);
            CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
            String ctProxyCsStatementClassName = "cn.beecp.pool.ProxyCsStatement";
            CtClass ctProxyCsStatementClass = classPool.makeClass(ctProxyCsStatementClassName, ctProxyPsStatementClass);
            ctProxyCsStatementClass.setInterfaces(new CtClass[]{ctCallableStatementClass});
            ctProxyCsStatementClass.setModifiers(1);
            CtClass[] statementCsCreateParam = new CtClass[]{classPool.get("java.sql.CallableStatement"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(statementCsCreateParam, ctProxyCsStatementClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyCsStatementClass.addConstructor(ctConstructor);
            CtClass ctDatabaseMetaDataClass = classPool.get(DatabaseMetaData.class.getName());
            CtClass ctProxyDatabaseMetaDataBaseClass = classPool.get(ProxyDatabaseMetaDataBase.class.getName());
            String ctProxyDatabaseMetaDataClassName = "cn.beecp.pool.ProxyDatabaseMetaData";
            CtClass ctProxyDatabaseMetaDataClass = classPool.makeClass(ctProxyDatabaseMetaDataClassName, ctProxyDatabaseMetaDataBaseClass);
            ctProxyDatabaseMetaDataClass.setModifiers(17);
            CtClass[] databaseMetaData = new CtClass[]{classPool.get("java.sql.DatabaseMetaData"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(databaseMetaData, ctProxyDatabaseMetaDataClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyDatabaseMetaDataClass.addConstructor(ctConstructor);
            CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
            CtClass ctProxyResultSetBaseClass = classPool.get(ProxyResultSetBase.class.getName());
            String ctProxyResultSetClassName = "cn.beecp.pool.ProxyResultSet";
            CtClass ctProxyResultSetClass = classPool.makeClass(ctProxyResultSetClassName, ctProxyResultSetBaseClass);
            ctProxyResultSetClass.setModifiers(17);
            CtClass[] resultSetCreateParam1 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.PooledConnection")};
            CtConstructor ctConstructor1 = new CtConstructor(resultSetCreateParam1, ctProxyResultSetClass);
            ctConstructor1.setModifiers(1);
            ctConstructor1.setBody("{super($$);}");
            ctProxyResultSetClass.addConstructor(ctConstructor1);
            CtClass[] resultSetCreateParam2 = new CtClass[]{classPool.get("java.sql.ResultSet"), classPool.get("cn.beecp.pool.ProxyStatementBase"), classPool.get("cn.beecp.pool.PooledConnection")};
            ctConstructor = new CtConstructor(resultSetCreateParam2, ctProxyResultSetClass);
            ctConstructor.setModifiers(1);
            ctConstructor.setBody("{super($$);}");
            ctProxyResultSetClass.addConstructor(ctConstructor);
            this.createProxyConnectionClass(classPool, ctProxyConnectionClass, ctConnectionClass, ctProxyConnectionBaseClass);
            this.createProxyStatementClass(classPool, ctProxyStatementClass, ctStatementClass, ctProxyStatementBaseClass);
            this.createProxyStatementClass(classPool, ctProxyPsStatementClass, ctPreparedStatementClass, ctProxyStatementClass);
            this.createProxyStatementClass(classPool, ctProxyCsStatementClass, ctCallableStatementClass, ctProxyPsStatementClass);
            this.createProxyDatabaseMetaDataClass(classPool, ctProxyDatabaseMetaDataClass, ctDatabaseMetaDataClass, ctProxyDatabaseMetaDataBaseClass);
            this.createProxyResultSetClass(classPool, ctProxyResultSetClass, ctResultSetClass, ctProxyResultSetBaseClass);
            CtClass ctProxyObjectFactoryClass = classPool.get(PoolStaticCenter.class.getName());
            CtMethod createProxyConnectionMethod = null;
            CtMethod createProxyResultSetMethod = null;
            for (CtMethod method : ctMethods = ctProxyObjectFactoryClass.getDeclaredMethods()) {
                if ("createProxyConnection".equals(method.getName())) {
                    createProxyConnectionMethod = method;
                    continue;
                }
                if (!"createProxyResultSet".equals(method.getName())) continue;
                createProxyResultSetMethod = method;
            }
            createProxyConnectionMethod.setBody("{$2.lastUsedConn=$1; return new ProxyConnection($1);}");
            createProxyResultSetMethod.setBody("{return new ProxyResultSet($$);}");
            return new CtClass[]{ctProxyConnectionClass, ctProxyStatementClass, ctProxyPsStatementClass, ctProxyCsStatementClass, ctProxyDatabaseMetaDataClass, ctProxyResultSetClass, ctProxyObjectFactoryClass};
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    private Class createProxyConnectionClass(ClassPool classPool, CtClass ctConnectionClassProxyClass, CtClass ctConnectionClass, CtClass ctConBaseClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctConBaseClass.getMethods();
        HashSet<String> notNeedAddProxyMethods = new HashSet<String>();
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            notNeedAddProxyMethods.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctConnectionClass, linkedList, notNeedAddProxyMethods);
        CtClass ctStatementClass = classPool.get(Statement.class.getName());
        CtClass ctPreparedStatementClass = classPool.get(PreparedStatement.class.getName());
        CtClass ctCallableStatementClass = classPool.get(CallableStatement.class.getName());
        CtClass ctDatabaseMetaDataIntf = classPool.get(DatabaseMetaData.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctConnectionClassProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (ctMethod.getReturnType() == ctStatementClass) {
                methodBuffer.append("return new ProxyStatement(delegate." + methodName + "($$),pConn);");
            } else if (ctMethod.getReturnType() == ctPreparedStatementClass) {
                methodBuffer.append("return new ProxyPsStatement(delegate." + methodName + "($$),pConn);");
            } else if (ctMethod.getReturnType() == ctCallableStatementClass) {
                methodBuffer.append("return new ProxyCsStatement(delegate." + methodName + "($$),pConn);");
            } else if (ctMethod.getReturnType() == ctDatabaseMetaDataIntf) {
                methodBuffer.append("return new ProxyDatabaseMetaData(delegate." + methodName + "($$),pConn);");
            } else if (!methodName.equals("close")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("delegate." + methodName + "($$);");
                } else {
                    methodBuffer.append("return delegate." + methodName + "($$);");
                }
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctConnectionClassProxyClass.addMethod(newCtMethodm);
        }
        return ctConnectionClassProxyClass.toClass();
    }

    private Class createProxyStatementClass(ClassPool classPool, CtClass statementProxyClass, CtClass ctStatementClass, CtClass ctStatementSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctStatementSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>();
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctStatementClass, linkedList, superClassSignatureSet);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(50);
        String delegateName = "delegate.";
        if ("java.sql.PreparedStatement".equals(ctStatementClass.getName())) {
            delegateName = "((PreparedStatement)delegate).";
        } else if ("java.sql.CallableStatement".equals(ctStatementClass.getName())) {
            delegateName = "((CallableStatement)delegate).";
        }
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)statementProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append(delegateName + methodName + "($$);");
                if (methodName.startsWith("execute")) {
                    methodBuffer.append("pConn.updateAccessTime();");
                }
            } else if (methodName.startsWith("execute")) {
                methodBuffer.append(ctMethod.getReturnType().getName() + " re=" + delegateName + methodName + "($$);").append("pConn.updateAccessTime();");
                if (ctMethod.getReturnType() == ctResultSetClass) {
                    methodBuffer.append("return new ProxyResultSet(re,this,pConn);");
                } else {
                    methodBuffer.append("return re;");
                }
            } else if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(delegate." + methodName + "($$),this,pConn);");
            } else {
                methodBuffer.append("return " + delegateName + methodName + "($$);");
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            statementProxyClass.addMethod(newCtMethodm);
        }
        return statementProxyClass.toClass();
    }

    private Class createProxyDatabaseMetaDataClass(ClassPool classPool, CtClass ctProxyDatabaseMetaDataClass, CtClass ctDatabaseMetaDataIntf, CtClass ctDatabaseMetaDataSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctDatabaseMetaDataSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>();
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctDatabaseMetaDataIntf, linkedList, superClassSignatureSet);
        CtClass ctResultSetClass = classPool.get(ResultSet.class.getName());
        StringBuilder methodBuffer = new StringBuilder(40);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctProxyDatabaseMetaDataClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{").append("checkClosed();");
            if (ctMethod.getReturnType() == ctResultSetClass) {
                methodBuffer.append("return new ProxyResultSet(delegate." + methodName + "($$),pConn);");
            } else if (ctMethod.getReturnType() == CtClass.voidType) {
                methodBuffer.append("delegate." + methodName + "($$);");
            } else {
                methodBuffer.append("return delegate." + methodName + "($$);");
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctProxyDatabaseMetaDataClass.addMethod(newCtMethodm);
        }
        return ctProxyDatabaseMetaDataClass.toClass();
    }

    private Class createProxyResultSetClass(ClassPool classPool, CtClass ctResultSetClassProxyClass, CtClass ctResultSetClass, CtClass ctResultSetClassSuperClass) throws Exception {
        CtMethod[] ctSuperClassMethods = ctResultSetClassSuperClass.getMethods();
        HashSet<String> superClassSignatureSet = new HashSet<String>();
        int l = ctSuperClassMethods.length;
        for (int i = 0; i < l; ++i) {
            int modifiers = ctSuperClassMethods[i].getModifiers();
            if ((Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers)) && !Modifier.isFinal((int)modifiers) && !Modifier.isStatic((int)modifiers) && !Modifier.isNative((int)modifiers)) continue;
            superClassSignatureSet.add(ctSuperClassMethods[i].getName() + ctSuperClassMethods[i].getSignature());
        }
        LinkedList linkedList = new LinkedList();
        this.resolveInterfaceMethods(ctResultSetClass, linkedList, superClassSignatureSet);
        StringBuilder methodBuffer = new StringBuilder(25);
        for (CtMethod ctMethod : linkedList) {
            String methodName = ctMethod.getName();
            CtMethod newCtMethodm = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)ctResultSetClassProxyClass, null);
            newCtMethodm.setModifiers(1);
            methodBuffer.delete(0, methodBuffer.length());
            methodBuffer.append("{");
            if (!methodName.equals("close")) {
                if (ctMethod.getReturnType() == CtClass.voidType) {
                    methodBuffer.append("delegate." + methodName + "($$);");
                    if (methodName.startsWith("insertRow") || methodName.startsWith("updateRow") || methodName.startsWith("deleteRow")) {
                        methodBuffer.append(" pConn.updateAccessTime();");
                    }
                } else if (methodName.startsWith("insertRow") || methodName.startsWith("updateRow") || methodName.startsWith("deleteRow")) {
                    methodBuffer.append(ctMethod.getReturnType().getName() + " re=delegate." + methodName + "($$);").append(" pConn.updateAccessTime();").append(" return re;");
                } else {
                    methodBuffer.append("return delegate." + methodName + "($$);");
                }
            }
            methodBuffer.append("}");
            newCtMethodm.setBody(methodBuffer.toString());
            ctResultSetClassProxyClass.addMethod(newCtMethodm);
        }
        return ctResultSetClassProxyClass.toClass();
    }

    private void resolveInterfaceMethods(CtClass interfaceClass, LinkedList linkedList, HashSet exitSignatureSet) throws Exception {
        CtMethod[] ctMethods = interfaceClass.getDeclaredMethods();
        for (int i = 0; i < ctMethods.length; ++i) {
            int modifiers = ctMethods[i].getModifiers();
            String signature = ctMethods[i].getName() + ctMethods[i].getSignature();
            if (!Modifier.isAbstract((int)modifiers) || !Modifier.isPublic((int)modifiers) && !Modifier.isProtected((int)modifiers) || Modifier.isStatic((int)modifiers) || Modifier.isFinal((int)modifiers) || exitSignatureSet.contains(signature)) continue;
            linkedList.add(ctMethods[i]);
            exitSignatureSet.add(signature);
        }
        CtClass[] superInterfaces = interfaceClass.getInterfaces();
        for (int i = 0; i < superInterfaces.length; ++i) {
            this.resolveInterfaceMethods(superInterfaces[i], linkedList, exitSignatureSet);
        }
    }
}

