/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.pool.StatementArray;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ThreadPoolExecutor;

class PooledConnection {
    private static final boolean[] FALSE_ARRAY = new boolean[6];
    volatile int state;
    Connection rawConn;
    ProxyConnectionBase proxyConn;
    volatile long lastAccessTime;
    boolean commitDirtyInd;
    boolean curAutoCommit;
    boolean defaultAutoCommit;
    int defaultTransactionIsolationCode;
    boolean defaultReadOnly;
    String defaultCatalog;
    String defaultSchema;
    int defaultNetworkTimeout;
    StatementArray tracedStatements;
    private ThreadPoolExecutor defaultNetworkTimeoutExecutor;
    private FastConnectionPool pool;
    private int resetCnt;
    private boolean[] resetInd = new boolean[FALSE_ARRAY.length];

    public PooledConnection(Connection rawConn, int connState, FastConnectionPool connPool, BeeDataSourceConfig config) {
        this.pool = connPool;
        this.state = connState;
        this.rawConn = rawConn;
        this.defaultTransactionIsolationCode = config.getDefaultTransactionIsolationCode();
        this.defaultReadOnly = config.isDefaultReadOnly();
        this.defaultCatalog = config.getDefaultCatalog();
        this.defaultSchema = config.getDefaultSchema();
        this.defaultNetworkTimeout = this.pool.getNetworkTimeout();
        this.defaultNetworkTimeoutExecutor = this.pool.getNetworkTimeoutExecutor();
        this.curAutoCommit = this.defaultAutoCommit = config.isDefaultAutoCommit();
        this.tracedStatements = new StatementArray(10);
        this.lastAccessTime = System.currentTimeMillis();
    }

    void closeRawConn() {
        try {
            this.resetRawConnOnReturn();
        }
        catch (Throwable e) {
            PoolStaticCenter.commonLog.error("Connection close error", e);
        }
        finally {
            PoolStaticCenter.oclose(this.rawConn);
        }
    }

    final void recycleSelf() throws SQLException {
        try {
            this.proxyConn = null;
            this.resetRawConnOnReturn();
            this.pool.recycle(this);
        }
        catch (SQLException e) {
            this.pool.abandonOnReturn(this);
            throw e;
        }
    }

    final void updateAccessTime() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    final void setResetInd(int p, boolean chgd) {
        if (!this.resetInd[p] && chgd) {
            ++this.resetCnt;
        } else if (this.resetInd[p] && !chgd) {
            --this.resetCnt;
        }
        this.resetInd[p] = chgd;
    }

    boolean supportIsValid() {
        return this.pool.supportIsValid();
    }

    boolean supportSchema() {
        return this.pool.supportSchema();
    }

    boolean supportNetworkTimeout() {
        return this.pool.supportNetworkTimeout();
    }

    final void resetRawConnOnReturn() throws SQLException {
        if (!this.curAutoCommit && this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.resetCnt > 0) {
            if (this.resetInd[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.resetInd[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolationCode);
            }
            if (this.resetInd[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.resetInd[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.resetInd[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.resetInd[5]) {
                this.rawConn.setNetworkTimeout(this.defaultNetworkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.resetCnt = 0;
            System.arraycopy(FALSE_ARRAY, 0, this.resetInd, 0, 6);
        }
        this.rawConn.clearWarnings();
    }
}

