/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.ConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJmxBean;
import cn.beecp.pool.ConnectionPoolMonitorVo;
import cn.beecp.pool.PoolStaticCenter;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnectionBase;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class FastConnectionPool
extends Thread
implements ConnectionPool,
ConnectionPoolJmxBean {
    private static final long spinForTimeoutThreshold = 1000L;
    private static final int maxTimedSpins = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConnStUpd = AtomicIntegerFieldUpdater.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BwrStUpd = AtomicReferenceFieldUpdater.newUpdater(Borrower.class, Object.class, "state");
    private static final String DESC_REMOVE_PRE_INIT = "pre_init";
    private static final String DESC_REMOVE_INIT = "init";
    private static final String DESC_REMOVE_BAD = "bad";
    private static final String DESC_REMOVE_IDLE = "idle";
    private static final String DESC_REMOVE_CLOSED = "closed";
    private static final String DESC_REMOVE_CLEAR = "clear";
    private static final String DESC_REMOVE_DESTROY = "destroy";
    private static final AtomicInteger poolNameIndex = new AtomicInteger(1);
    private final Object connArrayLock = new Object();
    private final ConcurrentLinkedQueue<Borrower> waitQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<WeakReference<Borrower>> threadLocal = new ThreadLocal();
    private final ConnectionPoolMonitorVo monitorVo = new ConnectionPoolMonitorVo();
    private int poolMaxSize;
    private long defaultMaxWaitNanos;
    private int conUnCatchStateCode;
    private int connectionTestTimeout;
    private long connectionTestInterval;
    private ConnectionTester connectionTester;
    private long delayTimeForNextClearNanos;
    private ConnectionPoolHook exitHook;
    private BeeDataSourceConfig poolConfig;
    private int borrowSemaphoreSize;
    private Semaphore borrowSemaphore;
    private TransferPolicy transferPolicy;
    private ConnectionFactory connFactory;
    private volatile PooledConnection[] connArray = new PooledConnection[0];
    private ScheduledFuture<?> idleCheckSchFuture;
    private ScheduledThreadPoolExecutor idleSchExecutor = new ScheduledThreadPoolExecutor(2, new PoolThreadThreadFactory("IdleConnectionScan"));
    private int networkTimeout;
    private boolean supportSchema = true;
    private boolean supportNetworkTimeout = true;
    private boolean supportQueryTimeout = true;
    private boolean supportIsValid = true;
    private String poolName = "";
    private String poolMode = "";
    private AtomicInteger poolState = new AtomicInteger(1);
    private AtomicInteger createConnThreadState = new AtomicInteger(1);
    private AtomicInteger needAddConnSize = new AtomicInteger(0);

    @Override
    public void init(BeeDataSourceConfig config) throws SQLException {
        if (this.poolState.get() == 1) {
            this.checkProxyClasses();
            if (config == null) {
                throw new SQLException("Configuration can't be null");
            }
            this.poolConfig = config.check();
            this.poolName = !PoolStaticCenter.isBlank(config.getPoolName()) ? config.getPoolName() : "FastPool-" + poolNameIndex.getAndIncrement();
            PoolStaticCenter.commonLog.info("BeeCP({})starting....", (Object)this.poolName);
            this.poolMaxSize = this.poolConfig.getMaxActive();
            this.connFactory = this.poolConfig.getConnectionFactory();
            this.connectionTestTimeout = this.poolConfig.getConnectionTestTimeout();
            this.connectionTester = new SQLQueryTester(this.poolConfig.isDefaultAutoCommit(), this.poolConfig.getConnectionTestSQL());
            this.defaultMaxWaitNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
            this.delayTimeForNextClearNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getDelayTimeForNextClear());
            this.connectionTestInterval = this.poolConfig.getConnectionTestInterval();
            this.createInitConnections(this.poolConfig.getInitialSize());
            if (this.poolConfig.isFairMode()) {
                this.poolMode = "fair";
                this.transferPolicy = new FairTransferPolicy();
                this.conUnCatchStateCode = this.transferPolicy.getCheckStateCode();
            } else {
                this.poolMode = "compete";
                this.transferPolicy = new CompeteTransferPolicy();
                this.conUnCatchStateCode = this.transferPolicy.getCheckStateCode();
            }
        } else {
            throw new SQLException("Pool has initialized");
        }
        this.exitHook = new ConnectionPoolHook();
        Runtime.getRuntime().addShutdownHook(this.exitHook);
        this.borrowSemaphoreSize = this.poolConfig.getBorrowSemaphoreSize();
        this.borrowSemaphore = new Semaphore(this.borrowSemaphoreSize, this.poolConfig.isFairMode());
        this.idleSchExecutor.setKeepAliveTime(15L, TimeUnit.SECONDS);
        this.idleSchExecutor.allowCoreThreadTimeOut(true);
        this.idleCheckSchFuture = this.idleSchExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FastConnectionPool.this.closeIdleTimeoutConnection();
            }
        }, 1000L, config.getIdleCheckTimeInterval(), TimeUnit.MILLISECONDS);
        this.registerJmx();
        PoolStaticCenter.commonLog.info("BeeCP({})has startup{mode:{},init size:{},max size:{},semaphore size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, this.poolMode, this.connArray.length, config.getMaxActive(), this.borrowSemaphoreSize, this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
        this.poolState.set(2);
        this.setDaemon(true);
        this.setName("PooledConnectionAdd");
        this.start();
    }

    private void checkProxyClasses() throws SQLException {
        try {
            boolean classInitialize = false;
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class.forName("cn.beecp.pool.Borrower", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.PooledConnection", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyConnection", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyStatement", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyPsStatement", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyCsStatement", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyDatabaseMetaData", classInitialize, classLoader);
            Class.forName("cn.beecp.pool.ProxyResultSet", classInitialize, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Jdbc proxy classes missed", e);
        }
    }

    boolean supportIsValid() {
        return this.supportIsValid;
    }

    boolean supportSchema() {
        return this.supportSchema;
    }

    boolean supportNetworkTimeout() {
        return this.supportNetworkTimeout;
    }

    int getNetworkTimeout() {
        return this.networkTimeout;
    }

    ThreadPoolExecutor getNetworkTimeoutExecutor() {
        return this.idleSchExecutor;
    }

    private final boolean existBorrower() {
        return this.borrowSemaphoreSize > this.borrowSemaphore.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PooledConnection createPooledConn(int connState) throws SQLException {
        Object object = this.connArrayLock;
        synchronized (object) {
            int arrayLen = this.connArray.length;
            if (arrayLen < this.poolMaxSize) {
                PoolStaticCenter.commonLog.debug("BeeCP({}))begin to create new pooled connection,state:{}", (Object)this.poolName, (Object)connState);
                Connection con = this.connFactory.create();
                this.setDefaultOnRawConn(con);
                PooledConnection pConn = new PooledConnection(con, connState, this, this.poolConfig);
                PoolStaticCenter.commonLog.debug("BeeCP({}))has created new pooled connection:{},state:{}", new Object[]{this.poolName, pConn, connState});
                PooledConnection[] arrayNew = new PooledConnection[arrayLen + 1];
                System.arraycopy(this.connArray, 0, arrayNew, 0, arrayLen);
                arrayNew[arrayLen] = pConn;
                this.connArray = arrayNew;
                return pConn;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePooledConn(PooledConnection pConn, String removeType) {
        PoolStaticCenter.commonLog.debug("BeeCP({}))begin to remove pooled connection:{},reason:{}", new Object[]{this.poolName, pConn, removeType});
        pConn.state = 3;
        pConn.closeRawConn();
        Object object = this.connArrayLock;
        synchronized (object) {
            int oldLen = this.connArray.length;
            PooledConnection[] arrayNew = new PooledConnection[oldLen - 1];
            for (int i = 0; i < oldLen; ++i) {
                if (this.connArray[i] != pConn) continue;
                System.arraycopy(this.connArray, 0, arrayNew, 0, i);
                int m = oldLen - i - 1;
                if (m <= 0) break;
                System.arraycopy(this.connArray, i + 1, arrayNew, i, m);
                break;
            }
            PoolStaticCenter.commonLog.debug("BeeCP({}))has removed pooled connection:{},reason:{}", new Object[]{this.poolName, pConn, removeType});
            this.connArray = arrayNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultOnRawConn(Connection rawConn) {
        try {
            rawConn.setAutoCommit(this.poolConfig.isDefaultAutoCommit());
        }
        catch (Throwable e) {
            PoolStaticCenter.commonLog.warn("BeeCP({})failed to set default on executing 'setAutoCommit',cause:{}", (Object)this.poolName, (Object)e);
        }
        try {
            rawConn.setTransactionIsolation(this.poolConfig.getDefaultTransactionIsolationCode());
        }
        catch (Throwable e) {
            PoolStaticCenter.commonLog.warn("BeeCP({}))failed to set default on executing to 'setTransactionIsolation',cause:{}", (Object)this.poolName, (Object)e);
        }
        try {
            rawConn.setReadOnly(this.poolConfig.isDefaultReadOnly());
        }
        catch (Throwable e) {
            PoolStaticCenter.commonLog.warn("BeeCP({}))failed to set default on executing to 'setReadOnly',cause:{}", (Object)this.poolName, (Object)e);
        }
        if (!PoolStaticCenter.isBlank(this.poolConfig.getDefaultCatalog())) {
            try {
                rawConn.setCatalog(this.poolConfig.getDefaultCatalog());
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.warn("BeeCP({}))failed to set default on executing to 'setCatalog',cause:{}", (Object)this.poolName, (Object)e);
            }
        }
        if (this.supportSchema && !PoolStaticCenter.isBlank(this.poolConfig.getDefaultSchema())) {
            try {
                rawConn.setSchema(this.poolConfig.getDefaultSchema());
            }
            catch (Throwable e) {
                this.supportSchema = false;
                PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'schema',cause:{}", (Object)this.poolName, (Object)e);
            }
        }
        if (this.supportNetworkTimeout) {
            try {
                this.networkTimeout = rawConn.getNetworkTimeout();
                if (this.networkTimeout < 0) {
                    this.supportNetworkTimeout = false;
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                } else {
                    rawConn.setNetworkTimeout(this.getNetworkTimeoutExecutor(), this.networkTimeout);
                }
            }
            catch (Throwable e) {
                this.supportNetworkTimeout = false;
                PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'networkTimeout',cause:{}", (Object)this.poolName, (Object)e);
            }
        }
        if (this.supportIsValid) {
            try {
                if (rawConn.isValid(this.connectionTestTimeout)) {
                    this.connectionTester = new ConnValidTester();
                } else {
                    this.supportIsValid = false;
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
                }
            }
            catch (Throwable e) {
                this.supportIsValid = false;
                PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'isValid',cause:{}", (Object)this.poolName, (Object)e);
                Statement st = null;
                try {
                    st = rawConn.createStatement();
                    st.setQueryTimeout(this.connectionTestTimeout);
                }
                catch (Throwable ee) {
                    this.supportQueryTimeout = false;
                    PoolStaticCenter.commonLog.warn("BeeCP({})driver not support 'queryTimeout',cause:{}", (Object)this.poolName, (Object)e);
                }
                finally {
                    if (st != null) {
                        PoolStaticCenter.oclose(st);
                    }
                }
            }
        }
    }

    private final boolean testOnBorrow(PooledConnection pConn) {
        if (System.currentTimeMillis() - pConn.lastAccessTime - this.connectionTestInterval >= 0L && !this.connectionTester.isAlive(pConn)) {
            this.removePooledConn(pConn, DESC_REMOVE_BAD);
            this.tryToCreateNewConnByAsyn();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInitConnections(int initSize) throws SQLException {
        if (initSize == 0) {
            PooledConnection pConn = null;
            try {
                pConn = this.createPooledConn(1);
            }
            catch (Throwable throwable) {
            }
            finally {
                if (pConn != null) {
                    try {
                        this.removePooledConn(pConn, DESC_REMOVE_PRE_INIT);
                    }
                    catch (Throwable throwable) {}
                }
            }
        } else {
            try {
                for (int i = 0; i < initSize; ++i) {
                    this.createPooledConn(1);
                }
            }
            catch (SQLException e) {
                for (PooledConnection pConn : this.connArray) {
                    this.removePooledConn(pConn, DESC_REMOVE_INIT);
                }
                throw e;
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Borrower borrower;
        if (this.poolState.get() != 2) {
            throw PoolStaticCenter.PoolCloseException;
        }
        WeakReference<Borrower> ref = this.threadLocal.get();
        Borrower borrower2 = borrower = ref != null ? (Borrower)ref.get() : null;
        if (borrower != null) {
            PooledConnection pConn = borrower.lastUsedConn;
            if (pConn != null && pConn.state == 1 && ConnStUpd.compareAndSet(pConn, 1, 2)) {
                if (this.testOnBorrow(pConn)) {
                    return PoolStaticCenter.createProxyConnection(pConn, borrower);
                }
                borrower.lastUsedConn = null;
            }
        } else {
            borrower = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(borrower));
        }
        long deadlineNanos = System.nanoTime() + this.defaultMaxWaitNanos;
        try {
            if (!this.borrowSemaphore.tryAcquire(this.defaultMaxWaitNanos, TimeUnit.NANOSECONDS)) {
                throw PoolStaticCenter.RequestTimeoutException;
            }
        }
        catch (InterruptedException e) {
            throw PoolStaticCenter.RequestInterruptException;
        }
        try {
            int spinSize;
            PooledConnection pConn2;
            for (PooledConnection pConn2 : this.connArray) {
                if (pConn2.state != 1 || !ConnStUpd.compareAndSet(pConn2, 1, 2) || !this.testOnBorrow(pConn2)) continue;
                Connection connection = PoolStaticCenter.createProxyConnection(pConn2, borrower);
                return connection;
            }
            if (this.connArray.length < this.poolMaxSize && (pConn2 = this.createPooledConn(2)) != null) {
                Connection i = PoolStaticCenter.createProxyConnection(pConn2, borrower);
                return i;
            }
            boolean failed = false;
            SQLException failedCause = null;
            Thread cThread = borrower.thread;
            borrower.state = PoolStaticCenter.BORROWER_NORMAL;
            this.waitQueue.offer(borrower);
            int n = spinSize = this.waitQueue.peek() == borrower ? maxTimedSpins : 0;
            while (true) {
                Object state;
                if ((state = borrower.state) instanceof PooledConnection) {
                    pConn2 = (PooledConnection)state;
                    if (this.transferPolicy.tryCatch(pConn2) && this.testOnBorrow(pConn2)) {
                        this.waitQueue.remove(borrower);
                        Connection connection = PoolStaticCenter.createProxyConnection(pConn2, borrower);
                        return connection;
                    }
                } else if (state instanceof SQLException) {
                    this.waitQueue.remove(borrower);
                    throw (SQLException)state;
                }
                if (failed) {
                    if (borrower.state != state) continue;
                    BwrStUpd.compareAndSet(borrower, state, failedCause);
                    continue;
                }
                if (state instanceof PooledConnection) {
                    borrower.state = PoolStaticCenter.BORROWER_NORMAL;
                    FastConnectionPool.yield();
                    continue;
                }
                long timeout = deadlineNanos - System.nanoTime();
                if (timeout > 0L) {
                    if (spinSize > 0) {
                        --spinSize;
                        continue;
                    }
                    if (timeout - 1000L <= 0L || borrower.state != state || !BwrStUpd.compareAndSet(borrower, state, PoolStaticCenter.BORROWER_WAITING)) continue;
                    LockSupport.parkNanos(timeout);
                    if (cThread.isInterrupted()) {
                        failed = true;
                        failedCause = PoolStaticCenter.RequestInterruptException;
                    }
                    if (borrower.state != PoolStaticCenter.BORROWER_WAITING) continue;
                    BwrStUpd.compareAndSet(borrower, PoolStaticCenter.BORROWER_WAITING, failed ? failedCause : PoolStaticCenter.BORROWER_NORMAL);
                    continue;
                }
                failed = true;
                failedCause = PoolStaticCenter.RequestTimeoutException;
                if (borrower.state != state) continue;
                BwrStUpd.compareAndSet(borrower, state, failedCause);
            }
        }
        finally {
            this.borrowSemaphore.release();
        }
    }

    void abandonOnReturn(PooledConnection pConn) {
        this.removePooledConn(pConn, DESC_REMOVE_BAD);
        this.tryToCreateNewConnByAsyn();
    }

    @Override
    public final void recycle(PooledConnection pConn) {
        this.transferPolicy.beforeTransfer(pConn);
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            while (state == PoolStaticCenter.BORROWER_NORMAL || state == PoolStaticCenter.BORROWER_WAITING) {
                if (pConn.state - this.conUnCatchStateCode != 0) {
                    return;
                }
                if (BwrStUpd.compareAndSet(borrower, state, pConn)) {
                    if (state == PoolStaticCenter.BORROWER_WAITING) {
                        LockSupport.unpark(borrower.thread);
                    }
                    return;
                }
                state = borrower.state;
            }
        }
        this.transferPolicy.onFailedTransfer(pConn);
    }

    private void transferException(SQLException exception) {
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            while (state == PoolStaticCenter.BORROWER_NORMAL || state == PoolStaticCenter.BORROWER_WAITING) {
                if (BwrStUpd.compareAndSet(borrower, state, exception)) {
                    if (state == PoolStaticCenter.BORROWER_WAITING) {
                        LockSupport.unpark(borrower.thread);
                    }
                    return;
                }
                state = borrower.state;
            }
        }
    }

    private void closeIdleTimeoutConnection() {
        if (this.poolState.get() == 2) {
            for (PooledConnection pConn : this.connArray) {
                int state = pConn.state;
                if (state == 1 && !this.existBorrower()) {
                    boolean isTimeoutInIdle;
                    boolean bl = isTimeoutInIdle = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getIdleTimeout() >= 0L;
                    if (!isTimeoutInIdle || !ConnStUpd.compareAndSet(pConn, state, 3)) continue;
                    this.removePooledConn(pConn, DESC_REMOVE_IDLE);
                    this.tryToCreateNewConnByAsyn();
                    continue;
                }
                if (state == 2) {
                    boolean isHoldTimeoutInNotUsing;
                    ProxyConnectionBase proxyConn = pConn.proxyConn;
                    boolean bl = isHoldTimeoutInNotUsing = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getHoldTimeout() >= 0L;
                    if (!isHoldTimeoutInNotUsing) continue;
                    if (proxyConn != null) {
                        proxyConn.trySetAsClosed();
                        continue;
                    }
                    this.removePooledConn(pConn, DESC_REMOVE_BAD);
                    this.tryToCreateNewConnByAsyn();
                    continue;
                }
                if (state != 3) continue;
                this.removePooledConn(pConn, DESC_REMOVE_CLOSED);
                this.tryToCreateNewConnByAsyn();
            }
            ConnectionPoolMonitorVo vo = this.getMonitorVo();
            PoolStaticCenter.commonLog.debug("BeeCP({})idle:{},using:{},semaphore-waiter:{},wait-transfer:{}", new Object[]{this.poolName, vo.getIdleSize(), vo.getUsingSize(), vo.getSemaphoreWaiterSize(), vo.getTransferWaiterSize()});
        }
    }

    @Override
    public void close() throws SQLException {
        while (true) {
            if (this.poolState.compareAndSet(2, 3)) {
                PoolStaticCenter.commonLog.info("BeeCP({})begin to shutdown", (Object)this.poolName);
                this.removeAllConnections(this.poolConfig.isForceCloseUsingOnClear(), DESC_REMOVE_DESTROY);
                this.unregisterJmx();
                this.shutdownCreateConnThread();
                while (!this.idleCheckSchFuture.isCancelled() && !this.idleCheckSchFuture.isDone()) {
                    this.idleCheckSchFuture.cancel(true);
                }
                this.idleSchExecutor.getQueue().clear();
                this.idleSchExecutor.shutdownNow();
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                PoolStaticCenter.commonLog.info("BeeCP({})has shutdown", (Object)this.poolName);
                break;
            }
            if (this.poolState.get() == 3) break;
            LockSupport.parkNanos(this.delayTimeForNextClearNanos);
        }
    }

    @Override
    public boolean isClosed() {
        return this.poolState.get() == 3;
    }

    private void removeAllConnections(boolean force, String source) {
        while (this.existBorrower()) {
            this.transferException(PoolStaticCenter.PoolCloseException);
        }
        while (this.connArray.length > 0) {
            for (PooledConnection pConn : this.connArray) {
                if (ConnStUpd.compareAndSet(pConn, 1, 3)) {
                    this.removePooledConn(pConn, source);
                    continue;
                }
                if (pConn.state == 3) {
                    this.removePooledConn(pConn, source);
                    continue;
                }
                if (pConn.state != 2) continue;
                ProxyConnectionBase proxyConn = pConn.proxyConn;
                if (proxyConn != null) {
                    boolean isTimeout;
                    if (force) {
                        proxyConn.trySetAsClosed();
                        continue;
                    }
                    boolean bl = isTimeout = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getHoldTimeout() >= 0L;
                    if (!isTimeout) continue;
                    proxyConn.trySetAsClosed();
                    continue;
                }
                this.removePooledConn(pConn, source);
            }
            if (this.connArray.length <= 0) continue;
            LockSupport.parkNanos(this.delayTimeForNextClearNanos);
        }
    }

    private void tryToCreateNewConnByAsyn() {
        int updAddSize;
        int curAddSize;
        do {
            if (this.connArray.length + (updAddSize = (curAddSize = this.needAddConnSize.get()) + 1) <= this.poolMaxSize) continue;
            return;
        } while (!this.needAddConnSize.compareAndSet(curAddSize, updAddSize));
        if (this.createConnThreadState.get() == 2 && this.createConnThreadState.compareAndSet(2, 1)) {
            LockSupport.unpark(this);
        }
    }

    private void shutdownCreateConnThread() {
        block1: {
            int curSts;
            while ((curSts = this.createConnThreadState.get()) != 1 && curSts != 2 || !this.createConnThreadState.compareAndSet(curSts, 3)) {
            }
            if (curSts != 2) break block1;
            LockSupport.unpark(this);
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.needAddConnSize.get() > 0) {
                this.needAddConnSize.decrementAndGet();
                if (this.waitQueue.isEmpty()) continue;
                try {
                    PooledConnection pConn = this.createPooledConn(2);
                    if (pConn == null) continue;
                    this.recycle(pConn);
                }
                catch (SQLException e) {
                    this.transferException(e);
                }
                continue;
            }
            if (this.needAddConnSize.get() == 0 && this.createConnThreadState.compareAndSet(1, 2)) {
                LockSupport.park(this);
            }
            if (this.createConnThreadState.get() == 3) break;
        }
    }

    @Override
    public void clearAllConnections() {
        this.clearAllConnections(false);
    }

    @Override
    public void clearAllConnections(boolean force) {
        if (this.poolState.compareAndSet(2, 4)) {
            PoolStaticCenter.commonLog.info("BeeCP({})begin to remove connections", (Object)this.poolName);
            this.removeAllConnections(force, DESC_REMOVE_CLEAR);
            PoolStaticCenter.commonLog.info("BeeCP({})all connections were removed", (Object)this.poolName);
            this.poolState.set(2);
            PoolStaticCenter.commonLog.info("BeeCP({})restore to accept new requests", (Object)this.poolName);
        }
    }

    @Override
    public int getConnTotalSize() {
        return this.connArray.length;
    }

    @Override
    public int getConnIdleSize() {
        int idleConnections = 0;
        for (PooledConnection pConn : this.connArray) {
            if (pConn.state != 1) continue;
            ++idleConnections;
        }
        return idleConnections;
    }

    @Override
    public int getConnUsingSize() {
        int active = this.connArray.length - this.getConnIdleSize();
        return active > 0 ? active : 0;
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowSemaphoreSize() - this.borrowSemaphore.availablePermits();
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.borrowSemaphore.getQueueLength();
    }

    @Override
    public int getTransferWaitingSize() {
        int size = 0;
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            if (state != PoolStaticCenter.BORROWER_NORMAL && state != PoolStaticCenter.BORROWER_WAITING) continue;
            ++size;
        }
        return size;
    }

    @Override
    public ConnectionPoolMonitorVo getMonitorVo() {
        int totSize = this.getConnTotalSize();
        int idleSize = this.getConnIdleSize();
        this.monitorVo.setPoolName(this.poolName);
        this.monitorVo.setPoolMode(this.poolMode);
        this.monitorVo.setPoolState(this.poolState.get());
        this.monitorVo.setMaxActive(this.poolMaxSize);
        this.monitorVo.setIdleSize(idleSize);
        this.monitorVo.setUsingSize(totSize - idleSize);
        this.monitorVo.setSemaphoreWaiterSize(this.getSemaphoreWaitingSize());
        this.monitorVo.setTransferWaiterSize(this.getTransferWaitingSize());
        return this.monitorVo;
    }

    private void registerJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJmxBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            PoolStaticCenter.commonLog.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJmx() {
        if (this.poolConfig.isEnableJmx()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJmxBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJmxBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            PoolStaticCenter.commonLog.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    class ConnValidTester
    implements ConnectionTester {
        ConnValidTester() {
        }

        @Override
        public boolean isAlive(PooledConnection pConn) {
            Connection con = pConn.rawConn;
            try {
                if (con.isValid(FastConnectionPool.this.connectionTestTimeout)) {
                    pConn.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.error("BeeCP({})failed to test connection", (Object)FastConnectionPool.this.poolName, (Object)e);
            }
            return false;
        }
    }

    class SQLQueryTester
    implements ConnectionTester {
        private final boolean autoCommit;
        private final String aliveTestSQL;

        public SQLQueryTester(boolean autoCommit, String aliveTestSQL) {
            this.autoCommit = autoCommit;
            this.aliveTestSQL = aliveTestSQL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAlive(PooledConnection pConn) {
            boolean autoCommitChged = false;
            Statement st = null;
            Connection con = pConn.rawConn;
            try {
                if (this.autoCommit) {
                    con.setAutoCommit(false);
                    autoCommitChged = true;
                }
                st = con.createStatement();
                pConn.lastAccessTime = System.currentTimeMillis();
                if (FastConnectionPool.this.supportQueryTimeout) {
                    try {
                        st.setQueryTimeout(FastConnectionPool.this.connectionTestTimeout);
                    }
                    catch (Throwable e) {
                        PoolStaticCenter.commonLog.error("BeeCP({})failed to setQueryTimeout", (Object)FastConnectionPool.this.poolName, (Object)e);
                    }
                }
                st.execute(this.aliveTestSQL);
                con.rollback();
                boolean e = true;
                return e;
            }
            catch (Throwable e) {
                PoolStaticCenter.commonLog.error("BeeCP({})failed to test connection", (Object)FastConnectionPool.this.poolName, (Object)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (st != null) {
                    PoolStaticCenter.oclose(st);
                }
                if (this.autoCommit && autoCommitChged) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (Throwable e) {
                        PoolStaticCenter.commonLog.error("BeeCP({})failed to execute 'rollback or setAutoCommit(true)' after connection test", (Object)FastConnectionPool.this.poolName, (Object)e);
                    }
                }
            }
        }
    }

    private class ConnectionPoolHook
    extends Thread {
        private ConnectionPoolHook() {
        }

        @Override
        public void run() {
            try {
                FastConnectionPool.this.close();
            }
            catch (SQLException e) {
                PoolStaticCenter.commonLog.error("Error at closing connection pool,cause:", (Throwable)e);
            }
        }
    }

    static final class FairTransferPolicy
    implements TransferPolicy {
        FairTransferPolicy() {
        }

        @Override
        public final int getCheckStateCode() {
            return 2;
        }

        @Override
        public final boolean tryCatch(PooledConnection pConn) {
            return pConn.state == 2;
        }

        @Override
        public final void onFailedTransfer(PooledConnection pConn) {
            pConn.state = 1;
        }

        @Override
        public final void beforeTransfer(PooledConnection pConn) {
        }
    }

    static final class CompeteTransferPolicy
    implements TransferPolicy {
        CompeteTransferPolicy() {
        }

        @Override
        public final int getCheckStateCode() {
            return 1;
        }

        @Override
        public final boolean tryCatch(PooledConnection pConn) {
            return ConnStUpd.compareAndSet(pConn, 1, 2);
        }

        @Override
        public final void onFailedTransfer(PooledConnection pConn) {
        }

        @Override
        public final void beforeTransfer(PooledConnection pConn) {
            pConn.state = 1;
        }
    }

    static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private String thName;

        public PoolThreadThreadFactory(String thName) {
            this.thName = thName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.thName);
            th.setDaemon(true);
            return th;
        }
    }

    static interface TransferPolicy {
        public int getCheckStateCode();

        public void beforeTransfer(PooledConnection var1);

        public boolean tryCatch(PooledConnection var1);

        public void onFailedTransfer(PooledConnection var1);
    }

    static interface ConnectionTester {
        public boolean isAlive(PooledConnection var1);
    }
}

