/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.pool.PoolExceptionList;
import cn.beecp.pool.PooledConnection;
import cn.beecp.util.BeecpUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Executor;

abstract class ProxyConnectionBase
implements Connection {
    protected Connection delegate;
    protected PooledConnection pConn;
    private boolean closedInd;
    private static final int Pos_AutoCommitInd = 0;
    private static final int Pos_TransactionIsolationInd = 1;
    private static final int Pos_ReadOnlyInd = 2;
    private static final int Pos_CatalogInd = 3;
    private static final int Pos_SchemaInd = 4;
    private static final int Pos_NetworkTimeoutInd = 5;

    public ProxyConnectionBase(PooledConnection pConn) {
        this.pConn = pConn;
        pConn.proxyConn = this;
        this.delegate = pConn.rawConn;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closedInd;
    }

    protected void checkClosed() throws SQLException {
        if (this.closedInd) {
            throw PoolExceptionList.ConnectionClosedException;
        }
    }

    synchronized boolean setAsClosed() {
        return this.closedInd ? false : (this.closedInd = true);
    }

    @Override
    public void close() throws SQLException {
        if (!this.setAsClosed()) {
            throw PoolExceptionList.ConnectionClosedException;
        }
        this.pConn.returnToPoolBySelf();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!this.pConn.curAutoCommit && this.pConn.commitDirtyInd) {
            throw PoolExceptionList.AutoCommitChangeForbiddenException;
        }
        this.delegate.setAutoCommit(autoCommit);
        this.pConn.curAutoCommit = autoCommit;
        if (autoCommit) {
            this.pConn.commitDirtyInd = false;
        }
        this.pConn.setChangedInd(0, autoCommit != this.pConn.defaultAutoCommit);
        this.pConn.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        this.delegate.setTransactionIsolation(level);
        this.pConn.setChangedInd(1, level != this.pConn.defaultTransactionIsolationCode);
        this.pConn.lastAccessTime = System.currentTimeMillis();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.delegate.setReadOnly(readOnly);
        this.pConn.setChangedInd(2, readOnly != this.pConn.defaultReadOnly);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.delegate.setCatalog(catalog);
        this.pConn.setChangedInd(3, !BeecpUtil.equalsText(catalog, this.pConn.defaultCatalog));
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkClosed();
        this.delegate.setSchema(schema);
        this.pConn.setChangedInd(4, !BeecpUtil.equalsText(schema, this.pConn.defaultSchema));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkClosed();
        if (executor == null) {
            throw new SQLException("executor can't be null");
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ProxyConnectionBase.this.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.checkClosed();
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosed();
        if (!this.pConn.isSupportNetworkTimeout()) {
            throw PoolExceptionList.DriverNotSupportNetworkTimeoutException;
        }
        this.delegate.setNetworkTimeout(executor, milliseconds);
        this.pConn.setChangedInd(5, milliseconds != this.pConn.defaultNetworkTimeout);
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        this.delegate.commit();
        this.pConn.lastAccessTime = System.currentTimeMillis();
        this.pConn.commitDirtyInd = false;
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        this.delegate.rollback();
        this.pConn.lastAccessTime = System.currentTimeMillis();
        this.pConn.commitDirtyInd = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }
}

