/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.FastConnectionPool;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.util.BeecpUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PooledConnection
extends LinkedHashMap<Object, PreparedStatement> {
    volatile int state;
    boolean stmCacheValid;
    Connection rawConn;
    ProxyConnectionBase proxyConn;
    private int stmCacheSize;
    volatile long lastAccessTime;
    boolean commitDirtyInd;
    boolean curAutoCommit;
    boolean defaultAutoCommit;
    int defaultTransactionIsolationCode;
    boolean defaultReadOnly;
    String defaultCatalog;
    String defaultSchema;
    int defaultNetworkTimeout;
    private ThreadPoolExecutor defaultNetworkTimeoutExecutor;
    private FastConnectionPool pool;
    private short changedCount;
    private boolean[] changedInd = new boolean[6];
    private static final boolean[] DEFAULT_IND = new boolean[]{false, false, false, false, false, false};
    private static Logger log = LoggerFactory.getLogger(PooledConnection.class);

    public PooledConnection(Connection rawConn, int connState, FastConnectionPool connPool, BeeDataSourceConfig config) throws SQLException {
        super(config.getPreparedStatementCacheSize() * 2, 0.75f, true);
        this.pool = connPool;
        this.state = connState;
        this.rawConn = rawConn;
        this.defaultAutoCommit = config.isDefaultAutoCommit();
        this.defaultTransactionIsolationCode = config.getDefaultTransactionIsolationCode();
        this.defaultReadOnly = config.isDefaultReadOnly();
        this.defaultCatalog = config.getDefaultCatalog();
        this.defaultSchema = config.getDefaultSchema();
        this.defaultNetworkTimeout = this.pool.getNetworkTimeout();
        this.defaultNetworkTimeoutExecutor = this.pool.getNetworkTimeoutExecutor();
        this.stmCacheSize = config.getPreparedStatementCacheSize();
        this.stmCacheValid = this.stmCacheSize > 0;
        this.curAutoCommit = this.defaultAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    void closeRawConn() {
        try {
            if (this.proxyConn != null) {
                this.proxyConn.setAsClosed();
                this.proxyConn = null;
            }
            if (this.stmCacheValid) {
                this.clear();
            }
            this.resetRawConnOnReturn();
        }
        catch (SQLException e) {
            log.error("Connection close error", (Throwable)e);
        }
        finally {
            BeecpUtil.oclose(this.rawConn);
        }
    }

    void returnToPoolBySelf() throws SQLException {
        try {
            this.proxyConn = null;
            this.resetRawConnOnReturn();
            this.pool.recycle(this);
        }
        catch (SQLException e) {
            this.pool.abandonOnReturn(this);
            throw e;
        }
    }

    void updateAccessTimeWithCommitDirty() {
        this.commitDirtyInd = !this.curAutoCommit;
        this.lastAccessTime = System.currentTimeMillis();
    }

    void setChangedInd(int pos, boolean changed) {
        if (!this.changedInd[pos] && changed) {
            this.changedCount = (short)(this.changedCount + 1);
        } else if (this.changedInd[pos] && !changed) {
            this.changedCount = (short)(this.changedCount - 1);
        }
        this.changedInd[pos] = changed;
    }

    boolean isSupportValidTest() {
        return this.pool.isSupportValidTest();
    }

    boolean isSupportSchema() {
        return this.pool.isSupportSchema();
    }

    boolean isSupportNetworkTimeout() {
        return this.pool.isSupportNetworkTimeout();
    }

    void resetRawConnOnReturn() throws SQLException {
        if (!this.curAutoCommit && this.commitDirtyInd) {
            this.rawConn.rollback();
            this.commitDirtyInd = false;
        }
        if (this.changedCount > 0) {
            if (this.changedInd[0]) {
                this.rawConn.setAutoCommit(this.defaultAutoCommit);
                this.curAutoCommit = this.defaultAutoCommit;
            }
            if (this.changedInd[1]) {
                this.rawConn.setTransactionIsolation(this.defaultTransactionIsolationCode);
            }
            if (this.changedInd[2]) {
                this.rawConn.setReadOnly(this.defaultReadOnly);
            }
            if (this.changedInd[3]) {
                this.rawConn.setCatalog(this.defaultCatalog);
            }
            if (this.changedInd[4]) {
                this.rawConn.setSchema(this.defaultSchema);
            }
            if (this.changedInd[5]) {
                this.rawConn.setNetworkTimeout(this.defaultNetworkTimeoutExecutor, this.defaultNetworkTimeout);
            }
            this.changedCount = 0;
            System.arraycopy(DEFAULT_IND, 0, this.changedInd, 0, 6);
        }
        this.rawConn.clearWarnings();
    }

    @Override
    public boolean removeEldestEntry(Map.Entry<Object, PreparedStatement> eldest) {
        if (this.size() > this.stmCacheSize) {
            BeecpUtil.oclose(eldest.getValue());
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Iterator itor = this.values().iterator();
        while (itor.hasNext()) {
            BeecpUtil.oclose((Statement)itor.next());
        }
        super.clear();
    }
}

