/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp.pool;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.ConnectionFactory;
import cn.beecp.pool.Borrower;
import cn.beecp.pool.ConnectionPool;
import cn.beecp.pool.ConnectionPoolJMXBean;
import cn.beecp.pool.PoolExceptionList;
import cn.beecp.pool.PoolObjectsState;
import cn.beecp.pool.PooledConnection;
import cn.beecp.pool.ProxyConnection;
import cn.beecp.pool.ProxyConnectionBase;
import cn.beecp.util.BeecpUtil;
import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FastConnectionPool
extends Thread
implements ConnectionPool,
ConnectionPoolJMXBean {
    private int PoolMaxSize;
    private long DefaultMaxWaitNanos;
    private int ConUnCatchStateCode;
    private String ConnectionTestSQL;
    private int ConnectionTestTimeout;
    private long ConnectionTestInterval;
    private ConnectionPoolHook exitHook;
    private BeeDataSourceConfig poolConfig;
    private Semaphore semaphore;
    private TransferPolicy transferPolicy;
    private ConnectionTestPolicy testPolicy;
    private ConnectionFactory connFactory;
    private final Object connArrayLock = new Object();
    private final Object connNotifyLock = new Object();
    private volatile PooledConnection[] connArray = new PooledConnection[0];
    private final ConcurrentLinkedQueue<Borrower> waitQueue = new ConcurrentLinkedQueue();
    private final ThreadLocal<WeakReference<Borrower>> threadLocal = new ThreadLocal();
    private ScheduledFuture<?> idleCheckSchFuture = null;
    private ScheduledThreadPoolExecutor idleSchExecutor = new ScheduledThreadPoolExecutor(1, new PoolThreadThreadFactory("IdleConnectionScan"));
    private int networkTimeout;
    private boolean supportValidTest = true;
    private boolean supportSchema = true;
    private boolean supportNetworkTimeout = true;
    private boolean supportQueryTimeout = true;
    private boolean supportIsValidTested = false;
    private ThreadPoolExecutor networkTimeoutExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PoolThreadThreadFactory("networkTimeout"));
    private String poolName;
    private AtomicInteger poolState = new AtomicInteger(1);
    private AtomicInteger createConnThreadState = new AtomicInteger(1);
    private AtomicInteger needAddConnSize = new AtomicInteger(0);
    private static Logger log = LoggerFactory.getLogger(FastConnectionPool.class);
    private static AtomicInteger PoolNameIndex = new AtomicInteger(1);
    private static final long spinForTimeoutThreshold = 1000L;
    private static final int maxTimedSpins = Runtime.getRuntime().availableProcessors() < 2 ? 0 : 32;
    private static final AtomicIntegerFieldUpdater<PooledConnection> ConnStateUpdater = AtomicIntegerFieldUpdater.newUpdater(PooledConnection.class, "state");
    private static final AtomicReferenceFieldUpdater<Borrower, Object> BorrowerStateUpdater = AtomicReferenceFieldUpdater.newUpdater(Borrower.class, Object.class, "state");
    private static final String DESC_REMOVE_INIT = "init";
    private static final String DESC_REMOVE_BAD = "bad";
    private static final String DESC_REMOVE_IDLE = "idle";
    private static final String DESC_REMOVE_CLOSED = "closed";
    private static final String DESC_REMOVE_RESET = "reset";
    private static final String DESC_REMOVE_DESTROY = "destroy";

    @Override
    public void init(BeeDataSourceConfig config) throws SQLException {
        String mode;
        if (this.poolState.get() == 1) {
            this.checkProxyClasses();
            if (config == null) {
                throw new SQLException("DataSource configuration can't be null");
            }
            this.poolConfig = config;
            this.poolName = !BeecpUtil.isNullText(config.getPoolName()) ? config.getPoolName() : "FastPool-" + PoolNameIndex.getAndIncrement();
            log.info("BeeCP({})starting....", (Object)this.poolName);
            this.PoolMaxSize = this.poolConfig.getMaxActive();
            this.connFactory = this.poolConfig.getConnectionFactory();
            this.ConnectionTestSQL = this.poolConfig.getConnectionTestSQL();
            this.ConnectionTestTimeout = this.poolConfig.getConnectionTestTimeout();
            this.testPolicy = new SQLQueryTestPolicy(this.poolConfig.isDefaultAutoCommit());
            if (BeecpUtil.isNullText(this.ConnectionTestSQL)) {
                this.ConnectionTestSQL = "select 1 from dual";
            }
            this.DefaultMaxWaitNanos = TimeUnit.MILLISECONDS.toNanos(this.poolConfig.getMaxWait());
            this.ConnectionTestInterval = this.poolConfig.getConnectionTestInterval();
            this.createInitConnections(this.poolConfig.getInitialSize());
            if (this.poolConfig.isFairMode()) {
                mode = "fair";
                this.transferPolicy = new FairTransferPolicy();
                this.ConUnCatchStateCode = this.transferPolicy.getCheckStateCode();
            } else {
                mode = "compete";
                this.transferPolicy = new CompeteTransferPolicy();
                this.ConUnCatchStateCode = this.transferPolicy.getCheckStateCode();
            }
        } else {
            throw new SQLException("Pool has initialized");
        }
        this.exitHook = new ConnectionPoolHook();
        Runtime.getRuntime().addShutdownHook(this.exitHook);
        this.semaphore = new Semaphore(this.poolConfig.getBorrowConcurrentSize(), this.poolConfig.isFairMode());
        this.networkTimeoutExecutor.allowCoreThreadTimeOut(true);
        this.idleCheckSchFuture = this.idleSchExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                FastConnectionPool.this.closeIdleTimeoutConnection();
            }
        }, config.getIdleCheckTimeInitDelay(), config.getIdleCheckTimeInterval(), TimeUnit.MILLISECONDS);
        this.registerJMX();
        log.info("BeeCP({})has startup{mode:{},init size:{},max size:{},concurrent size:{},max wait:{}ms,driver:{}}", new Object[]{this.poolName, mode, this.connArray.length, config.getMaxActive(), this.poolConfig.getBorrowConcurrentSize(), this.poolConfig.getMaxWait(), this.poolConfig.getDriverClassName()});
        this.poolState.set(2);
        this.setDaemon(true);
        this.setName("PooledConnectionAdd");
        this.start();
    }

    private void checkProxyClasses() throws SQLException {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class.forName("cn.beecp.pool.ProxyConnection", false, classLoader);
            Class.forName("cn.beecp.pool.ProxyStatement", false, classLoader);
            Class.forName("cn.beecp.pool.ProxyPsStatement", false, classLoader);
            Class.forName("cn.beecp.pool.ProxyCsStatement", false, classLoader);
            Class.forName("cn.beecp.pool.ProxyDatabaseMetaData", false, classLoader);
            Class.forName("cn.beecp.pool.ProxyResultSet", false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Jdbc proxy class missed", e);
        }
    }

    boolean isSupportValidTest() {
        return this.supportValidTest;
    }

    boolean isSupportSchema() {
        return this.supportSchema;
    }

    boolean isSupportNetworkTimeout() {
        return this.supportNetworkTimeout;
    }

    int getNetworkTimeout() {
        return this.networkTimeout;
    }

    ThreadPoolExecutor getNetworkTimeoutExecutor() {
        return this.networkTimeoutExecutor;
    }

    private boolean existBorrower() {
        return this.poolConfig.getBorrowConcurrentSize() > this.semaphore.availablePermits() || this.semaphore.hasQueuedThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledConnection createPooledConn(int connState) throws SQLException {
        Object object = this.connArrayLock;
        synchronized (object) {
            if (this.connArray.length < this.PoolMaxSize) {
                Connection con = this.connFactory.create();
                this.setDefaultOnRawConn(con);
                PooledConnection pConn = new PooledConnection(con, connState, this, this.poolConfig);
                PooledConnection[] arrayNew = new PooledConnection[this.connArray.length + 1];
                System.arraycopy(this.connArray, 0, arrayNew, 0, this.connArray.length);
                arrayNew[this.connArray.length] = pConn;
                this.connArray = arrayNew;
                return pConn;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePooledConn(PooledConnection pConn, String removeType) {
        pConn.state = 3;
        pConn.closeRawConn();
        Object object = this.connArrayLock;
        synchronized (object) {
            int oldLen = this.connArray.length;
            PooledConnection[] arrayNew = new PooledConnection[oldLen - 1];
            for (int i = 0; i < oldLen; ++i) {
                if (this.connArray[i] == pConn) {
                    System.arraycopy(this.connArray, i + 1, arrayNew, i, oldLen - i - 1);
                    break;
                }
                arrayNew[i] = this.connArray[i];
            }
            this.connArray = arrayNew;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setDefaultOnRawConn(Connection rawConn) {
        try {
            rawConn.setAutoCommit(this.poolConfig.isDefaultAutoCommit());
        }
        catch (Throwable e) {
            log.warn("BeeCP({})failed to set default on executing 'setAutoCommit'", (Object)this.poolName);
        }
        try {
            rawConn.setTransactionIsolation(this.poolConfig.getDefaultTransactionIsolationCode());
        }
        catch (SQLException e) {
            log.warn("BeeCP({}))failed to set default on executing to 'setTransactionIsolation'", (Object)this.poolName);
        }
        try {
            rawConn.setReadOnly(this.poolConfig.isDefaultReadOnly());
        }
        catch (Throwable e) {
            log.warn("BeeCP({}))failed to set default on executing to 'setReadOnly'", (Object)this.poolName);
        }
        if (!BeecpUtil.isNullText(this.poolConfig.getDefaultCatalog())) {
            try {
                rawConn.setCatalog(this.poolConfig.getDefaultCatalog());
            }
            catch (Throwable e) {
                log.warn("BeeCP({}))failed to set default on executing to 'setCatalog'", (Object)this.poolName);
            }
        }
        if (this.supportSchema && !BeecpUtil.isNullText(this.poolConfig.getDefaultSchema())) {
            try {
                rawConn.setSchema(this.poolConfig.getDefaultSchema());
            }
            catch (Throwable e) {
                this.supportSchema = false;
                log.warn("BeeCP({})driver not support 'schema'", (Object)this.poolName);
            }
        }
        if (this.supportNetworkTimeout) {
            try {
                this.networkTimeout = rawConn.getNetworkTimeout();
                if (this.networkTimeout < 0) {
                    this.supportNetworkTimeout = false;
                    log.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
                } else {
                    rawConn.setNetworkTimeout(this.getNetworkTimeoutExecutor(), this.networkTimeout);
                }
            }
            catch (Throwable e) {
                this.supportNetworkTimeout = false;
                log.warn("BeeCP({})driver not support 'networkTimeout'", (Object)this.poolName);
            }
        }
        if (this.supportIsValidTested) return;
        try {
            if (!rawConn.isValid(this.ConnectionTestTimeout)) {
                throw new SQLException();
            }
            this.testPolicy = new ConnValidTestPolicy();
            return;
        }
        catch (Throwable e) {
            this.supportValidTest = false;
            log.warn("BeeCP({})driver not support 'isValid'", (Object)this.poolName);
            Statement st = null;
            try {
                st = rawConn.createStatement();
                st.setQueryTimeout(this.ConnectionTestTimeout);
                if (st == null) return;
            }
            catch (Throwable ee) {
                try {
                    this.supportQueryTimeout = false;
                    log.warn("BeeCP({})driver not support 'queryTimeout'", (Object)this.poolName);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (st != null) {
                        BeecpUtil.oclose(st);
                    }
                }
            }
            BeecpUtil.oclose(st);
            return;
        }
        finally {
            this.supportIsValidTested = true;
        }
    }

    private boolean testOnBorrow(PooledConnection pConn) {
        if (System.currentTimeMillis() - pConn.lastAccessTime - this.ConnectionTestInterval < 0L || this.testPolicy.isActive(pConn)) {
            return true;
        }
        this.removePooledConn(pConn, DESC_REMOVE_BAD);
        this.tryToCreateNewConnByAsyn();
        return false;
    }

    private void createInitConnections(int initSize) throws SQLException {
        try {
            for (int i = 0; i < initSize; ++i) {
                this.createPooledConn(1);
            }
        }
        catch (SQLException e) {
            for (PooledConnection pConn : this.connArray) {
                this.removePooledConn(pConn, DESC_REMOVE_INIT);
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Borrower borrower;
        if (this.poolState.get() != 2) {
            throw PoolExceptionList.PoolCloseException;
        }
        WeakReference<Borrower> bRef = this.threadLocal.get();
        Borrower borrower2 = borrower = bRef != null ? (Borrower)bRef.get() : null;
        if (borrower != null) {
            PooledConnection pConn = borrower.lastUsedConn;
            if (pConn != null && ConnStateUpdater.compareAndSet(pConn, 1, 2)) {
                if (this.testOnBorrow(pConn)) {
                    return FastConnectionPool.createProxyConnection(pConn, borrower);
                }
                borrower.lastUsedConn = null;
            }
        } else {
            borrower = new Borrower();
            this.threadLocal.set(new WeakReference<Borrower>(borrower));
        }
        long deadline = System.nanoTime() + this.DefaultMaxWaitNanos;
        try {
            if (!this.semaphore.tryAcquire(this.DefaultMaxWaitNanos, TimeUnit.NANOSECONDS)) {
                throw PoolExceptionList.RequestTimeoutException;
            }
        }
        catch (InterruptedException e) {
            throw PoolExceptionList.RequestInterruptException;
        }
        try {
            int spinSize;
            PooledConnection pConn;
            for (PooledConnection pConn2 : this.connArray) {
                if (!ConnStateUpdater.compareAndSet(pConn2, 1, 2) || !this.testOnBorrow(pConn2)) continue;
                Connection connection = FastConnectionPool.createProxyConnection(pConn2, borrower);
                return connection;
            }
            if (this.connArray.length < this.PoolMaxSize && (pConn = this.createPooledConn(2)) != null) {
                Connection l = FastConnectionPool.createProxyConnection(pConn, borrower);
                return l;
            }
            boolean isFailed = false;
            SQLException failedCause = null;
            Thread bThread = borrower.thread;
            borrower.state = PoolObjectsState.BORROWER_NORMAL;
            this.waitQueue.offer(borrower);
            int n = spinSize = this.waitQueue.peek() == borrower ? maxTimedSpins : 0;
            while (true) {
                Object state;
                if ((state = borrower.state) instanceof PooledConnection) {
                    pConn = (PooledConnection)state;
                    if (this.transferPolicy.tryCatch(pConn) && this.testOnBorrow(pConn)) {
                        this.waitQueue.remove(borrower);
                        Connection connection = FastConnectionPool.createProxyConnection(pConn, borrower);
                        return connection;
                    }
                    borrower.state = PoolObjectsState.BORROWER_NORMAL;
                    FastConnectionPool.yield();
                    continue;
                }
                if (state instanceof SQLException) {
                    this.waitQueue.remove(borrower);
                    throw (SQLException)state;
                }
                if (isFailed) {
                    BorrowerStateUpdater.compareAndSet(borrower, state, failedCause);
                    continue;
                }
                long timeout = deadline - System.nanoTime();
                if (timeout > 0L) {
                    if (spinSize > 0) {
                        --spinSize;
                        continue;
                    }
                    if (timeout <= 1000L || !BorrowerStateUpdater.compareAndSet(borrower, state, PoolObjectsState.BORROWER_WAITING)) continue;
                    LockSupport.parkNanos(this, timeout);
                    if (!bThread.isInterrupted()) continue;
                    isFailed = true;
                    failedCause = PoolExceptionList.RequestInterruptException;
                    continue;
                }
                isFailed = true;
                failedCause = PoolExceptionList.RequestTimeoutException;
            }
        }
        finally {
            this.semaphore.release();
        }
    }

    private static final Connection createProxyConnection(PooledConnection pooledConnection, Borrower borrower) throws SQLException {
        borrower.lastUsedConn = pooledConnection;
        return new ProxyConnection(pooledConnection);
    }

    void abandonOnReturn(PooledConnection pConn) {
        this.removePooledConn(pConn, DESC_REMOVE_BAD);
        this.tryToCreateNewConnByAsyn();
    }

    @Override
    public void recycle(PooledConnection pConn) {
        this.transferPolicy.beforeTransfer(pConn);
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            while (state == PoolObjectsState.BORROWER_NORMAL || state == PoolObjectsState.BORROWER_WAITING) {
                if (pConn.state != this.ConUnCatchStateCode) {
                    return;
                }
                if (BorrowerStateUpdater.compareAndSet(borrower, state, pConn)) {
                    if (state == PoolObjectsState.BORROWER_WAITING) {
                        LockSupport.unpark(borrower.thread);
                    }
                    return;
                }
                state = borrower.state;
            }
        }
        this.transferPolicy.onFailedTransfer(pConn);
    }

    private void transferException(SQLException exception) {
        for (Borrower borrower : this.waitQueue) {
            Object state = borrower.state;
            while (state == PoolObjectsState.BORROWER_NORMAL || state == PoolObjectsState.BORROWER_WAITING) {
                if (BorrowerStateUpdater.compareAndSet(borrower, state, exception)) {
                    if (state == PoolObjectsState.BORROWER_WAITING) {
                        LockSupport.unpark(borrower.thread);
                    }
                    return;
                }
                state = borrower.state;
            }
        }
    }

    private void closeIdleTimeoutConnection() {
        if (this.poolState.get() == 2) {
            for (PooledConnection pConn : this.connArray) {
                int state = pConn.state;
                if (state == 1 && !this.existBorrower()) {
                    boolean isTimeoutInIdle;
                    boolean bl = isTimeoutInIdle = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getIdleTimeout() >= 0L;
                    if (!isTimeoutInIdle || !ConnStateUpdater.compareAndSet(pConn, state, 3)) continue;
                    this.removePooledConn(pConn, DESC_REMOVE_IDLE);
                    this.tryToCreateNewConnByAsyn();
                    continue;
                }
                if (state == 2) {
                    boolean isHolTimeoutInNotUsing;
                    ProxyConnectionBase proxyConn = pConn.proxyConn;
                    boolean bl = isHolTimeoutInNotUsing = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getHoldTimeout() >= 0L;
                    if (!isHolTimeoutInNotUsing || proxyConn == null || !proxyConn.setAsClosed()) continue;
                    try {
                        pConn.resetRawConnOnReturn();
                        this.recycle(pConn);
                    }
                    catch (Throwable e) {
                        this.abandonOnReturn(pConn);
                    }
                    continue;
                }
                if (state != 3) continue;
                this.removePooledConn(pConn, DESC_REMOVE_CLOSED);
                this.tryToCreateNewConnByAsyn();
            }
        }
    }

    @Override
    public void shutdown() {
        long parkNanoSeconds = TimeUnit.SECONDS.toNanos(this.poolConfig.getWaitTimeToClearPool());
        while (true) {
            if (this.poolState.compareAndSet(2, 3)) {
                log.info("BeeCP({})begin to shutdown", (Object)this.poolName);
                this.removeAllConnections(this.poolConfig.isForceCloseConnection(), DESC_REMOVE_DESTROY);
                while (!this.idleCheckSchFuture.isCancelled() && !this.idleCheckSchFuture.isDone()) {
                    this.idleCheckSchFuture.cancel(true);
                }
                this.idleSchExecutor.shutdownNow();
                this.networkTimeoutExecutor.shutdownNow();
                this.shutdownCreateConnThread();
                this.unregisterJMX();
                try {
                    Runtime.getRuntime().removeShutdownHook(this.exitHook);
                }
                catch (Throwable e) {
                    log.warn("BeeCP({})failed to remove pool hook", (Object)this.poolName);
                }
                log.info("BeeCP({})has shutdown", (Object)this.poolName);
                break;
            }
            if (this.poolState.get() == 3) break;
            LockSupport.parkNanos(parkNanoSeconds);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.poolState.get() == 3;
    }

    private void removeAllConnections(boolean force, String source) {
        while (this.existBorrower()) {
            this.transferException(PoolExceptionList.PoolCloseException);
        }
        long parkNanoSeconds = TimeUnit.SECONDS.toNanos(this.poolConfig.getWaitTimeToClearPool());
        while (this.connArray.length > 0) {
            for (PooledConnection pConn : this.connArray) {
                boolean isTimeout;
                if (ConnStateUpdater.compareAndSet(pConn, 1, 3)) {
                    this.removePooledConn(pConn, source);
                    continue;
                }
                if (pConn.state == 3) {
                    this.removePooledConn(pConn, source);
                    continue;
                }
                if (pConn.state != 2) continue;
                ProxyConnectionBase proxyConn = pConn.proxyConn;
                if (force) {
                    if (proxyConn == null || !proxyConn.setAsClosed() || !ConnStateUpdater.compareAndSet(pConn, 2, 3)) continue;
                    this.removePooledConn(pConn, source);
                    continue;
                }
                boolean bl = isTimeout = System.currentTimeMillis() - pConn.lastAccessTime - this.poolConfig.getHoldTimeout() >= 0L;
                if (!isTimeout || proxyConn == null || !proxyConn.setAsClosed() || !ConnStateUpdater.compareAndSet(pConn, 2, 3)) continue;
                this.removePooledConn(pConn, source);
            }
            if (this.connArray.length <= 0) continue;
            LockSupport.parkNanos(parkNanoSeconds);
        }
        this.idleSchExecutor.getQueue().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToCreateNewConnByAsyn() {
        if (this.connArray.length + this.needAddConnSize.get() < this.PoolMaxSize) {
            Object object = this.connNotifyLock;
            synchronized (object) {
                if (this.connArray.length + this.needAddConnSize.get() < this.PoolMaxSize) {
                    this.needAddConnSize.incrementAndGet();
                    if (this.createConnThreadState.compareAndSet(2, 1)) {
                        LockSupport.unpark(this);
                    }
                }
            }
        }
    }

    private void shutdownCreateConnThread() {
        block1: {
            int curSts;
            while ((curSts = this.createConnThreadState.get()) != 1 && curSts != 2 || !this.createConnThreadState.compareAndSet(curSts, 3)) {
            }
            if (curSts != 2) break block1;
            LockSupport.unpark(this);
        }
    }

    @Override
    public void run() {
        while (true) {
            if (this.needAddConnSize.get() > 0) {
                this.needAddConnSize.decrementAndGet();
                if (this.waitQueue.isEmpty()) continue;
                try {
                    PooledConnection pConn = this.createPooledConn(2);
                    if (pConn == null) continue;
                    new TransferThread(pConn).start();
                }
                catch (SQLException e) {
                    new TransferThread(e).start();
                }
                continue;
            }
            if (this.needAddConnSize.get() == 0 && this.createConnThreadState.compareAndSet(1, 2)) {
                LockSupport.park(this);
            }
            if (this.createConnThreadState.get() == 3) break;
        }
    }

    @Override
    public void reset() {
        this.reset(false);
    }

    @Override
    public void reset(boolean force) {
        if (this.poolState.compareAndSet(2, 4)) {
            log.info("BeeCP({})begin to reset.", (Object)this.poolName);
            this.removeAllConnections(force, DESC_REMOVE_RESET);
            log.info("All pooledConns were cleared");
            this.poolState.set(2);
            log.info("BeeCP({})finished reseting", (Object)this.poolName);
        }
    }

    public Map printPoolInfo() {
        HashMap<String, Integer> mapInfo = new HashMap<String, Integer>(5);
        int totSize = this.getConnTotalSize();
        int idleSize = this.getConnIdleSize();
        mapInfo.put("ConnTotalSize", totSize);
        mapInfo.put("ConnIdleSize", idleSize);
        mapInfo.put("ConnUsingSize", totSize - idleSize);
        mapInfo.put("SemaphoreWaiterSize", this.getSemaphoreWaitingSize());
        mapInfo.put("TransferWaiterSize", this.getSemaphoreWaitingSize());
        log.info("Pool info:" + mapInfo);
        return mapInfo;
    }

    @Override
    public int getConnTotalSize() {
        return this.connArray.length;
    }

    @Override
    public int getConnIdleSize() {
        int idleConnections = 0;
        for (PooledConnection pConn : this.connArray) {
            if (pConn.state != 1) continue;
            ++idleConnections;
        }
        return idleConnections;
    }

    @Override
    public int getConnUsingSize() {
        int active = this.connArray.length - this.getConnIdleSize();
        return active > 0 ? active : 0;
    }

    @Override
    public int getSemaphoreAcquiredSize() {
        return this.poolConfig.getBorrowConcurrentSize() - this.semaphore.availablePermits();
    }

    @Override
    public int getSemaphoreWaitingSize() {
        return this.semaphore.getQueueLength();
    }

    @Override
    public int getTransferWaitingSize() {
        return this.waitQueue.size();
    }

    private void registerJMX() {
        if (this.poolConfig.isEnableJMX()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerJMXBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName), this);
            this.registerJMXBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName), this.poolConfig);
        }
    }

    private void registerJMXBean(MBeanServer mBeanServer, String regName, Object bean) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (!mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.registerMBean(bean, jmxRegName);
            }
        }
        catch (Exception e) {
            log.warn("BeeCP({})failed to register jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    private void unregisterJMX() {
        if (this.poolConfig.isEnableJMX()) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            this.unregisterJMXBean(mBeanServer, String.format("cn.beecp.pool.FastConnectionPool:type=BeeCP(%s)", this.poolName));
            this.unregisterJMXBean(mBeanServer, String.format("cn.beecp.BeeDataSourceConfig:type=BeeCP(%s)-config", this.poolName));
        }
    }

    private void unregisterJMXBean(MBeanServer mBeanServer, String regName) {
        try {
            ObjectName jmxRegName = new ObjectName(regName);
            if (mBeanServer.isRegistered(jmxRegName)) {
                mBeanServer.unregisterMBean(jmxRegName);
            }
        }
        catch (Exception e) {
            log.warn("BeeCP({})failed to unregister jmx-bean:{}", new Object[]{this.poolName, regName, e});
        }
    }

    static final class FairTransferPolicy
    implements TransferPolicy {
        FairTransferPolicy() {
        }

        @Override
        public int getCheckStateCode() {
            return 2;
        }

        @Override
        public boolean tryCatch(PooledConnection pConn) {
            return pConn.state == 2;
        }

        @Override
        public void onFailedTransfer(PooledConnection pConn) {
            pConn.state = 1;
        }

        @Override
        public void beforeTransfer(PooledConnection pConn) {
        }
    }

    static final class CompeteTransferPolicy
    implements TransferPolicy {
        CompeteTransferPolicy() {
        }

        @Override
        public int getCheckStateCode() {
            return 1;
        }

        @Override
        public boolean tryCatch(PooledConnection pConn) {
            return ConnStateUpdater.compareAndSet(pConn, 1, 2);
        }

        @Override
        public void onFailedTransfer(PooledConnection pConn) {
        }

        @Override
        public void beforeTransfer(PooledConnection pConn) {
            pConn.state = 1;
        }
    }

    static interface TransferPolicy {
        public int getCheckStateCode();

        public void beforeTransfer(PooledConnection var1);

        public boolean tryCatch(PooledConnection var1);

        public void onFailedTransfer(PooledConnection var1);
    }

    class ConnValidTestPolicy
    implements ConnectionTestPolicy {
        ConnValidTestPolicy() {
        }

        @Override
        public boolean isActive(PooledConnection pConn) {
            Connection con = pConn.rawConn;
            try {
                if (con.isValid(FastConnectionPool.this.ConnectionTestTimeout)) {
                    pConn.lastAccessTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (Throwable e) {
                log.error("BeeCP({})failed to test connection", (Object)FastConnectionPool.this.poolName, (Object)e);
            }
            return false;
        }
    }

    class SQLQueryTestPolicy
    implements ConnectionTestPolicy {
        private boolean AutoCommit;

        public SQLQueryTestPolicy(boolean autoCommit) {
            this.AutoCommit = autoCommit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActive(PooledConnection pConn) {
            boolean autoCommitChged = false;
            Statement st = null;
            Connection con = pConn.rawConn;
            try {
                if (this.AutoCommit) {
                    con.setAutoCommit(false);
                    autoCommitChged = true;
                }
                st = con.createStatement();
                pConn.lastAccessTime = System.currentTimeMillis();
                if (FastConnectionPool.this.supportQueryTimeout) {
                    try {
                        st.setQueryTimeout(FastConnectionPool.this.ConnectionTestTimeout);
                    }
                    catch (Throwable e) {
                        log.error("BeeCP({})failed to setQueryTimeout", (Object)FastConnectionPool.this.poolName, (Object)e);
                    }
                }
                st.execute(FastConnectionPool.this.ConnectionTestSQL);
                con.rollback();
                boolean e = true;
                return e;
            }
            catch (Throwable e) {
                log.error("BeeCP({})failed to test connection", (Object)FastConnectionPool.this.poolName, (Object)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (st != null) {
                    BeecpUtil.oclose(st);
                }
                if (this.AutoCommit && autoCommitChged) {
                    try {
                        con.setAutoCommit(true);
                    }
                    catch (Throwable e) {
                        log.error("BeeCP({})failed to execute 'rollback or setAutoCommit(true)' after connection test", (Object)FastConnectionPool.this.poolName, (Object)e);
                    }
                }
            }
        }
    }

    static interface ConnectionTestPolicy {
        public boolean isActive(PooledConnection var1);
    }

    class TransferThread
    extends Thread {
        private boolean isConn;
        private SQLException e;
        private PooledConnection pConn;

        TransferThread(SQLException e) {
            this.e = e;
            this.isConn = false;
        }

        TransferThread(PooledConnection pConn) {
            this.pConn = pConn;
            this.isConn = true;
        }

        @Override
        public void run() {
            if (this.isConn) {
                FastConnectionPool.this.recycle(this.pConn);
            } else {
                FastConnectionPool.this.transferException(this.e);
            }
        }
    }

    private class ConnectionPoolHook
    extends Thread {
        private ConnectionPoolHook() {
        }

        @Override
        public void run() {
            FastConnectionPool.this.shutdown();
        }
    }

    static final class PoolThreadThreadFactory
    implements ThreadFactory {
        private String thName;

        public PoolThreadThreadFactory(String thName) {
            this.thName = thName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, this.thName);
            th.setDaemon(true);
            return th;
        }
    }
}

