/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import cn.beecp.util.BeecpUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;

public final class BeeDataSourceFactory
implements ObjectFactory {
    public static final String PROP_INITIALSIZE = "initialSize";
    public static final String PROP_MAXACTIVE = "maxActive";
    public static final String PROP_MAXWAIT = "maxWait";
    public static final String PROP_URL = "url";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_DRIVERCLASSNAME = "driverClassName";
    public static final String PROP_VALIDATIONQUERY = "validationQuery";
    public static final String PROP_VALIDATIONQUERY_TIMEOUT = "validationQueryTimeout";
    public static final String PROP_POOLPREPAREDSTATEMENTS = "poolPreparedStatements";
    public static final String PROP_MAXOPENPREPAREDSTATEMENTS = "maxOpenPreparedStatements";
    public static final String PROP_DEFAULTTRANSACTIONISOLATION = "defaultTransactionIsolation";
    public static final String PROP_MINEVICTABLEIDLETIMEMILLIS = "minEvictableIdleTimeMillis";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String SECURITY_PRINCIPAL = "java.naming.security.principal";
    public static final String SECURITY_CREDENTIALS = "java.naming.security.credentials";
    private Properties initProperties = new Properties();

    public BeeDataSourceFactory() {
    }

    public BeeDataSourceFactory(Properties initProperties) {
        if (initProperties != null) {
            this.initProperties = initProperties;
        }
    }

    public void addProperty(String key, String value) {
        this.initProperties.put(key, value);
    }

    public void removeProperty(String key) {
        this.initProperties.remove(key);
    }

    public void unbind(String jndi) throws NamingException {
        InitialContext ctx = new InitialContext(this.initProperties);
        ctx.unbind(jndi);
    }

    public DataSource lookup(String jndi) throws NamingException {
        InitialContext ctx = new InitialContext(this.initProperties);
        return new JndiDataSourceWrapper((DataSource)ctx.lookup(jndi));
    }

    public void bind(String jndi, DataSource obj) throws NamingException {
        InitialContext ctx = new InitialContext(this.initProperties);
        ctx.bind(jndi, (Object)obj);
    }

    public DataSource create(BeeDataSourceConfig config) {
        return new BeeDataSource(config);
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Reference ref = (Reference)obj;
        String driverClass = null;
        String jdbcURL = null;
        String jdbcUser = null;
        String password = null;
        String initSize = null;
        String maxSize = null;
        String maxWait = null;
        String connectionIdleTimeout = null;
        String validationQuerySQL = null;
        String validationQueryTimeout = null;
        String needStatementCache = null;
        String statementCacheSize = null;
        RefAddr ra = ref.get(PROP_DRIVERCLASSNAME);
        if (ra != null) {
            driverClass = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_URL)) != null) {
            jdbcURL = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_USERNAME)) != null) {
            jdbcUser = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_PASSWORD)) != null) {
            password = ra.getContent().toString();
        }
        BeeDataSourceConfig config = new BeeDataSourceConfig();
        config.setDriverClassName(driverClass);
        config.setUrl(jdbcURL);
        config.setUsername(jdbcUser);
        config.setPassword(password);
        ra = ref.get(PROP_INITIALSIZE);
        if (ra != null) {
            initSize = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_MAXACTIVE)) != null) {
            maxSize = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_MAXWAIT)) != null) {
            maxWait = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_VALIDATIONQUERY)) != null) {
            validationQuerySQL = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_VALIDATIONQUERY_TIMEOUT)) != null) {
            validationQueryTimeout = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_MINEVICTABLEIDLETIMEMILLIS)) != null) {
            connectionIdleTimeout = ra.getContent().toString();
        }
        if (!BeecpUtil.isNullText(maxSize)) {
            config.setMaxActive(Integer.parseInt(maxSize));
        }
        if (!BeecpUtil.isNullText(initSize)) {
            config.setInitialSize(Integer.parseInt(initSize));
        }
        if (!BeecpUtil.isNullText(maxWait)) {
            config.setMaxWait(Integer.parseInt(maxWait));
        }
        if (!BeecpUtil.isNullText(validationQuerySQL)) {
            config.setConnectionTestSQL(validationQuerySQL);
        }
        if (!BeecpUtil.isNullText(validationQueryTimeout)) {
            config.setConnectionTestTimeout(Integer.parseInt(validationQueryTimeout));
        }
        if (!BeecpUtil.isNullText(connectionIdleTimeout)) {
            config.setIdleTimeout(Integer.parseInt(connectionIdleTimeout));
        }
        if ((ra = ref.get(PROP_POOLPREPAREDSTATEMENTS)) != null) {
            needStatementCache = ra.getContent().toString();
        }
        if ((ra = ref.get(PROP_MAXOPENPREPAREDSTATEMENTS)) != null) {
            statementCacheSize = ra.getContent().toString();
        }
        if ("true".equals(needStatementCache) || "Y".equals(needStatementCache)) {
            if (!BeecpUtil.isNullText(statementCacheSize)) {
                config.setPreparedStatementCacheSize(Integer.parseInt(statementCacheSize));
            }
        } else {
            config.setPreparedStatementCacheSize(0);
        }
        return new BeeDataSource(config);
    }

    static final class JndiDataSourceWrapper
    implements DataSource {
        private DataSource delegete;

        public JndiDataSourceWrapper(DataSource delegete) {
            this.delegete = delegete;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.delegete.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.delegete.getConnection(username, password);
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.delegete.getLogWriter();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.delegete.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.delegete.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.delegete.getLoginTimeout();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.delegete.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.delegete.isWrapperFor(iface);
        }
    }
}

