/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfigException;
import cn.beecp.BeeDataSourceConfigJMXBean;
import cn.beecp.ConnectionFactory;
import cn.beecp.TransactionIsolationLevel;
import cn.beecp.pool.DataSourceConnectionFactory;
import cn.beecp.pool.DriverConnectionFactory;
import cn.beecp.util.BeecpUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;

public class BeeDataSourceConfig
implements BeeDataSourceConfigJMXBean {
    private boolean checked;
    private String username;
    private String password;
    private String jdbcUrl;
    private String driverClassName;
    private String poolName;
    private boolean fairMode;
    private int initialSize;
    private int maxActive = 10;
    private int borrowConcurrentSize;
    private int preparedStatementCacheSize;
    private boolean defaultAutoCommit = true;
    private String defaultTransactionIsolation;
    private int defaultTransactionIsolationCode;
    private String defaultCatalog;
    private String defaultSchema;
    private boolean defaultReadOnly;
    protected long maxWait = TimeUnit.SECONDS.toMillis(8L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(3L);
    private long holdTimeout = TimeUnit.MINUTES.toMillis(5L);
    private String connectionTestSQL = "select 1 from dual";
    private int connectionTestTimeout = 3;
    private long connectionTestInterval = 500L;
    private boolean forceCloseConnection;
    private long waitTimeToClearPool = 3L;
    private long idleCheckTimeInterval = TimeUnit.MINUTES.toMillis(3L);
    private long idleCheckTimeInitDelay = TimeUnit.SECONDS.toMillis(1L);
    private String poolImplementClassName = "cn.beecp.pool.FastConnectionPool";
    private String connectionFactoryClassName;
    private ConnectionFactory connectionFactory;
    private Properties connectProperties = new Properties();
    private boolean enableJMX;
    static final String DefaultImplementClassName = "cn.beecp.pool.FastConnectionPool";

    public BeeDataSourceConfig() {
        this(null, null, null, null);
    }

    public BeeDataSourceConfig(String driver, String url, String user, String password) {
        this.jdbcUrl = url;
        this.username = user;
        this.password = password;
        this.driverClassName = driver;
        this.borrowConcurrentSize = Runtime.getRuntime().availableProcessors();
        this.defaultTransactionIsolation = "READ_COMMITTED";
        this.defaultTransactionIsolationCode = 2;
    }

    void setAsChecked() {
        if (!this.checked) {
            this.checked = true;
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (!this.checked) {
            this.username = username;
        }
    }

    public void setPassword(String password) {
        if (!this.checked) {
            this.password = password;
        }
    }

    @Override
    public String getUrl() {
        return this.jdbcUrl;
    }

    public void setUrl(String jdbcUrl) {
        if (!this.checked && !BeecpUtil.isNullText(jdbcUrl)) {
            this.jdbcUrl = jdbcUrl;
        }
    }

    public void setJdbcUrl(String jdbcUrl) {
        if (!this.checked && !BeecpUtil.isNullText(jdbcUrl)) {
            this.jdbcUrl = jdbcUrl;
        }
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if (!this.checked && !BeecpUtil.isNullText(driverClassName)) {
            this.driverClassName = driverClassName;
        }
    }

    @Override
    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public void setConnectionFactoryClassName(String connectionFactoryClassName) {
        if (!this.checked && !BeecpUtil.isNullText(connectionFactoryClassName)) {
            this.connectionFactoryClassName = connectionFactoryClassName;
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        if (!this.checked) {
            this.connectionFactory = connectionFactory;
        }
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        if (!this.checked && !BeecpUtil.isNullText(poolName)) {
            this.poolName = poolName;
        }
    }

    @Override
    public boolean isFairMode() {
        return this.fairMode;
    }

    public void setFairMode(boolean fairMode) {
        if (!this.checked) {
            this.fairMode = fairMode;
        }
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        if (!this.checked && initialSize > 0) {
            this.initialSize = initialSize;
        }
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        if (!this.checked && maxActive > 0) {
            this.maxActive = maxActive;
        }
    }

    @Override
    public int getBorrowConcurrentSize() {
        return this.borrowConcurrentSize;
    }

    public void setBorrowConcurrentSize(int borrowConcurrentSize) {
        if (!this.checked && borrowConcurrentSize > 0) {
            this.borrowConcurrentSize = borrowConcurrentSize;
        }
    }

    @Override
    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        if (!this.checked && preparedStatementCacheSize >= 0) {
            this.preparedStatementCacheSize = preparedStatementCacheSize;
        }
    }

    @Override
    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        if (!this.checked) {
            this.defaultAutoCommit = defaultAutoCommit;
        }
    }

    @Override
    public String getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(String defaultTransactionIsolation) {
        if (!this.checked && !BeecpUtil.isNullText(defaultTransactionIsolation)) {
            this.defaultTransactionIsolation = defaultTransactionIsolation;
        }
    }

    @Override
    public int getDefaultTransactionIsolationCode() {
        return this.defaultTransactionIsolationCode;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String catalog) {
        if (!BeecpUtil.isNullText(catalog)) {
            this.defaultCatalog = catalog;
        }
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String schema) {
        if (!BeecpUtil.isNullText(schema)) {
            this.defaultSchema = schema;
        }
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean readOnly) {
        if (!this.checked) {
            this.defaultReadOnly = readOnly;
        }
    }

    @Override
    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        if (!this.checked && maxWait > 0L) {
            this.maxWait = maxWait;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        if (!this.checked && idleTimeout > 0L) {
            this.idleTimeout = idleTimeout;
        }
    }

    @Override
    public long getHoldTimeout() {
        return this.holdTimeout;
    }

    public void setHoldIdleTimeout(long holdTimeout) {
        if (!this.checked && holdTimeout > 0L) {
            this.holdTimeout = holdTimeout;
        }
    }

    @Override
    public String getConnectionTestSQL() {
        return this.connectionTestSQL;
    }

    public void setConnectionTestSQL(String validationQuery) {
        if (!this.checked && !BeecpUtil.isNullText(validationQuery)) {
            this.connectionTestSQL = validationQuery;
        }
    }

    @Override
    public int getConnectionTestTimeout() {
        return this.connectionTestTimeout;
    }

    public void setConnectionTestTimeout(int connectionTestTimeout) {
        if (!this.checked && connectionTestTimeout > 0) {
            this.connectionTestTimeout = connectionTestTimeout;
        }
    }

    @Override
    public long getConnectionTestInterval() {
        return this.connectionTestInterval;
    }

    public void setConnectionTestInterval(long connectionTestInterval) {
        if (!this.checked && connectionTestInterval > 0L) {
            this.connectionTestInterval = connectionTestInterval;
        }
    }

    @Override
    public boolean isForceCloseConnection() {
        return this.forceCloseConnection;
    }

    public void setForceCloseConnection(boolean forceCloseConnection) {
        if (!this.checked) {
            this.forceCloseConnection = forceCloseConnection;
        }
    }

    @Override
    public long getWaitTimeToClearPool() {
        return this.waitTimeToClearPool;
    }

    public void setWaitTimeToClearPool(long waitTimeToClearPool) {
        if (!this.checked && waitTimeToClearPool >= 0L) {
            this.waitTimeToClearPool = waitTimeToClearPool;
        }
    }

    @Override
    public long getIdleCheckTimeInterval() {
        return this.idleCheckTimeInterval;
    }

    public void setIdleCheckTimeInterval(long idleCheckTimeInterval) {
        if (!this.checked && idleCheckTimeInterval >= 1000L) {
            this.idleCheckTimeInterval = idleCheckTimeInterval;
        }
    }

    @Override
    public long getIdleCheckTimeInitDelay() {
        return this.idleCheckTimeInitDelay;
    }

    public void setIdleCheckTimeInitDelay(long idleCheckTimeInitDelay) {
        if (!this.checked && idleCheckTimeInitDelay >= 1000L) {
            this.idleCheckTimeInitDelay = idleCheckTimeInitDelay;
        }
    }

    @Override
    public String getPoolImplementClassName() {
        return this.poolImplementClassName;
    }

    public void setPoolImplementClassName(String poolImplementClassName) {
        if (!this.checked && !BeecpUtil.isNullText(poolImplementClassName)) {
            this.poolImplementClassName = poolImplementClassName;
        }
    }

    public void removeConnectProperty(String key) {
        if (!this.checked) {
            this.connectProperties.remove(key);
        }
    }

    public void addConnectProperty(String key, String value) {
        if (!this.checked) {
            this.connectProperties.put(key, value);
        }
    }

    @Override
    public boolean isEnableJMX() {
        return this.enableJMX;
    }

    public void setEnableJMX(boolean enableJMX) {
        if (!this.checked) {
            this.enableJMX = enableJMX;
        }
    }

    void copyTo(BeeDataSourceConfig config) throws SQLException {
        Field[] fields;
        for (Field field : fields = BeeDataSourceConfig.class.getDeclaredFields()) {
            int modifiers;
            if ("checked".equals(field.getName()) || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isFinal(modifiers)) continue;
            boolean accessible = field.isAccessible();
            try {
                if (!accessible) {
                    field.setAccessible(true);
                }
                field.set(config, field.get(this));
            }
            catch (Exception e) {
                throw new BeeDataSourceConfigException("Failed to copy field[" + field.getName() + "]", e);
            }
            finally {
                if (!accessible) {
                    field.setAccessible(accessible);
                }
            }
        }
    }

    private Driver loadJdbcDriver(String driverClassName) throws BeeDataSourceConfigException {
        try {
            Class<?> driverClass = Class.forName(driverClassName, true, this.getClass().getClassLoader());
            Driver driver = (Driver)driverClass.newInstance();
            if (!driver.acceptsURL(this.jdbcUrl)) {
                throw new InstantiationException();
            }
            return driver;
        }
        catch (ClassNotFoundException e) {
            throw new BeeDataSourceConfigException("Driver class[" + driverClassName + "]not found");
        }
        catch (InstantiationException e) {
            throw new BeeDataSourceConfigException("Driver class[" + driverClassName + "]can't be instantiated");
        }
        catch (IllegalAccessException e) {
            throw new BeeDataSourceConfigException("Driver class[" + driverClassName + "]can't be instantiated", e);
        }
        catch (SQLException e) {
            throw new BeeDataSourceConfigException("Driver class[" + driverClassName + "]can't be instantiated", e);
        }
    }

    void check() throws SQLException {
        block30: {
            if (this.connectionFactory == null && BeecpUtil.isNullText(this.connectionFactoryClassName)) {
                Driver connectDriver = null;
                if (!BeecpUtil.isNullText(this.driverClassName)) {
                    connectDriver = this.loadJdbcDriver(this.driverClassName);
                } else if (!BeecpUtil.isNullText(this.jdbcUrl)) {
                    connectDriver = DriverManager.getDriver(this.jdbcUrl);
                }
                if (BeecpUtil.isNullText(this.jdbcUrl)) {
                    throw new BeeDataSourceConfigException("Connect url can't be null");
                }
                if (connectDriver == null) {
                    throw new BeeDataSourceConfigException("Failed to load jdbc Driver");
                }
                if (!BeecpUtil.isNullText(this.username)) {
                    this.connectProperties.put("user", this.username);
                }
                if (!BeecpUtil.isNullText(this.password)) {
                    this.connectProperties.put("password", this.password);
                }
                this.connectionFactory = new DriverConnectionFactory(this.jdbcUrl, connectDriver, this.connectProperties);
            } else if (this.connectionFactory == null && !BeecpUtil.isNullText(this.connectionFactoryClassName)) {
                try {
                    Class<?> conFactClass = Class.forName(this.connectionFactoryClassName, true, BeeDataSourceConfig.class.getClassLoader());
                    if (ConnectionFactory.class.isAssignableFrom(conFactClass)) {
                        this.connectionFactory = (ConnectionFactory)conFactClass.newInstance();
                        break block30;
                    }
                    if (DataSource.class.isAssignableFrom(conFactClass)) {
                        DataSource driverDataSource = (DataSource)conFactClass.newInstance();
                        for (Map.Entry<Object, Object> entry : this.connectProperties.entrySet()) {
                            if (!(entry.getKey() instanceof String)) continue;
                            try {
                                this.setDataSourceProperty((String)entry.getKey(), entry.getValue(), driverDataSource);
                            }
                            catch (Exception e) {
                                throw new BeeDataSourceConfigException("Failed to set datasource property[" + entry.getKey() + "]", e);
                            }
                        }
                        this.connectionFactory = new DataSourceConnectionFactory(driverDataSource, this.username, this.password);
                        break block30;
                    }
                    throw new BeeDataSourceConfigException("Custom connection factory class must be implemented 'ConnectionFactory' interface");
                }
                catch (ClassNotFoundException e) {
                    throw new BeeDataSourceConfigException("Class(" + this.connectionFactoryClassName + ")not found ");
                }
                catch (InstantiationException e) {
                    throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
                }
                catch (IllegalAccessException e) {
                    throw new BeeDataSourceConfigException("Failed to instantiate connection factory class:" + this.connectionFactoryClassName, e);
                }
            }
        }
        if (this.maxActive <= 0) {
            throw new BeeDataSourceConfigException("Pool 'maxActive' must be greater than zero");
        }
        if (this.initialSize < 0) {
            throw new BeeDataSourceConfigException("Pool 'initialSize' must be greater than zero");
        }
        if (this.initialSize > this.maxActive) {
            throw new BeeDataSourceConfigException("Pool 'initialSize' must not be greater than 'maxActive'");
        }
        if (this.borrowConcurrentSize <= 0) {
            throw new BeeDataSourceConfigException("Pool 'borrowConcurrentSize' must be greater than zero");
        }
        if (this.borrowConcurrentSize > this.maxActive) {
            throw new BeeDataSourceConfigException("Pool 'borrowConcurrentSize' must not be greater than pool max size");
        }
        if (this.idleTimeout <= 0L) {
            throw new BeeDataSourceConfigException("Connection 'idleTimeout' must be greater than zero");
        }
        if (this.holdTimeout <= 0L) {
            throw new BeeDataSourceConfigException("Connection 'holdTimeout' must be greater than zero");
        }
        if (this.maxWait <= 0L) {
            throw new BeeDataSourceConfigException("Borrower 'maxWait' must be greater than zero");
        }
        if (this.preparedStatementCacheSize < 0) {
            throw new BeeDataSourceConfigException("Connection 'preparedStatementCacheSize' must not be lesser than zero");
        }
        this.defaultTransactionIsolationCode = TransactionIsolationLevel.nameToCode(this.defaultTransactionIsolation);
        if (this.defaultTransactionIsolationCode == -999) {
            throw new BeeDataSourceConfigException("Valid transaction isolation level list:" + TransactionIsolationLevel.TRANS_LEVEL_LIST);
        }
        if (!BeecpUtil.isNullText(this.connectionTestSQL) && !this.connectionTestSQL.trim().toLowerCase().startsWith("select ")) {
            throw new BeeDataSourceConfigException("Connection 'connectionTestSQL' must start with 'select '");
        }
    }

    private void setDataSourceProperty(String propName, Object propValue, Object bean) throws Exception {
        if (propName.endsWith(".")) {
            return;
        }
        int index = propName.lastIndexOf(".");
        if (index >= 0) {
            propName = propName.substring(index + 1);
        }
        propName = propName.trim();
        String methodName = "set" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
        Method[] methods = bean.getClass().getMethods();
        Method targetMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != 1) continue;
            targetMethod = method;
            break;
        }
        if (targetMethod != null) {
            Class<?> paramType = targetMethod.getParameterTypes()[0];
            if (paramType.isInstance(propValue)) {
                targetMethod.invoke(bean, propValue);
            } else if (propValue instanceof String) {
                String value = (String)propValue;
                if (paramType == String.class) {
                    targetMethod.invoke(bean, propValue);
                } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
                    targetMethod.invoke(bean, Boolean.valueOf(value));
                } else if (paramType == Integer.TYPE || paramType == Integer.class) {
                    targetMethod.invoke(bean, Integer.valueOf(value));
                } else if (paramType == Long.TYPE || paramType == Long.class) {
                    targetMethod.invoke(bean, Long.valueOf(value));
                }
            }
        }
    }

    public void loadPropertiesFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        this.loadPropertiesFile(file);
    }

    public void loadPropertiesFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException("Invalid properties file");
        }
        if (!file.getAbsolutePath().toLowerCase().endsWith(".properties")) {
            throw new IOException("Invalid properties file");
        }
        if (!this.checked) {
            try (FileInputStream stream = null;){
                stream = new FileInputStream(file);
                this.connectProperties.clear();
                this.connectProperties.load(stream);
            }
        }
    }
}

