/*
 * Decompiled with CFR 0.152.
 */
package cn.beecp;

import cn.beecp.BeeDataSourceConfig;
import cn.beecp.pool.ConnectionPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import javax.sql.DataSource;

public final class BeeDataSource
extends BeeDataSourceConfig
implements DataSource {
    private boolean inited;
    private ConnectionPool pool;
    private SQLException failedCause;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public BeeDataSource() {
    }

    public BeeDataSource(BeeDataSourceConfig config) {
        try {
            config.copyTo(this);
            this.pool = BeeDataSource.createPool(this);
            this.inited = true;
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public BeeDataSource(String driver, String url, String user, String password) {
        super(driver, url, user, password);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.inited) {
            return this.pool.getConnection();
        }
        if (this.writeLock.tryLock()) {
            try {
                if (this.inited) return this.pool.getConnection();
                this.failedCause = null;
                this.pool = BeeDataSource.createPool(this);
                this.inited = true;
                return this.pool.getConnection();
            }
            catch (SQLException e) {
                this.failedCause = e;
                throw e;
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            try {
                this.readLock.lock();
                if (this.failedCause == null) return this.pool.getConnection();
                throw this.failedCause;
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Not support");
    }

    public void close() throws SQLException {
        if (this.pool == null) {
            throw new SQLException("DataSource not initialized");
        }
        this.pool.shutdown();
    }

    public boolean isClosed() throws SQLException {
        if (this.pool != null) {
            return this.pool.isShutdown();
        }
        throw new SQLException("DataSource not initialized");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new SQLException("Not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new SQLException("Wrapped object is not an instance of " + iface);
    }

    private static final ConnectionPool createPool(BeeDataSourceConfig config) throws SQLException {
        String poolImplementClassName = config.getPoolImplementClassName();
        try {
            Class<?> poolClass;
            if (poolImplementClassName == null || poolImplementClassName.trim().length() == 0) {
                poolImplementClassName = "cn.beecp.pool.FastConnectionPool";
            }
            if (!ConnectionPool.class.isAssignableFrom(poolClass = Class.forName(poolImplementClassName, true, BeeDataSource.class.getClassLoader()))) {
                throw new IllegalArgumentException("Connection pool class must be implemented 'ConnectionPool' interface");
            }
            config.check();
            config.setAsChecked();
            ConnectionPool pool = (ConnectionPool)poolClass.newInstance();
            pool.init(config);
            return pool;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Not found connection pool implementation class:" + poolImplementClassName);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
    }
}

