/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.chanjar.weixin.common.util.BeanUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class SignUtils {
    public static String createSign(Object xmlBean, String signKey, String signType) {
        return SignUtils.createSign(BeanUtils.xmlBean2Map((Object)xmlBean), signKey, signType);
    }

    public static String createSign(Map<String, String> params, String signKey, String signType) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(params);
        StringBuilder toSign = new StringBuilder();
        for (String key : sortedMap.keySet()) {
            String value = params.get(key);
            if (!StringUtils.isNotEmpty((CharSequence)value) || StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"sign", "key", "sign_type"})) continue;
            toSign.append(key).append("=").append(value).append("&");
        }
        toSign.append("key=").append(signKey);
        if ("HMAC-SHA256".equals(signType)) {
            return SignUtils.createHMACSha256Sign(toSign.toString(), signKey);
        }
        return DigestUtils.md5Hex((String)toSign.toString()).toUpperCase();
    }

    private static String createHMACSha256Sign(String message, String key) {
        try {
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(), "HmacSHA256");
            hmacSHA256.init(secretKeySpec);
            byte[] bytes = hmacSHA256.doFinal(message.getBytes());
            return Hex.encodeHexString((byte[])bytes).toUpperCase();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean checkSign(Object xmlBean, String signKey) {
        return SignUtils.checkSign(BeanUtils.xmlBean2Map((Object)xmlBean), signKey);
    }

    public static boolean checkSign(Map<String, String> params, String signKey) {
        String sign = SignUtils.createSign(params, signKey, null);
        return sign.equals(params.get("sign"));
    }
}

