/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.WxPayBaseRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayRefundRequest
extends WxPayBaseRequest {
    private static final String[] REFUND_ACCOUNT = new String[]{"REFUND_SOURCE_RECHARGE_FUNDS", "REFUND_SOURCE_UNSETTLED_FUNDS"};
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @Required
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @Required
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @Required
    @XStreamAlias(value="refund_fee")
    private Integer refundFee;
    @XStreamAlias(value="refund_fee_type")
    private String refundFeeType;
    @XStreamAlias(value="op_user_id")
    private String opUserId;
    @XStreamAlias(value="refund_account")
    private String refundAccount;
    @XStreamAlias(value="refund_desc")
    private String refundDesc;

    private WxPayRefundRequest(Builder builder) {
        this.setDeviceInfo(builder.deviceInfo);
        this.setAppid(builder.appid);
        this.setTransactionId(builder.transactionId);
        this.setMchId(builder.mchId);
        this.setSubAppId(builder.subAppId);
        this.setOutTradeNo(builder.outTradeNo);
        this.setSubMchId(builder.subMchId);
        this.setOutRefundNo(builder.outRefundNo);
        this.setNonceStr(builder.nonceStr);
        this.setTotalFee(builder.totalFee);
        this.setSign(builder.sign);
        this.setRefundFee(builder.refundFee);
        this.setRefundFeeType(builder.refundFeeType);
        this.setOpUserId(builder.opUserId);
        this.setRefundAccount(builder.refundAccount);
        this.setRefundDesc(builder.refundDesc);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public Integer getRefundFee() {
        return this.refundFee;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public String getRefundFeeType() {
        return this.refundFeeType;
    }

    public void setRefundFeeType(String refundFeeType) {
        this.refundFeeType = refundFeeType;
    }

    public String getOpUserId() {
        return this.opUserId;
    }

    public void setOpUserId(String opUserId) {
        this.opUserId = opUserId;
    }

    public String getRefundAccount() {
        return this.refundAccount;
    }

    public void setRefundAccount(String refundAccount) {
        this.refundAccount = refundAccount;
    }

    public String getRefundDesc() {
        return this.refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public WxPayRefundRequest() {
    }

    @Override
    public void checkAndSign(WxPayConfig config) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)this.getOpUserId())) {
            this.setOpUserId(config.getMchId());
        }
        super.checkAndSign(config);
    }

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getRefundAccount()) && !ArrayUtils.contains((Object[])REFUND_ACCOUNT, (Object)this.getRefundAccount())) {
            throw new WxPayException(String.format("refund_account\u76ee\u524d\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(REFUND_ACCOUNT), this.getRefundAccount()));
        }
        if (StringUtils.isBlank((CharSequence)this.getOutTradeNo()) && StringUtils.isBlank((CharSequence)this.getTransactionId())) {
            throw new WxPayException("transaction_id \u548c out_trade_no \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u5fc5\u987b\u63d0\u4f9b\u4e00\u4e2a");
        }
    }

    public static final class Builder {
        private String deviceInfo;
        private String appid;
        private String transactionId;
        private String mchId;
        private String subAppId;
        private String outTradeNo;
        private String subMchId;
        private String outRefundNo;
        private String nonceStr;
        private Integer totalFee;
        private String sign;
        private Integer refundFee;
        private String refundFeeType;
        private String opUserId;
        private String refundAccount;
        private String refundDesc;

        private Builder() {
        }

        public Builder deviceInfo(String deviceInfo) {
            this.deviceInfo = deviceInfo;
            return this;
        }

        public Builder appid(String appid) {
            this.appid = appid;
            return this;
        }

        public Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public Builder mchId(String mchId) {
            this.mchId = mchId;
            return this;
        }

        public Builder subAppId(String subAppId) {
            this.subAppId = subAppId;
            return this;
        }

        public Builder outTradeNo(String outTradeNo) {
            this.outTradeNo = outTradeNo;
            return this;
        }

        public Builder subMchId(String subMchId) {
            this.subMchId = subMchId;
            return this;
        }

        public Builder outRefundNo(String outRefundNo) {
            this.outRefundNo = outRefundNo;
            return this;
        }

        public Builder nonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
            return this;
        }

        public Builder totalFee(Integer totalFee) {
            this.totalFee = totalFee;
            return this;
        }

        public Builder sign(String sign) {
            this.sign = sign;
            return this;
        }

        public Builder refundFee(Integer refundFee) {
            this.refundFee = refundFee;
            return this;
        }

        public Builder refundFeeType(String refundFeeType) {
            this.refundFeeType = refundFeeType;
            return this;
        }

        public Builder opUserId(String opUserId) {
            this.opUserId = opUserId;
            return this;
        }

        public Builder refundAccount(String refundAccount) {
            this.refundAccount = refundAccount;
            return this;
        }

        public Builder refundDesc(String refundDesc) {
            this.refundDesc = refundDesc;
            return this;
        }

        public WxPayRefundRequest build() {
            return new WxPayRefundRequest(this);
        }
    }
}

