/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.request;

import com.github.binarywang.wxpay.bean.request.WxPayBaseRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Arrays;
import me.chanjar.weixin.common.annotation.Required;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@XStreamAlias(value="xml")
public class WxPayDownloadBillRequest
extends WxPayBaseRequest {
    private static final String[] BILL_TYPES = new String[]{"ALL", "SUCCESS", "REFUND", "RECHARGE_REFUND"};
    private static final String TAR_TYPE_GZIP = "GZIP";
    @XStreamAlias(value="device_info")
    private String deviceInfo;
    @XStreamAlias(value="sign_type")
    private String signType;
    @Required
    @XStreamAlias(value="bill_type")
    private String billType;
    @Required
    @XStreamAlias(value="bill_date")
    private String billDate;
    @XStreamAlias(value="tar_type")
    private String tarType;

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    @Override
    public String getSignType() {
        return this.signType;
    }

    @Override
    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillDate() {
        return this.billDate;
    }

    public void setBillDate(String billDate) {
        this.billDate = billDate;
    }

    public String getTarType() {
        return this.tarType;
    }

    public void setTarType(String tarType) {
        this.tarType = tarType;
    }

    @Override
    protected void checkConstraints() throws WxPayException {
        if (StringUtils.isNotBlank((CharSequence)this.getTarType()) && !TAR_TYPE_GZIP.equals(this.getTarType())) {
            throw new WxPayException("tar_type\u503c\u5982\u679c\u5b58\u5728\uff0c\u53ea\u80fd\u4e3aGZIP");
        }
        if (!ArrayUtils.contains((Object[])BILL_TYPES, (Object)this.getBillType())) {
            throw new WxPayException(String.format("bill_type\u76ee\u524d\u5fc5\u987b\u4e3a%s\u5176\u4e2d\u4e4b\u4e00,\u5b9e\u9645\u503c\uff1a%s", Arrays.toString(BILL_TYPES), this.getBillType()));
        }
    }
}

