/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.mp.bean.WxMpMassOpenIdsMessage;
import org.apache.commons.lang3.StringUtils;

public class WxMpMassOpenIdsMessageGsonAdapter
implements JsonSerializer<WxMpMassOpenIdsMessage> {
    public JsonElement serialize(WxMpMassOpenIdsMessage message, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject sub;
        JsonObject messageJson = new JsonObject();
        JsonArray toUsers = new JsonArray();
        for (String openId : message.getToUsers()) {
            toUsers.add((JsonElement)new JsonPrimitive(openId));
        }
        messageJson.add("touser", (JsonElement)toUsers);
        if ("mpnews".equals(message.getMsgType())) {
            sub = new JsonObject();
            sub.addProperty("media_id", message.getMediaId());
            messageJson.add("mpnews", (JsonElement)sub);
        }
        if ("text".equals(message.getMsgType())) {
            sub = new JsonObject();
            sub.addProperty("content", message.getContent());
            messageJson.add("text", (JsonElement)sub);
        }
        if ("voice".equals(message.getMsgType())) {
            sub = new JsonObject();
            sub.addProperty("media_id", message.getMediaId());
            messageJson.add("voice", (JsonElement)sub);
        }
        if ("image".equals(message.getMsgType())) {
            sub = new JsonObject();
            sub.addProperty("media_id", message.getMediaId());
            messageJson.add("image", (JsonElement)sub);
        }
        if ("mpvideo".equals(message.getMsgType())) {
            sub = new JsonObject();
            sub.addProperty("media_id", message.getMediaId());
            messageJson.add("mpvideo", (JsonElement)sub);
        }
        messageJson.addProperty("msgtype", message.getMsgType());
        messageJson.addProperty("send_ignore_reprint", (Number)(message.isSendIgnoreReprint() ? 0 : 1));
        if (StringUtils.isNotEmpty((CharSequence)message.getClientMsgId())) {
            messageJson.addProperty("clientmsgid", message.getClientMsgId());
        }
        return messageJson;
    }
}

