/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.util.crypto;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import me.chanjar.weixin.common.util.crypto.WxCryptUtil;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.codec.binary.Base64;

public class WxCpCryptUtil
extends WxCryptUtil {
    public WxCpCryptUtil(WxCpConfigStorage wxCpConfigStorage) {
        String encodingAesKey = wxCpConfigStorage.getAesKey();
        String token = wxCpConfigStorage.getToken();
        String corpId = wxCpConfigStorage.getCorpId();
        this.token = token;
        this.appidOrCorpid = corpId;
        this.aesKey = BaseEncoding.base64().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)encodingAesKey));
    }

    public static String decryptByPriKey(String encryptRandomKey, String msgAuditPriKey) throws Exception {
        String privateKey = msgAuditPriKey.replaceAll("\\n", "").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll(" ", "");
        byte[] keyByte = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyByte);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, priKey);
        byte[] utf8 = cipher.doFinal(Base64.decodeBase64((String)encryptRandomKey));
        return new String(utf8, "UTF-8");
    }
}

