/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpGroupRobotService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.article.NewArticle;
import me.chanjar.weixin.cp.bean.message.WxCpGroupRobotMessage;
import me.chanjar.weixin.cp.config.WxCpConfigStorage;
import org.apache.commons.lang3.StringUtils;

public class WxCpGroupRobotServiceImpl
implements WxCpGroupRobotService {
    private final WxCpService cpService;

    private String getWebhookUrl() throws WxErrorException {
        WxCpConfigStorage wxCpConfigStorage = this.cpService.getWxCpConfigStorage();
        String webhookKey = wxCpConfigStorage.getWebhookKey();
        if (StringUtils.isEmpty((CharSequence)webhookKey)) {
            throw new WxErrorException("\u8bf7\u5148\u8bbe\u7f6eWebhookKey");
        }
        return wxCpConfigStorage.getApiUrl("/cgi-bin/webhook/send?key=") + webhookKey;
    }

    @Override
    public void sendText(String content, List<String> mentionedList, List<String> mobileList) throws WxErrorException {
        this.sendText(this.getWebhookUrl(), content, mentionedList, mobileList);
    }

    @Override
    public void sendMarkdown(String content) throws WxErrorException {
        this.sendMarkdown(this.getWebhookUrl(), content);
    }

    @Override
    public void sendImage(String base64, String md5) throws WxErrorException {
        this.sendImage(this.getWebhookUrl(), base64, md5);
    }

    @Override
    public void sendNews(List<NewArticle> articleList) throws WxErrorException {
        this.sendNews(this.getWebhookUrl(), articleList);
    }

    @Override
    public void sendText(String webhookUrl, String content, List<String> mentionedList, List<String> mobileList) throws WxErrorException {
        this.cpService.postWithoutToken(webhookUrl, new WxCpGroupRobotMessage().setMsgType("text").setContent(content).setMentionedList(mentionedList).setMentionedMobileList(mobileList).toJson());
    }

    @Override
    public void sendMarkdown(String webhookUrl, String content) throws WxErrorException {
        this.cpService.postWithoutToken(webhookUrl, new WxCpGroupRobotMessage().setMsgType("markdown").setContent(content).toJson());
    }

    @Override
    public void sendImage(String webhookUrl, String base64, String md5) throws WxErrorException {
        this.cpService.postWithoutToken(webhookUrl, new WxCpGroupRobotMessage().setMsgType("image").setBase64(base64).setMd5(md5).toJson());
    }

    @Override
    public void sendNews(String webhookUrl, List<NewArticle> articleList) throws WxErrorException {
        this.cpService.postWithoutToken(webhookUrl, new WxCpGroupRobotMessage().setMsgType("news").setArticles(articleList).toJson());
    }

    public WxCpGroupRobotServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

