/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.template;

import com.github.missthee.tool.excel.template.SimpleCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class TemplateTool {
    public static SimpleCell getSimpleCellInfo(Sheet sheet, Cell cell) {
        int x = cell.getColumnIndex();
        int y = cell.getRowIndex();
        int w = 1;
        int h = 1;
        for (CellRangeAddress cellRangeAddress : sheet.getMergedRegions()) {
            int firstX = cellRangeAddress.getFirstColumn();
            int lastX = cellRangeAddress.getLastColumn();
            int firstY = cellRangeAddress.getFirstRow();
            int lastY = cellRangeAddress.getLastRow();
            if (!cellRangeAddress.containsRow(y) || !cellRangeAddress.containsColumn(x)) continue;
            if (y == firstY && x == firstX) {
                cell.setCellType(CellType.STRING);
                String value = cell.getStringCellValue();
                x = cell.getColumnIndex();
                y = cell.getRowIndex();
                w = lastX - firstX + 1;
                h = lastY - firstY + 1;
                return new SimpleCell(value, x, y, w, h);
            }
            return new SimpleCell(null, x, y, w, h);
        }
        cell.setCellType(CellType.STRING);
        String value = cell.getStringCellValue();
        return new SimpleCell(value, x, y, w, h);
    }
}

