/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.exports.direct;

import com.github.missthee.tool.excel.exports.direct.CellPoint;
import com.github.missthee.tool.excel.exports.direct.DataColumn;
import com.github.missthee.tool.excel.exports.direct.DefaultStyle;
import com.github.missthee.tool.excel.exports.direct.WorkBookVersion;
import com.github.missthee.tool.excel.reflection.GetterAndSetter;
import com.github.missthee.tool.excel.response.ResponseTool;
import com.github.missthee.tool.excel.template.CellFomatter;
import com.github.missthee.tool.excel.template.SimpleCell;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelExport {
    @SafeVarargs
    public static <T> CellPoint addRows(Workbook wb, int sheetIndex, int startRowIndex, int startColumnIndex, String title, List<DataColumn> dataColumnList, Boolean showHeaderColumn, List<T> dataList, Boolean withIndex, List<SimpleCell> ... extraHeaderCell) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        CellStyle titleStyle = DefaultStyle.titleStyle(wb);
        CellStyle headerStyle = DefaultStyle.headerStyle(wb);
        CellStyle dataStyle = DefaultStyle.dataStyle(wb);
        CellPoint cellPoint = new CellPoint(startRowIndex, startColumnIndex);
        dataColumnList = dataColumnList.stream().filter(e -> e.getHeaderName() != null && !"".equals(e.getHeaderName())).collect(Collectors.toList());
        Sheet sheet = ExcelExport.buildSheet(wb, sheetIndex);
        ExcelExport.addTitle(sheet, titleStyle, cellPoint, dataColumnList, withIndex, title);
        ExcelExport.addExtraHeader(sheet, headerStyle, cellPoint, extraHeaderCell);
        ExcelExport.addHeader(sheet, headerStyle, cellPoint, dataColumnList, withIndex, showHeaderColumn);
        ExcelExport.addData(sheet, dataStyle, cellPoint, dataColumnList, dataList, withIndex);
        return cellPoint;
    }

    @SafeVarargs
    public static <T> Workbook buildWorkBook(WorkBookVersion workBookVersion, String title, Map<String, String> columnMap, Boolean showHeaderColumn, List<T> dataList, Boolean withIndex, List<SimpleCell> ... extraHeaderCell) throws Exception {
        HSSFWorkbook wb;
        switch (workBookVersion) {
            case Excel97_2003: {
                wb = new HSSFWorkbook();
                break;
            }
            case Excel2007: {
                wb = new XSSFWorkbook();
                break;
            }
            default: {
                throw new Exception("invalid workBookVersion");
            }
        }
        wb.createSheet();
        ArrayList<DataColumn> dataColumns = new ArrayList<DataColumn>();
        for (String key : columnMap.keySet()) {
            dataColumns.add(new DataColumn(key, columnMap.get(key)));
        }
        ExcelExport.addRows((Workbook)wb, 0, 0, 0, title, dataColumns, showHeaderColumn, dataList, withIndex, extraHeaderCell);
        return wb;
    }

    private static Sheet buildSheet(Workbook wb, int sheetIndex) {
        while (sheetIndex >= wb.getNumberOfSheets() - 1) {
            wb.createSheet();
        }
        return wb.getSheetAt(sheetIndex);
    }

    private static CellPoint addTitle(Sheet sheet, CellStyle titleStyle, CellPoint cellPoint, List<DataColumn> dataColumnList, boolean withIndex, String title) {
        int titleWidth = dataColumnList.size() - (withIndex ? 0 : 1);
        if (title != null) {
            Row rowTitle = sheet.createRow(cellPoint.getY());
            Cell cellTitle = rowTitle.createCell(cellPoint.getX());
            cellTitle.setCellType(CellType.STRING);
            cellTitle.setCellValue(title);
            cellTitle.setCellStyle(titleStyle);
            if (titleWidth > 0) {
                CellRangeAddress cellRangeAddress = new CellRangeAddress(cellPoint.getOriginY(), cellPoint.getY(), cellPoint.getOriginY(), titleWidth + cellPoint.getOriginX());
                sheet.addMergedRegion(cellRangeAddress);
                CellFomatter.setRegionStyle(sheet, cellRangeAddress, titleStyle);
            }
            cellPoint.moveXY(1);
        }
        return cellPoint;
    }

    @SafeVarargs
    private static CellPoint addExtraHeader(Sheet sheet, CellStyle headerStyle, CellPoint cellPoint, List<SimpleCell> ... headerCellLists) {
        if (headerCellLists != null && headerCellLists.length > 0) {
            cellPoint.setXToOrigin();
            int startRowIndex = cellPoint.getY();
            for (List<SimpleCell> headerCellList : headerCellLists) {
                for (SimpleCell headerCell : headerCellList) {
                    String value = headerCell.getValue();
                    Integer x = headerCell.getX();
                    Integer y = headerCell.getY() == null ? null : Integer.valueOf(headerCell.getY() + startRowIndex);
                    Integer w = headerCell.getW();
                    Integer h = headerCell.getH();
                    if (x == null || y == null) {
                        x = cellPoint.getX();
                        y = cellPoint.getY();
                    }
                    Row row = sheet.getRow(y.intValue()) == null ? sheet.createRow(y.intValue()) : sheet.getRow(y.intValue());
                    Cell cell = row.createCell(x.intValue());
                    cell.setCellValue(value);
                    if (w > 1 || h > 1) {
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(y.intValue(), y + h - 1, x.intValue(), x + w - 1);
                        sheet.addMergedRegion(cellRangeAddress);
                        CellFomatter.setRegionStyle(sheet, cellRangeAddress, headerStyle);
                    } else {
                        cell.setCellStyle(headerStyle);
                    }
                    CellFomatter.setColumnAdaptiveWidth(sheet, cell, true);
                    cellPoint.setX(x + w);
                    cellPoint.setY(y);
                }
                cellPoint.moveY(1);
            }
        }
        return cellPoint;
    }

    private static CellPoint addHeader(Sheet sheet, CellStyle headerStyle, CellPoint cellPoint, List<DataColumn> dataColumnList, boolean withIndex, boolean showHeaderColumn) {
        if (showHeaderColumn) {
            cellPoint.setXToOrigin();
            Row rowHeader = sheet.createRow(cellPoint.getY());
            if (withIndex) {
                String columnName = "\u5e8f\u53f7";
                Cell sequenceCell = rowHeader.createCell(cellPoint.getX());
                sequenceCell.setCellValue(columnName);
                sequenceCell.setCellStyle(headerStyle);
                CellFomatter.setColumnAdaptiveWidth(sheet, sequenceCell, true);
                cellPoint.moveX(1);
            }
            for (DataColumn dataColumn : dataColumnList) {
                String columnName = dataColumn.getHeaderName();
                Cell titleCell = rowHeader.createCell(cellPoint.getX());
                titleCell.setCellValue(columnName);
                if (dataColumn.getWidth() > 1) {
                    CellRangeAddress cellRangeAddress = new CellRangeAddress(cellPoint.getY(), cellPoint.getY(), cellPoint.getX(), cellPoint.getX() + dataColumn.getWidth() - 1);
                    sheet.addMergedRegion(cellRangeAddress);
                    CellFomatter.setRegionStyle(sheet, cellRangeAddress, headerStyle);
                } else {
                    titleCell.setCellStyle(headerStyle);
                }
                CellFomatter.setColumnAdaptiveWidth(sheet, titleCell, true);
                cellPoint.moveX(dataColumn.getWidth());
            }
            cellPoint.moveY(1);
        }
        return cellPoint;
    }

    private static <T> CellPoint addData(Sheet sheet, CellStyle dataStyle, CellPoint cellPoint, List<DataColumn> dataColumnList, List<T> dataList, boolean withIndex) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (dataList != null) {
            Iterator<T> it = dataList.iterator();
            int indexNumber = 1;
            while (it.hasNext()) {
                Row rowData = sheet.createRow(cellPoint.getY());
                int columnIndex = cellPoint.getOriginX();
                if (withIndex) {
                    Cell sequenceCellValue = rowData.createCell(columnIndex);
                    sequenceCellValue.setCellValue((double)indexNumber++);
                    sequenceCellValue.setCellStyle(dataStyle);
                    ++columnIndex;
                }
                T t = it.next();
                for (DataColumn dataColumn : dataColumnList) {
                    Object value;
                    Cell dataCell = rowData.createCell(columnIndex);
                    short dataFormatBack = dataStyle.getDataFormat();
                    if (!dataColumn.getIsEmptyData().booleanValue() && (value = GetterAndSetter.invokeGetMethod(t, dataColumn.getModelPropertyName())) != null) {
                        if (value instanceof Float || value instanceof Double) {
                            dataStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"@"));
                            double newValue = new BigDecimal(value.toString()).setScale(2, 4).doubleValue();
                            dataCell.setCellValue(newValue);
                        } else if (value instanceof Long || value instanceof Integer) {
                            dataStyle.setDataFormat((short)BuiltinFormats.getBuiltinFormat((String)"@"));
                            long newValue = (Long)value;
                            dataCell.setCellValue((double)newValue);
                        } else {
                            dataCell.setCellValue(value.toString());
                        }
                        CellFomatter.setColumnAdaptiveWidth(sheet, dataCell, true);
                        dataStyle.setDataFormat(dataFormatBack);
                    }
                    if (dataColumn.getWidth() > 1) {
                        CellRangeAddress cellRangeAddress = new CellRangeAddress(cellPoint.getY(), cellPoint.getY(), columnIndex, columnIndex + dataColumn.getWidth() - 1);
                        sheet.addMergedRegion(cellRangeAddress);
                        CellFomatter.setRegionStyle(sheet, cellRangeAddress, dataStyle);
                    } else {
                        dataCell.setCellStyle(dataStyle);
                    }
                    cellPoint.setX(columnIndex += dataColumn.getWidth().intValue());
                }
                cellPoint.moveXY(1);
            }
        }
        return cellPoint;
    }

    @SafeVarargs
    public static <T> void export(WorkBookVersion workBookVersion, HttpServletResponse response, String fileName, String title, Map<String, String> columnMap, Boolean showHeaderColumn, List<T> dataList, Boolean withIndex, List<SimpleCell> ... extraHeaderCell) throws Exception {
        String fullFileName = fileName + workBookVersion.getFileType();
        Workbook wb = ExcelExport.buildWorkBook(workBookVersion, title, columnMap, showHeaderColumn, dataList, withIndex, extraHeaderCell);
        ResponseTool.responseOut(response, wb, fullFileName);
    }

    @SafeVarargs
    public static <T> CellPoint addRows(Workbook wb, String title, Map<String, String> columnMap, Boolean showHeaderColumn, List<T> dataList, Boolean withIndex, List<SimpleCell> ... extraHeaderCell) throws Exception {
        ArrayList<DataColumn> dataColumns = new ArrayList<DataColumn>();
        for (String key : columnMap.keySet()) {
            dataColumns.add(new DataColumn(key, columnMap.get(key)));
        }
        return ExcelExport.addRows(wb, 0, 0, 0, title, dataColumns, showHeaderColumn, dataList, withIndex, extraHeaderCell);
    }
}

