/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.exports.direct;

public class CellPoint {
    private final int originY;
    private final int originX;
    private int y;
    private int x;

    public CellPoint(int y, int x) {
        this.originY = y;
        this.originX = x;
        this.y = y;
        this.x = x;
    }

    public CellPoint moveXY(int value) {
        this.y += value;
        this.x += value;
        return this;
    }

    public CellPoint moveY(int value) {
        this.y += value;
        return this;
    }

    public CellPoint moveX(int value) {
        this.x += value;
        return this;
    }

    public CellPoint setXToOrigin() {
        this.x = this.originX;
        return this;
    }

    public CellPoint setYToOrigin() {
        this.y = this.originY;
        return this;
    }

    public int getOriginY() {
        return this.originY;
    }

    public int getOriginX() {
        return this.originX;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public CellPoint setY(int y) {
        this.y = y;
        return this;
    }

    public CellPoint setX(int x) {
        this.x = x;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CellPoint)) {
            return false;
        }
        CellPoint other = (CellPoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOriginY() != other.getOriginY()) {
            return false;
        }
        if (this.getOriginX() != other.getOriginX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getX() == other.getX();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CellPoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOriginY();
        result = result * 59 + this.getOriginX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getX();
        return result;
    }

    public String toString() {
        return "CellPoint(originY=" + this.getOriginY() + ", originX=" + this.getOriginX() + ", y=" + this.getY() + ", x=" + this.getX() + ")";
    }
}

