/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.excel.exports.bytemplate;

import com.github.missthee.tool.excel.reflection.GetterAndSetter;
import com.github.missthee.tool.excel.reflection.ParamInfo;
import com.github.missthee.tool.excel.response.ResponseTool;
import com.github.missthee.tool.excel.template.CellFomatter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.impl.piccolo.io.FileFormatException;

public class ExcelExportByTemplate {
    private static ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");

    public static Workbook readFile(String templateFilePath) throws IOException {
        HSSFWorkbook wb;
        if (templateFilePath.endsWith(".xls")) {
            wb = new HSSFWorkbook(Objects.requireNonNull(ExcelExportByTemplate.class.getClassLoader().getResourceAsStream(templateFilePath)));
        } else if (templateFilePath.endsWith(".xlsx")) {
            wb = new XSSFWorkbook(Objects.requireNonNull(ExcelExportByTemplate.class.getClassLoader().getResourceAsStream(templateFilePath)));
        } else {
            throw new FileFormatException(" only for .xls or .xlsx ");
        }
        return wb;
    }

    public static <T> Workbook simplePartialReplaceByPOJO(Workbook wb, int sheetIndex, T t, boolean cellAutoWidth) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, ScriptException {
        Sheet sheet = wb.getSheetAt(sheetIndex);
        for (Row row : sheet) {
            if (row == null) continue;
            for (Cell cell : row) {
                cell.setCellType(CellType.STRING);
                String cellString = cell.getStringCellValue();
                cellString = ExcelExportByTemplate.jsValue(cellString, t);
                cell.setCellValue(cellString);
                cellString = ExcelExportByTemplate.computeValue(cellString, t);
                cell.setCellValue(cellString);
                cellString = ExcelExportByTemplate.computeValue0AsEmpty(cellString, t);
                cell.setCellValue(cellString);
                cellString = ExcelExportByTemplate.replaceValue(cell.getStringCellValue(), t, "");
                cell.setCellValue(cellString);
                if (!cellAutoWidth) continue;
                CellFomatter.setColumnAdaptiveWidth(sheet, cell, true);
            }
        }
        return wb;
    }

    private static <T> String jsValue(String cellString, T t) throws ScriptException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (cellString != null && !"".equals(cellString)) {
            Matcher m = Pattern.compile("<JS>(.*?)</JS>").matcher(cellString);
            while (m.find()) {
                String matchValue = m.group(1);
                Object computeResultObj = jse.eval(matchValue);
                String computeResultStr = computeResultObj == null ? "" : String.valueOf(computeResultObj);
                cellString = cellString.replace(m.group(), computeResultStr);
            }
        }
        return cellString;
    }

    private static <T> String computeValue(String cellString, T t) throws ScriptException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (cellString != null && !"".equals(cellString)) {
            Matcher m = Pattern.compile("<COMPUTE>(.*?)</COMPUTE>").matcher(cellString);
            while (m.find()) {
                String matchValue = m.group(1);
                String replacedValue = ExcelExportByTemplate.replaceValue(matchValue, t, "0");
                Object computeResultObj = jse.eval(replacedValue);
                String computeResultStr = computeResultObj == null ? "" : String.valueOf(computeResultObj);
                cellString = cellString.replace(m.group(), computeResultStr);
            }
        }
        return cellString;
    }

    private static <T> String computeValue0AsEmpty(String cellString, T t) throws ScriptException, NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        if (cellString != null && !"".equals(cellString)) {
            Matcher m = Pattern.compile("<COMPUTE_EMPTY>(.*?)</COMPUTE_EMPTY>").matcher(cellString);
            while (m.find()) {
                String matchValue = m.group(1);
                String replacedValue = ExcelExportByTemplate.replaceValue(matchValue, t, "0");
                Object computeResultObj = jse.eval(replacedValue);
                String computeResultStr = computeResultObj == null ? "" : String.valueOf(computeResultObj);
                cellString = cellString.replace(m.group(), computeResultStr);
            }
        }
        if ("0".equals(cellString)) {
            cellString = "";
        }
        return cellString;
    }

    private static <T> String replaceValue(String originValue, T t, String replacedEmptyValue) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        if (originValue != null && !"".equals(originValue)) {
            Matcher m = Pattern.compile("\\$\\{(.*?)\\}").matcher(originValue);
            while (m.find()) {
                String matchValue = m.group(1);
                if ("".equals(matchValue)) {
                    originValue = replacedEmptyValue;
                    continue;
                }
                if (matchValue.contains(":") && !matchValue.trim().startsWith(":")) {
                    String modelPropertyName = matchValue.substring(0, matchValue.indexOf(":"));
                    String dateFormatString = matchValue.substring(matchValue.indexOf(":")).replaceFirst(":", "");
                    String propertyValue = ExcelExportByTemplate.convertDate2String(t, modelPropertyName, dateFormatString);
                    originValue = originValue.replace(m.group(), propertyValue == null ? replacedEmptyValue : propertyValue);
                    continue;
                }
                Object propertyObj = GetterAndSetter.invokeGetMethod(t, matchValue);
                String propertyStr = propertyObj == null ? replacedEmptyValue : propertyObj.toString();
                originValue = originValue.replace(m.group(), propertyStr);
            }
            return originValue;
        }
        return replacedEmptyValue;
    }

    public static <T> Workbook simpleReplaceByPOJOList(Workbook wb, int sheetIndex, List<T> dataList, List<String> propertyNameList, Class<T> clazz, boolean cellAutoWidth) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Sheet sheet = wb.getSheetAt(sheetIndex);
        int modelIndex = 0;
        for (int rowIndex = 0; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            for (int columnIndex = 0; columnIndex <= row.getLastCellNum(); ++columnIndex) {
                Cell cell = row.getCell(columnIndex);
                if (cell == null) continue;
                cell.setCellType(CellType.STRING);
                String valueStr = cell.getStringCellValue();
                if (valueStr == null || "".equals(valueStr) || dataList == null || dataList.size() <= 0 || !valueStr.equalsIgnoreCase("$[" + clazz.getSimpleName() + "]")) continue;
                if (modelIndex < dataList.size()) {
                    int repalceColumnIndex = columnIndex;
                    T t = dataList.get(modelIndex);
                    for (String propertyName : propertyNameList) {
                        Cell currentCell = ExcelExportByTemplate.getCurrentCell(sheet, rowIndex, repalceColumnIndex);
                        Object value = GetterAndSetter.invokeGetMethod(t, propertyName);
                        if ("null".equals(String.valueOf(value))) {
                            currentCell.setCellValue("");
                        } else {
                            currentCell.setCellValue(String.valueOf(value));
                        }
                        if (cellAutoWidth) {
                            CellFomatter.setColumnAdaptiveWidth(sheet, currentCell, true);
                        }
                        ++repalceColumnIndex;
                    }
                    ++modelIndex;
                    continue;
                }
                cell.setCellValue("");
            }
        }
        return wb;
    }

    public static <T> Workbook simpleReplaceByPOJOList(Workbook wb, int sheetIndex, List<T> dataList, List<String> propertyNameList, Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        return ExcelExportByTemplate.simpleReplaceByPOJOList(wb, sheetIndex, dataList, propertyNameList, clazz, true);
    }

    public static <T> Workbook simplePartialReplaceByPOJO(Workbook wb, int sheetIndex, T t) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, NoSuchFieldException, ScriptException {
        return ExcelExportByTemplate.simplePartialReplaceByPOJO(wb, sheetIndex, t, true);
    }

    public static void export(HttpServletResponse response, Workbook wb, String fileName) throws IOException {
        if (wb.getClass().equals(HSSFWorkbook.class)) {
            fileName = fileName + ".xls";
        } else if (wb.getClass().equals(XSSFWorkbook.class)) {
            fileName = fileName + ".xlsx";
        }
        ResponseTool.responseOut(response, wb, fileName);
    }

    private static Cell getCurrentCell(Sheet sheet, int rowIndex, int columnIndex) {
        Row currentRow = sheet.getRow(rowIndex);
        currentRow = currentRow == null ? sheet.createRow(rowIndex) : currentRow;
        Cell currentCell = currentRow.getCell(columnIndex);
        currentCell = currentCell == null ? currentRow.createCell(columnIndex) : currentCell;
        return currentCell;
    }

    private void setCellValue(Cell cell, Object value) {
        if (value == null) {
            return;
        }
        switch (cell.getCellTypeEnum()) {
            case NUMERIC: {
                cell.setCellValue(Double.parseDouble(value.toString()));
            }
            case BOOLEAN: {
                cell.setCellValue(Boolean.parseBoolean(value.toString()));
            }
            default: {
                cell.setCellValue(value.toString());
            }
            case ERROR: 
        }
    }

    private static Date LocalDate2Date(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    private static <T> String convertDate2String(T t, String propertyName, String dateFormat) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object value = GetterAndSetter.invokeGetMethod(t, propertyName);
        if (dateFormat != null && value != null) {
            if (ParamInfo.getPropertyClass(t, propertyName).getSimpleName().toLowerCase().contains("local")) {
                LocalDateTime localDateTimeValue = (LocalDateTime)value;
                Date dateValue = ExcelExportByTemplate.LocalDate2Date(localDateTimeValue);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                return simpleDateFormat.format(dateValue);
            }
            if (ParamInfo.getPropertyClass(t, propertyName).getSimpleName().toLowerCase().contains("date")) {
                Date dateValue = (Date)value;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                return simpleDateFormat.format(dateValue);
            }
        }
        if ("null".equals(String.valueOf(value))) {
            return null;
        }
        return String.valueOf(value);
    }
}

