/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.datastructure;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TreeData {
    public static <T> JSONArray tree(final List<T> li, Integer parentId, final Integer rootId, final Boolean rootIdIsNodeId, final String idColumn, final String parentIdColumn, final Map<String, String> attrMap) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        JSONArray nodeJA = new JSONArray();
        for (final T currentItem : li) {
            final Integer nodeId = (Integer)TreeData.getPropertyValue(currentItem, idColumn);
            Integer nodePId = (Integer)TreeData.getPropertyValue(currentItem, parentIdColumn);
            if (!(parentId == null ? Objects.equals(rootId, rootIdIsNodeId != false ? nodeId : nodePId) : Objects.equals(nodePId, parentId))) continue;
            JSONObject childrenJO = new JSONObject(){
                {
                    this.put("id", nodeId);
                    for (Map.Entry entry : attrMap.entrySet()) {
                        if (entry.getValue() == null || "".equals(entry.getValue())) continue;
                        this.put((String)entry.getKey(), TreeData.getPropertyValue(currentItem, (String)entry.getValue()));
                    }
                    this.put("children", TreeData.tree(li, nodeId, rootId, rootIdIsNodeId, idColumn, parentIdColumn, attrMap));
                }
            };
            if (childrenJO.getJSONArray("children") == null || childrenJO.getJSONArray("children").isEmpty()) {
                childrenJO.remove((Object)"children");
            }
            nodeJA.add((Object)childrenJO);
        }
        return nodeJA;
    }

    public static <T> JSONArray tree(List<T> li, Integer rootId, Boolean rootIdIsNodeId, Map<String, String> attrMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return TreeData.tree(li, null, rootId, rootIdIsNodeId, "id", "parentId", attrMap);
    }

    public static <T> JSONArray tree(List<T> li, Integer rootId, Map<String, String> attrMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return TreeData.tree(li, null, rootId, true, "id", "parentId", attrMap);
    }

    public static <T> JSONArray tree(List<T> li, Map<String, String> attrMap) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return TreeData.tree(li, null, null, false, "id", "parentId", attrMap);
    }

    public static <T> List<Integer> getChildIdList(List<T> li, Integer parentId, Integer rootId, Boolean rootIdIsNodeId, String idColumn, String parentIdColumn) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (T currentItem : li) {
            Integer nodeId = (Integer)currentItem.getClass().getMethod("get" + idColumn.substring(0, 1).toUpperCase() + idColumn.substring(1), new Class[0]).invoke(currentItem, new Object[0]);
            Integer nodePId = (Integer)currentItem.getClass().getMethod("get" + parentIdColumn.substring(0, 1).toUpperCase() + parentIdColumn.substring(1), new Class[0]).invoke(currentItem, new Object[0]);
            if (!(parentId == null ? Objects.equals(rootId, rootIdIsNodeId != false ? nodeId : nodePId) : Objects.equals(nodePId, parentId))) continue;
            idList.addAll(TreeData.getChildIdList(li, nodeId, rootId, rootIdIsNodeId, idColumn, parentIdColumn));
            idList.add(nodeId);
        }
        return idList;
    }

    public static <T> List<Integer> getChildIdList(List<T> li, Integer rootId, Boolean rootIdIsNodeId, String idColumn, String parentIdColumn) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return TreeData.getChildIdList(li, null, rootId, rootIdIsNodeId, idColumn, parentIdColumn);
    }

    public static <T> List<Integer> getChildIdList(List<T> li, Integer rootId, Boolean rootIdIsNodeId) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return TreeData.getChildIdList(li, null, rootId, rootIdIsNodeId, "id", "parentId");
    }

    public static <T> List<Integer> getChildIdList(List<T> li, Integer rootId) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return TreeData.getChildIdList(li, null, rootId, true, "id", "parentId");
    }

    private static Object getPropertyValue(Object currentItem, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return currentItem.getClass().getMethod("get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1), new Class[0]).invoke(currentItem, new Object[0]);
    }
}

