/*
 * Decompiled with CFR 0.152.
 */
package com.github.missthee.tool.collectioncompute;

import com.github.missthee.tool.collectioncompute.ComputeType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionCompute {
    private static Logger log = LoggerFactory.getLogger(CollectionCompute.class);

    public static <T> T buildComputeRow(int startIndex, int endIndex, List<T> dataList, Collection<String> columnKeys, Class<T> clazz, ComputeType computeType, Map<String, ComputeType> computeTypeMap) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Object t = Class.forName(clazz.getName()).newInstance();
        HashMap<String, Double> sumValueMap = new HashMap<String, Double>();
        endIndex = Math.min(dataList.size(), endIndex);
        for (int i = startIndex; i < endIndex; ++i) {
            for (String key1 : columnKeys) {
                Object value = CollectionCompute.invokeGetMethod(dataList.get(i), key1);
                if (value == null) continue;
                try {
                    double valueDouble = Double.parseDouble(String.valueOf(value));
                    sumValueMap.put(key1, sumValueMap.containsKey(key1) ? CollectionCompute.preciseCompute((Number)sumValueMap.get(key1), valueDouble, "+") : valueDouble);
                    try {
                        double sumValue;
                        double resultValue = sumValue = ((Double)((Number)sumValueMap.get(key1))).doubleValue();
                        if (computeTypeMap.containsKey(key1)) {
                            computeType = computeTypeMap.get(key1);
                        }
                        if (computeType == ComputeType.AVG) {
                            resultValue = CollectionCompute.preciseCompute(sumValue, endIndex - startIndex, "/");
                        }
                        CollectionCompute.invokeSetMethod(t, key1, resultValue, Class.forName(value.getClass().getName()));
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception e) {
                    log.error("[ " + value + " ] cant convert to Double");
                }
            }
        }
        return (T)t;
    }

    public static <T> T buildComputeRow(List<T> dataList, Class<T> clazz, ComputeType computeType) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        return CollectionCompute.buildComputeRow(0, dataList.size(), dataList, CollectionCompute.getObjectAttributeNames(clazz), clazz, computeType, new HashMap<String, ComputeType>());
    }

    private static <T> List<String> getObjectAttributeNames(Class<T> clazzT) {
        LinkedList<String> list = new LinkedList<String>();
        try {
            Field[] fields;
            Class<?> clazz = Class.forName(clazzT.getName());
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (f.getType() != Long.TYPE && f.getType() != Long.class && f.getType() != Double.TYPE && f.getType() != Double.class) continue;
                list.add(f.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static double preciseCompute(Number numA, Number numB, String operate) {
        double res = 0.0;
        BigDecimal bigA = new BigDecimal(String.valueOf(numA));
        BigDecimal bigB = new BigDecimal(String.valueOf(numB));
        switch (operate) {
            case "+": {
                res = bigA.add(bigB).doubleValue();
                break;
            }
            case "-": {
                res = bigA.subtract(bigB).doubleValue();
                break;
            }
            case "*": {
                res = bigA.multiply(bigB).doubleValue();
                break;
            }
            case "/": {
                res = bigA.divide(bigB, 2, RoundingMode.HALF_EVEN).doubleValue();
                break;
            }
            default: {
                System.out.println("\u8fd0\u7b97\u7b26\u4e0d\u5408\u6cd5~");
            }
        }
        return res;
    }

    private static <T> Object invokeGetMethod(T t, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String getGetMethodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method getMethod = t.getClass().getMethod(getGetMethodName, new Class[0]);
        return getMethod.invoke(t, new Object[0]);
    }

    private static <T> void invokeSetMethod(T t, String propertyName, Object setValue, Class setValueClazz) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String getGetMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        Method setMethod = t.getClass().getMethod(getGetMethodName, setValueClazz);
        setMethod.invoke(t, setValue);
    }
}

