/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.freakchicken.dbapi.plugin.impl;

import com.gitee.freakchicken.dbapi.common.ApiConfig;
import com.gitee.freakchicken.dbapi.plugin.AlarmPlugin;
import com.gitee.freakchicken.dbapi.plugin.PluginConf;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.mail.Authenticator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;

public class EmailAlarmPlugin
extends AlarmPlugin {
    private String username;
    private String password;
    private String host;

    @Override
    public void init() {
        this.username = PluginConf.getKey("EMAIL_USERNAME");
        this.password = PluginConf.getKey("EMAIL_PASSWORD");
        this.host = PluginConf.getKey("EMAIL_HOST");
    }

    @Override
    public void alarm(Exception e, ApiConfig config, HttpServletRequest request, String pluginParam) {
        String title = MessageFormat.format("API ERROR: {0}", config.getName());
        String content = MessageFormat.format("TIME:  {0}\n API_ID:  {5}\nNAME:  {1}\n URL:  {2}\n REMOTE ADDRESS:  {3}\n\n{4}", new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS").format(new Date()), config.getName(), request.getRequestURI(), request.getRemoteAddr(), e.toString(), config.getId());
        this.sendSimpleTextEmail(pluginParam, title, content);
    }

    public void sendSimpleTextEmail(String to, String title, String content) {
        try {
            SimpleEmail email = new SimpleEmail();
            email.setHostName(this.host);
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.username, this.password));
            email.setSSLOnConnect(true);
            email.setCharset("UTF-8");
            email.setFrom(this.username);
            email.addTo(to);
            email.setSubject(title);
            email.setMsg(content);
            email.send();
        }
        catch (EmailException e) {
            this.logger.info(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "\u90ae\u4ef6\u544a\u8b66\u63d2\u4ef6";
    }

    @Override
    public String getDescription() {
        return "\u4f7f\u7528\u8be5\u63d2\u4ef6\uff0c\u5f02\u5e38\u4fe1\u606f\u4f1a\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u3002\u4f7f\u7528\u524d\u9700\u8981\u5728plugin.properties\u914d\u7f6e\u5168\u5c40\u53c2\u6570\uff1a\u53d1\u4ef6\u4eba\u7684\u4fe1\u606f\u3002";
    }

    @Override
    public String getParamDescription() {
        return "\u63d2\u4ef6\u53c2\u6570\u8bf7\u586b\u5199\u6536\u4ef6\u4eba\u90ae\u7bb1\uff0c\u591a\u4e2a\u7528\u82f1\u6587\u5206\u53f7;\u9694\u5f00";
    }
}

