/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.freakchicken.dbapi.plugin;

import com.alibaba.fastjson.JSONObject;
import com.gitee.freakchicken.dbapi.plugin.AlarmPlugin;
import com.gitee.freakchicken.dbapi.plugin.BasePlugin;
import com.gitee.freakchicken.dbapi.plugin.CachePlugin;
import com.gitee.freakchicken.dbapi.plugin.GlobalTransformPlugin;
import com.gitee.freakchicken.dbapi.plugin.ParameterValidator;
import com.gitee.freakchicken.dbapi.plugin.TransformPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static Map<String, BasePlugin> cachePluginMap = new ConcurrentHashMap<String, BasePlugin>();
    private static Map<String, BasePlugin> transformPluginMap = new ConcurrentHashMap<String, BasePlugin>();
    private static Map<String, BasePlugin> globalTransformPluginMap = new ConcurrentHashMap<String, BasePlugin>();
    private static Map<String, BasePlugin> alarmPluginMap = new ConcurrentHashMap<String, BasePlugin>();
    private static Map<String, BasePlugin> parameterValidatorMap = new ConcurrentHashMap<String, BasePlugin>();
    private static List<JSONObject> allCachePlugins = new ArrayList<JSONObject>();
    private static List<JSONObject> allTransformPlugins = new ArrayList<JSONObject>();
    private static List<JSONObject> allGlobalTransformPlugins = new ArrayList<JSONObject>();
    private static List<JSONObject> allAlarmPlugins = new ArrayList<JSONObject>();
    private static List<JSONObject> allParameterValidators = new ArrayList<JSONObject>();

    public static void loadPlugins() {
        cachePluginMap.clear();
        transformPluginMap.clear();
        globalTransformPluginMap.clear();
        alarmPluginMap.clear();
        parameterValidatorMap.clear();
        allCachePlugins.clear();
        allTransformPlugins.clear();
        allGlobalTransformPlugins.clear();
        allAlarmPlugins.clear();
        allParameterValidators.clear();
        ServiceLoader<CachePlugin> serviceLoader = ServiceLoader.load(CachePlugin.class);
        for (CachePlugin plugin : serviceLoader) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            cachePluginMap.put(plugin.getClass().getName(), plugin);
        }
        allCachePlugins = PluginManager.getAllList(cachePluginMap);
        log.info("scan cache plugin finish");
        ServiceLoader<TransformPlugin> serviceLoader2 = ServiceLoader.load(TransformPlugin.class);
        for (TransformPlugin plugin : serviceLoader2) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            transformPluginMap.put(plugin.getClass().getName(), plugin);
        }
        allTransformPlugins = PluginManager.getAllList(transformPluginMap);
        log.info("scan transform plugin finish");
        ServiceLoader<AlarmPlugin> serviceLoader3 = ServiceLoader.load(AlarmPlugin.class);
        for (AlarmPlugin plugin : serviceLoader3) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            alarmPluginMap.put(plugin.getClass().getName(), plugin);
        }
        allAlarmPlugins = PluginManager.getAllList(alarmPluginMap);
        log.info("scan alarm plugin finish");
        ServiceLoader<GlobalTransformPlugin> serviceLoader4 = ServiceLoader.load(GlobalTransformPlugin.class);
        for (GlobalTransformPlugin plugin : serviceLoader4) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            globalTransformPluginMap.put(plugin.getClass().getName(), plugin);
        }
        allGlobalTransformPlugins = PluginManager.getAllList(globalTransformPluginMap);
        log.info("scan global transform plugin finish");
        ServiceLoader<ParameterValidator> serviceLoader5 = ServiceLoader.load(ParameterValidator.class);
        for (ParameterValidator plugin : serviceLoader5) {
            plugin.init();
            log.info("{} registered", (Object)plugin.getClass().getName());
            parameterValidatorMap.put(plugin.getClass().getName(), plugin);
        }
        allParameterValidators = PluginManager.getAllList(parameterValidatorMap);
        log.info("scan validator plugin finish");
    }

    public static CachePlugin getCachePlugin(String className) {
        if (!cachePluginMap.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return (CachePlugin)cachePluginMap.get(className);
    }

    public static TransformPlugin getTransformPlugin(String className) {
        if (!transformPluginMap.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return (TransformPlugin)transformPluginMap.get(className);
    }

    public static GlobalTransformPlugin getGlobalTransformPlugin(String className) {
        if (!globalTransformPluginMap.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return (GlobalTransformPlugin)globalTransformPluginMap.get(className);
    }

    public static AlarmPlugin getAlarmPlugin(String className) {
        if (!alarmPluginMap.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return (AlarmPlugin)alarmPluginMap.get(className);
    }

    public static ParameterValidator getParameterValidator(String className) {
        if (!parameterValidatorMap.containsKey(className)) {
            throw new RuntimeException("Plugin not found: " + className);
        }
        return (ParameterValidator)parameterValidatorMap.get(className);
    }

    private static List<JSONObject> getAllList(Map<String, BasePlugin> map) {
        List<JSONObject> collect = map.values().stream().map(t -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("className", (Object)t.getClass().getName());
            jsonObject.put("name", (Object)t.getName());
            jsonObject.put("description", (Object)t.getDescription());
            jsonObject.put("paramDescription", (Object)t.getParamDescription());
            return jsonObject;
        }).collect(Collectors.toList());
        return collect;
    }

    public static List<JSONObject> getAllCachePlugins() {
        return allCachePlugins;
    }

    public static List<JSONObject> getAllAlarmPlugins() {
        return allAlarmPlugins;
    }

    public static List<JSONObject> getAllTransformPlugins() {
        return allTransformPlugins;
    }

    public static List<JSONObject> getAllGlobalTransformPlugins() {
        return allGlobalTransformPlugins;
    }

    public static List<JSONObject> getAllParameterValidators() {
        return allParameterValidators;
    }
}

