/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.util;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.facade.AbstractModbusMaster;
import com.ghgande.j2mod.modbus.facade.ModbusSerialMaster;
import com.ghgande.j2mod.modbus.facade.ModbusTCPMaster;
import com.ghgande.j2mod.modbus.facade.ModbusUDPMaster;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.util.BitVector;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import java.util.HashSet;
import java.util.Set;

public class ModPoll {
    public static void main(String[] args) {
        try {
            CommandLineParams params = new CommandLineParams(args);
            if ("ascii".equalsIgnoreCase(params.mode) || "rtu".equalsIgnoreCase(params.mode)) {
                ModPoll.mainSerial(params);
            } else if ("tcp".equalsIgnoreCase(params.mode) || "enc".equalsIgnoreCase(params.mode)) {
                ModPoll.mainTCP(params);
            } else if ("udp".equalsIgnoreCase(params.mode)) {
                ModPoll.mainUDP(params);
            }
        }
        catch (ModbusException e) {
            System.out.println(e.getMessage());
            ModPoll.showHelp();
        }
    }

    private static void mainSerial(CommandLineParams params) {
        SerialParameters parameters = new SerialParameters();
        parameters.setPortName(params.portname);
        parameters.setOpenDelay(1000);
        parameters.setEncoding("ascii".equalsIgnoreCase(params.mode) ? "ascii" : "rtu");
        parameters.setStopbits(params.stopBits);
        parameters.setParity(params.parity);
        parameters.setBaudRate(params.baudRate);
        parameters.setDatabits(params.dataBits);
        parameters.setFlowControlOut(0);
        parameters.setFlowControlIn(0);
        parameters.setEcho(false);
        parameters.setOpenDelay(0);
        ModbusSerialMaster master = new ModbusSerialMaster(parameters);
        ModPoll.execute(params, master);
    }

    private static void mainTCP(CommandLineParams params) {
        ModbusTCPMaster master = new ModbusTCPMaster(params.portname, params.port, "enc".equalsIgnoreCase(params.mode));
        ModPoll.execute(params, master);
    }

    private static void mainUDP(CommandLineParams params) throws ModbusException {
        if (params.portname == null) {
            throw new ModbusException("ERROR - you must specify a host name or IP address");
        }
        ModbusUDPMaster master = new ModbusUDPMaster(params.portname, params.port);
        ModPoll.execute(params, master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void execute(CommandLineParams params, AbstractModbusMaster master) {
        boolean first = true;
        while (params.continuous || first) {
            long sleepTime;
            long startTime = System.currentTimeMillis();
            first = false;
            try {
                int cnt;
                master.connect();
                System.out.println("-- Polling slave... (Ctrl-C to stop)");
                if (params.type == 1) {
                    BitVector vector = master.readInputDiscretes(params.unit, params.reference, params.count);
                    System.out.println(vector.toString());
                } else if (params.type == 3) {
                    InputRegister[] regs = master.readInputRegisters(params.unit, params.reference, params.count);
                    cnt = 0;
                    for (InputRegister inputRegister : regs) {
                        System.out.printf("[%04d]: %s (%d)%n", params.reference + cnt, ModbusUtil.toHex(inputRegister.toBytes()), inputRegister.toUnsignedShort());
                        ++cnt;
                    }
                } else if (params.type == 4) {
                    Register[] regs = master.readMultipleRegisters(params.unit, params.reference, params.count);
                    cnt = 0;
                    for (InputRegister inputRegister : regs) {
                        System.out.printf("[%04d]: %s (%d)%n", params.reference + cnt, ModbusUtil.toHex(inputRegister.toBytes()), inputRegister.toUnsignedShort());
                        ++cnt;
                    }
                }
            }
            catch (Exception e) {
                System.out.printf("ERROR - %s%n", e.getMessage());
            }
            finally {
                master.disconnect();
            }
            if (!params.continuous || (sleepTime = (long)params.rate - (System.currentTimeMillis() - startTime)) <= 0L) continue;
            ModbusUtil.sleep(sleepTime);
        }
    }

    private static void showHelp() {
        System.out.println("Usage: modpoll [OPTIONS] SERIALPORT|HOST");
        System.out.println("Arguments:");
        System.out.println("SERIALPORT    Serial port when using Modbus ASCII or Modbus RTU protocol");
        System.out.println("              COM1, COM2 ...                on Windows");
        System.out.println("              /dev/ttyS0, /dev/ttyS1 ...    on Linux");
        System.out.println("HOST          Host name or dotted IP address when using MODBUS/TCP protocol");
        System.out.println();
        System.out.println("General options:");
        System.out.println("-m ascii      Modbus ASCII protocol");
        System.out.println("-m rtu        Modbus RTU protocol (default if SERIALPORT contains /, \\ or COM)");
        System.out.println("-m tcp        MODBUS/TCP protocol (default otherwise)");
        System.out.println("-m udp        MODBUS UDP");
        System.out.println("-m enc        Encapsulated Modbus RTU over TCP");
        System.out.println("-a #          Slave address (1-255 for serial, 0-255 for TCP, 1 is default)\n");
        System.out.println("-r #          Start reference (1-65536, 1 is default)");
        System.out.println("-c #          Number of values to poll (1-125, 1 is default)");
        System.out.println("-t 1          Discrete input data type");
        System.out.println("-t 3          16-bit input register data type");
        System.out.println("-t 3:hex      16-bit input register data type with hex display");
        System.out.println("-t 3:int      32-bit integer data type in input register table");
        System.out.println("-t 3:mod      32-bit module 10000 data type in input register table");
        System.out.println("-t 3:float    32-bit float data type in input register table");
        System.out.println("-t 4          16-bit output (holding) register data type (default)");
        System.out.println("-t 4:hex      16-bit output (holding) register data type with hex display");
        System.out.println("-t 4:int      32-bit integer data type in output (holding) register table");
        System.out.println("-t 4:mod      32-bit module 10000 type in output (holding) register table");
        System.out.println("-t 4:float    32-bit float data type in output (holding) register table");
        System.out.println("-i            Slave operates on big-endian 32-bit integers");
        System.out.println("-f            Slave operates on big-endian 32-bit floats");
        System.out.println("-1            Poll only once only, otherwise every poll rate interval");
        System.out.println("-l            Poll rate in ms, (1000 is default)");
        System.out.println("-o #          Time-out in seconds (0.01 - 10.0, 1.0 s is default)");
        System.out.println();
        System.out.println("Options for MODBUS/TCP, UDP and RTU over TCP:");
        System.out.println("-p #          IP protocol port number (502 is default)");
        System.out.println();
        System.out.println("Options for Modbus ASCII and Modbus RTU:");
        System.out.println("-b #          Baudrate (e.g. 9600, 19200, ...) (19200 is default)");
        System.out.println("-d #          Databits (7 or 8 for ASCII protocol, 8 for RTU)");
        System.out.println("-s #          Stopbits (1 or 2, 1 is default)");
        System.out.println("-p none       No parity");
        System.out.println("-p even       Even parity (default)");
        System.out.println("-p odd        Odd parity");
    }

    private static class CommandLineParams {
        static final String MODE_ASCII = "ascii";
        static final String MODE_RTU = "rtu";
        static final String MODE_TCP = "tcp";
        static final String MODE_UDP = "udp";
        static final String MODE_ENC = "enc";
        private static final Set<String> ACCEPTABLE_MODES = new HashSet<String>();
        private static final String ACCEPTABLE_MODES_DISPLAY;
        String portname = null;
        int parity = 0;
        int rate = 1000;
        int unit = -1;
        int reference = 0;
        int count = 1;
        int type = 3;
        int baudRate = 9600;
        int dataBits = 8;
        int stopBits = 1;
        int port = 502;
        boolean continuous = true;
        String mode = "tcp";
        String displayType = null;
        private String portOrParity;

        public CommandLineParams(String[] args) throws ModbusException {
            boolean isSerialMode;
            for (int arg = 0; arg < args.length; ++arg) {
                if (args[arg].equals("-m")) {
                    this.mode = args[++arg].toLowerCase();
                    continue;
                }
                if (args[arg].equals("-a")) {
                    this.unit = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-r")) {
                    this.reference = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-c")) {
                    this.count = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-t")) {
                    String tmp;
                    if ((tmp = args[++arg]).contains(":")) {
                        this.type = Integer.parseInt(tmp.split(" *: *")[0]);
                        if ((tmp = tmp.split(" *: *")[1]).isEmpty()) continue;
                        this.displayType = tmp;
                        continue;
                    }
                    this.type = Integer.parseInt(tmp);
                    continue;
                }
                if (args[arg].equals("-1")) {
                    this.continuous = false;
                    continue;
                }
                if (args[arg].equals("-l")) {
                    this.rate = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-b")) {
                    this.baudRate = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-d")) {
                    this.dataBits = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-s")) {
                    this.stopBits = Integer.parseInt(args[++arg]);
                    continue;
                }
                if (args[arg].equals("-p")) {
                    this.portOrParity = args[++arg];
                    continue;
                }
                this.portname = args[arg];
            }
            boolean bl = isSerialMode = MODE_ASCII.equalsIgnoreCase(this.mode) || MODE_RTU.equalsIgnoreCase(this.mode);
            if (isSerialMode) {
                if ("none".equalsIgnoreCase(this.portOrParity)) {
                    this.parity = 0;
                } else if ("even".equalsIgnoreCase(this.portOrParity)) {
                    this.parity = 2;
                } else if ("odd".equalsIgnoreCase(this.portOrParity)) {
                    this.parity = 1;
                }
            } else if (this.portOrParity != null) {
                this.port = Integer.parseInt(this.portOrParity);
            }
            if (this.portname == null) {
                if (isSerialMode) {
                    throw new ModbusException("ERROR - you must specify a port name");
                }
                throw new ModbusException("ERROR - you must specify a host name or IP address");
            }
            if (this.unit < 0 || this.unit > 255) {
                throw new ModbusException("ERROR - you must specify a valid unit ID (1-255) e.g. -a 49");
            }
            if (this.mode == null || !ACCEPTABLE_MODES.contains(this.mode)) {
                throw new ModbusException("ERROR - mode must be one of [%s]", ACCEPTABLE_MODES_DISPLAY);
            }
        }

        static {
            ACCEPTABLE_MODES.add(MODE_ASCII);
            ACCEPTABLE_MODES.add(MODE_RTU);
            ACCEPTABLE_MODES.add(MODE_TCP);
            ACCEPTABLE_MODES.add(MODE_UDP);
            ACCEPTABLE_MODES.add(MODE_ENC);
            ACCEPTABLE_MODES_DISPLAY = String.format("%s,%s,%s,%s,%s", MODE_ASCII, MODE_RTU, MODE_TCP, MODE_UDP, MODE_ENC);
        }
    }
}

