/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.common.http;

import com.getui.push.v2.sdk.GtHttpProxyConfig;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.Config;
import com.getui.push.v2.sdk.common.Monitor;
import com.getui.push.v2.sdk.common.http.GtHttpDelete;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.dto.CommonEnum;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GtHttpClient {
    private static Logger log = LoggerFactory.getLogger(GtHttpClient.class);
    private int maxHttpTryTime;
    CloseableHttpClient httpclient;
    volatile RequestConfig config;

    public GtHttpClient(int connectTimeout, int soTimeout, int connectionRequestTimeout, int maxHttpTryTime, long keepAliveSeconds, GtHttpProxyConfig proxyConfig, boolean trustSSL) {
        String maxConnPerRoute;
        if (connectTimeout <= 0) {
            throw new IllegalArgumentException("connectTimeout must be > 0.");
        }
        if (soTimeout <= 0) {
            throw new IllegalArgumentException("soTimeout must be > 0.");
        }
        this.maxHttpTryTime = maxHttpTryTime;
        HttpClientBuilder builder = HttpClients.custom();
        builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        if (proxyConfig != null && Utils.isNotEmpty(proxyConfig.getHost())) {
            if (Utils.isNotEmpty(proxyConfig.getUsername())) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyConfig.getHost(), proxyConfig.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfig.getUsername(), proxyConfig.getPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            builder.setProxy(new HttpHost(proxyConfig.getHost(), proxyConfig.getPort()));
        }
        if (System.getProperty("java.version").startsWith("1.6") || trustSSL) {
            builder.setSSLContext(GtHttpClient.createSSLContext());
        }
        this.config = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(soTimeout).setConnectionRequestTimeout(connectionRequestTimeout).setMaxRedirects(0).build();
        builder.setDefaultRequestConfig(this.config).setConnectionTimeToLive(keepAliveSeconds, TimeUnit.SECONDS).useSystemProperties();
        String maxConnTotal = System.getProperty("http.client.maxConnTotal");
        if (!StringUtils.isEmpty((Object)maxConnTotal)) {
            builder.setMaxConnTotal(Integer.parseInt(maxConnTotal));
        }
        if (!StringUtils.isEmpty((Object)(maxConnPerRoute = System.getProperty("http.client.maxConnPerRoute")))) {
            builder.setMaxConnPerRoute(Integer.parseInt(maxConnPerRoute));
        }
        this.httpclient = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String url, List<String> rasDomain, int socketTimeout, String method, Map<String, Object> headers, String body, String contentType) {
        int retryTimes = 0;
        String currUrl = url;
        while (true) {
            String string;
            if (retryTimes > 0) {
                currUrl = GtHttpClient.modifyUrl(rasDomain, currUrl, retryTimes);
            }
            long start = System.currentTimeMillis();
            String logResult = null;
            try {
                string = logResult = this.doExecute(currUrl, socketTimeout, method, headers, body, contentType);
            }
            catch (ApiException e) {
                try {
                    Monitor.incrementFailedNum(currUrl);
                    if (e.getCode() == 404) {
                        logResult = e.toString();
                        throw e;
                    }
                    if (retryTimes >= this.maxHttpTryTime) {
                        logResult = e.toString();
                        throw e;
                    }
                    logResult = "will retry, ex: " + e.getMessage();
                }
                catch (Throwable throwable) {
                    log.debug("http log|retry:{}|time:{}|{}|{}|{}|{}", new Object[]{retryTimes, System.currentTimeMillis() - start, currUrl, headers, body, logResult});
                    ++retryTimes;
                    throw throwable;
                }
                log.debug("http log|retry:{}|time:{}|{}|{}|{}|{}", new Object[]{retryTimes, System.currentTimeMillis() - start, currUrl, headers, body, logResult});
                ++retryTimes;
                continue;
            }
            log.debug("http log|retry:{}|time:{}|{}|{}|{}|{}", new Object[]{retryTimes, System.currentTimeMillis() - start, currUrl, headers, body, logResult});
            ++retryTimes;
            return string;
            break;
        }
    }

    static String modifyUrl(List<String> rasDomain, String url, int retryTimes) {
        if (Utils.isEmpty(rasDomain)) {
            return url;
        }
        if (rasDomain.size() == 1) {
            String host = rasDomain.get(0);
            return GtHttpClient.replaceHost(url, host);
        }
        if (retryTimes < 1) {
            retryTimes = 1;
        }
        int sameHostNum = 0;
        int size = rasDomain.size();
        int i = retryTimes - 1;
        while (true) {
            String host;
            if (i >= size) {
                i = retryTimes % size;
            }
            if (!url.startsWith(host = rasDomain.get(i)) || sameHostNum++ >= 2) {
                return GtHttpClient.replaceHost(url, host);
            }
            ++i;
        }
    }

    static String replaceHost(String url, String host) {
        if (url.startsWith(host)) {
            return url;
        }
        int v2Index = url.indexOf("/v2/");
        if (host.endsWith("/v2/")) {
            return host + url.substring(v2Index + 4);
        }
        if (host.endsWith("/v2")) {
            return host + url.substring(v2Index + 3);
        }
        if (host.endsWith("/")) {
            return host + url.substring(v2Index + 1);
        }
        return host + url.substring(v2Index);
    }

    public String doExecute(String url, int socketTimeout, String method, Map<String, Object> headers, String body, String contentType) {
        HttpRequestBase request = this.genHttpUriRequest(url, method);
        if (socketTimeout > 0) {
            RequestConfig config = RequestConfig.copy((RequestConfig)this.config).setSocketTimeout(socketTimeout).build();
            request.setConfig(config);
        }
        if (Utils.isNotEmpty(headers)) {
            for (Map.Entry entry : headers.entrySet()) {
                request.addHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        if (Utils.isNotEmpty(body) && request instanceof HttpEntityEnclosingRequestBase) {
            StringEntity entity;
            if (Utils.isEmpty(contentType)) {
                try {
                    entity = new StringEntity(body);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ApiException("\u8bbe\u7f6ebody\u5931\u8d25:" + unsupportedEncodingException.getMessage(), 5000, unsupportedEncodingException);
                }
            } else {
                entity = new StringEntity(body, ContentType.create((String)contentType, (Charset)Config.UTF_8));
            }
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
        return this.doRequest((HttpUriRequest)request);
    }

    public static SSLContext createSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new ApiException("create httpClient error.", e);
        }
    }

    private String doRequest(HttpUriRequest request) {
        CloseableHttpResponse response = null;
        int code = 5000;
        try {
            response = this.httpclient.execute(request);
            StatusLine statusLine = response.getStatusLine();
            code = statusLine.getStatusCode();
            String responseBody = "";
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
            if (code == 200 || code == 400 || code == 401 || code == 403) {
                String string = responseBody;
                return string;
            }
            try {
                if (code == 404) {
                    throw new ApiException("not found.", code);
                }
                if (code >= 500) {
                    throw new ApiException("http error", code);
                }
                throw new ApiException("Http Response Error.", code);
            }
            catch (ApiException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ApiException("http error:" + e.getMessage(), code, e);
            }
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private HttpRequestBase genHttpUriRequest(String url, String method) {
        Object request;
        if (CommonEnum.MethodEnum.METHOD_GET.is(method)) {
            request = new HttpGet(url);
        } else if (CommonEnum.MethodEnum.METHOD_POST.is(method)) {
            request = new HttpPost(url);
        } else if (CommonEnum.MethodEnum.METHOD_DELETE.is(method)) {
            request = new GtHttpDelete(url);
        } else if (CommonEnum.MethodEnum.METHOD_PUT.is(method)) {
            request = new HttpPut(url);
        } else if (CommonEnum.MethodEnum.METHOD_HEAD.is(method)) {
            request = new HttpHead(url);
        } else if (CommonEnum.MethodEnum.METHOD_PATCH.is(method)) {
            request = new HttpPatch(url);
        } else if (CommonEnum.MethodEnum.METHOD_OPTIONS.is(method)) {
            request = new HttpOptions(url);
        } else if (CommonEnum.MethodEnum.METHOD_TRACE.is(method)) {
            request = new HttpTrace(url);
        } else {
            throw new ApiException("\u6682\u65f6\u4e0d\u652f\u6301" + method + "\u65b9\u6cd5");
        }
        return request;
    }
}

