/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONPath;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.conversion.Conversion;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.geccocrawler.gecco.spider.render.Render;
import com.geccocrawler.gecco.spider.render.RenderContext;
import com.geccocrawler.gecco.spider.render.RenderException;
import com.geccocrawler.gecco.spider.render.RenderType;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.reflections.ReflectionUtils;

public class JsonFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) throws FieldRenderException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set jsonPathFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(com.geccocrawler.gecco.annotation.JSONPath.class)});
        Object json = JSON.parse((String)response.getContent());
        for (Field field : jsonPathFields) {
            try {
                Object value = this.injectJsonField(request, field, json);
                fieldMap.put(field.getName(), value);
            }
            catch (Exception ex) {
                throw new FieldRenderException(field, ex.getMessage(), ex);
            }
        }
        beanMap.putAll(fieldMap);
    }

    private Object injectJsonField(HttpRequest request, Field field, Object json) throws RenderException, FieldRenderException {
        com.geccocrawler.gecco.annotation.JSONPath JSONPath2 = field.getAnnotation(com.geccocrawler.gecco.annotation.JSONPath.class);
        String jsonPath = JSONPath2.value();
        Class<?> type = field.getType();
        Object src = JSONPath.eval((Object)json, (String)jsonPath);
        boolean isList = ReflectUtils.haveSuperType(type, List.class);
        if (isList) {
            Type genericType = field.getGenericType();
            Class genericClass = ReflectUtils.getGenericClass(genericType, 0);
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                return this.spiderBeanRender(src, genericClass, request);
            }
            return this.objectRender(src, field, jsonPath, json);
        }
        return this.objectRender(src, field, jsonPath, json);
    }

    private List<SpiderBean> spiderBeanRender(Object src, Class genericClass, HttpRequest request) throws RenderException {
        ArrayList<SpiderBean> list = new ArrayList<SpiderBean>();
        JSONArray ja = (JSONArray)src;
        for (Object jo : ja) {
            HttpResponse subResponse = HttpResponse.createSimple(jo.toString());
            Render render = RenderContext.getRender(RenderType.JSON);
            SpiderBean subBean = render.inject(genericClass, request, subResponse);
            list.add(subBean);
        }
        return list;
    }

    private Object objectRender(Object src, Field field, String jsonPath, Object json) throws FieldRenderException {
        if (src == null) {
            throw new FieldRenderException(field, jsonPath + " not found in : " + json);
        }
        try {
            return Conversion.getValue(field.getType(), src);
        }
        catch (Exception ex) {
            throw new FieldRenderException(field, "Conversion error : " + src, ex);
        }
    }
}

