/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render;

import com.geccocrawler.gecco.annotation.RequestParameter;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.conversion.Conversion;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

public class RequestParameterFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) throws FieldRenderException {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set requestParameterFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(RequestParameter.class)});
        for (Field field : requestParameterFields) {
            RequestParameter requestParameter = field.getAnnotation(RequestParameter.class);
            String key = requestParameter.value();
            if (StringUtils.isEmpty((CharSequence)key)) {
                key = field.getName();
            }
            String src = request.getParameter(key);
            try {
                Object value = Conversion.getValue(field.getType(), src);
                fieldMap.put(field.getName(), value);
            }
            catch (Exception ex) {
                throw new FieldRenderException(field, src, ex);
            }
        }
        beanMap.putAll(fieldMap);
    }
}

