/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render;

import com.geccocrawler.gecco.spider.render.CustomFieldRenderFactory;
import com.geccocrawler.gecco.spider.render.Render;
import com.geccocrawler.gecco.spider.render.RenderType;
import com.geccocrawler.gecco.spider.render.html.HtmlRender;
import com.geccocrawler.gecco.spider.render.json.JsonRender;
import java.util.HashMap;
import java.util.Map;
import org.reflections.Reflections;

public abstract class RenderFactory {
    private Map<RenderType, Render> renders;

    public RenderFactory(Reflections reflections) {
        CustomFieldRenderFactory customFieldRenderFactory = new CustomFieldRenderFactory(reflections);
        this.renders = new HashMap<RenderType, Render>();
        HtmlRender htmlRender = this.createHtmlRender();
        htmlRender.setCustomFieldRenderFactory(customFieldRenderFactory);
        JsonRender jsonRender = this.createJsonRender();
        jsonRender.setCustomFieldRenderFactory(customFieldRenderFactory);
        this.renders.put(RenderType.HTML, htmlRender);
        this.renders.put(RenderType.JSON, jsonRender);
    }

    public Render getRender(RenderType type) {
        return this.renders.get((Object)type);
    }

    public abstract HtmlRender createHtmlRender();

    public abstract JsonRender createJsonRender();
}

