/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider;

import com.geccocrawler.gecco.annotation.Gecco;
import com.geccocrawler.gecco.downloader.DownloaderAOPFactory;
import com.geccocrawler.gecco.downloader.DownloaderFactory;
import com.geccocrawler.gecco.downloader.MonitorDownloaderFactory;
import com.geccocrawler.gecco.pipeline.DefaultPipelineFactory;
import com.geccocrawler.gecco.pipeline.Pipeline;
import com.geccocrawler.gecco.pipeline.PipelineFactory;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.spider.JsonBean;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.SpiderBeanContext;
import com.geccocrawler.gecco.spider.render.MonitorRenderFactory;
import com.geccocrawler.gecco.spider.render.RenderFactory;
import com.geccocrawler.gecco.spider.render.RenderType;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.geccocrawler.gecco.utils.UrlMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SpiderBeanFactory {
    private Map<String, Class<? extends SpiderBean>> spiderBeans;
    private Map<String, SpiderBeanContext> spiderBeanContexts;
    private DownloaderFactory downloaderFactory;
    private DownloaderAOPFactory downloaderAOPFactory;
    private RenderFactory renderFactory;
    private PipelineFactory pipelineFactory;
    private Reflections reflections;

    public SpiderBeanFactory(String classPath) {
        this(classPath, null);
    }

    public SpiderBeanFactory(String classPath, PipelineFactory pipelineFactory) {
        this.reflections = StringUtils.isNotEmpty((CharSequence)classPath) ? new Reflections(new Object[]{"com.geccocrawler.gecco", classPath}) : new Reflections("com.geccocrawler.gecco", new Scanner[0]);
        this.downloaderFactory = new MonitorDownloaderFactory(this.reflections);
        this.downloaderAOPFactory = new DownloaderAOPFactory(this.reflections);
        this.renderFactory = new MonitorRenderFactory(this.reflections);
        this.pipelineFactory = pipelineFactory != null ? pipelineFactory : new DefaultPipelineFactory(this.reflections);
        this.spiderBeans = new HashMap<String, Class<? extends SpiderBean>>();
        this.spiderBeanContexts = new HashMap<String, SpiderBeanContext>();
        this.loadSpiderBean(this.reflections);
    }

    private void loadSpiderBean(Reflections reflections) {
        Set spiderBeanClasses = reflections.getTypesAnnotatedWith(Gecco.class);
        for (Class spiderBeanClass : spiderBeanClasses) {
            Gecco gecco = spiderBeanClass.getAnnotation(Gecco.class);
            String matchUrl = gecco.matchUrl();
            try {
                this.spiderBeans.put(matchUrl, spiderBeanClass);
                SpiderBeanContext context = this.initContext(spiderBeanClass);
                this.spiderBeanContexts.put(spiderBeanClass.getName(), context);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Class<? extends SpiderBean> matchSpider(HttpRequest request) {
        String url = request.getUrl();
        for (Map.Entry<String, Class<? extends SpiderBean>> entrys : this.spiderBeans.entrySet()) {
            String urlPattern = entrys.getKey();
            Map<String, String> params = UrlMatcher.match(url, urlPattern);
            if (params == null) continue;
            request.setParameters(params);
            Class<? extends SpiderBean> spider = entrys.getValue();
            return spider;
        }
        return null;
    }

    public SpiderBeanContext getContext(Class<? extends SpiderBean> spider) {
        return this.spiderBeanContexts.get(spider.getName());
    }

    private SpiderBeanContext initContext(Class<?> spiderBeanClass) {
        SpiderBeanContext context = new SpiderBeanContext();
        this.downloadContext(context, spiderBeanClass);
        this.renderContext(context, spiderBeanClass);
        Gecco gecco = spiderBeanClass.getAnnotation(Gecco.class);
        String[] pipelineNames = gecco.pipelines();
        this.pipelineContext(context, pipelineNames);
        return context;
    }

    private void downloadContext(SpiderBeanContext context, Class<?> spiderBeanClass) {
        String geccoName = spiderBeanClass.getName();
        context.setBeforeDownload(this.downloaderAOPFactory.getBefore(geccoName));
        context.setAfterDownload(this.downloaderAOPFactory.getAfter(geccoName));
        Gecco gecco = spiderBeanClass.getAnnotation(Gecco.class);
        String downloader = gecco.downloader();
        context.setDownloader(this.downloaderFactory.getDownloader(downloader));
        context.setTimeout(gecco.timeout());
    }

    private void renderContext(SpiderBeanContext context, Class<?> spiderBeanClass) {
        RenderType renderType = RenderType.HTML;
        if (ReflectUtils.haveSuperType(spiderBeanClass, JsonBean.class)) {
            renderType = RenderType.JSON;
        }
        context.setRender(this.renderFactory.getRender(renderType));
    }

    private void pipelineContext(SpiderBeanContext context, String[] pipelineNames) {
        if (pipelineNames != null && pipelineNames.length > 0) {
            ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
            for (String pipelineName : pipelineNames) {
                Pipeline<? extends SpiderBean> pipeline;
                if (StringUtils.isEmpty((CharSequence)pipelineName) || (pipeline = this.pipelineFactory.getPipeline(pipelineName)) == null) continue;
                pipelines.add(pipeline);
            }
            context.setPipelines(pipelines);
        }
    }

    public DownloaderAOPFactory getDownloaderAOPFactory() {
        return this.downloaderAOPFactory;
    }

    public RenderFactory getRenderFactory() {
        return this.renderFactory;
    }

    public PipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public DownloaderFactory getDownloaderFactory() {
        return this.downloaderFactory;
    }

    public Reflections getReflections() {
        return this.reflections;
    }
}

