/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider;

import com.geccocrawler.gecco.GeccoEngine;
import com.geccocrawler.gecco.downloader.AfterDownload;
import com.geccocrawler.gecco.downloader.BeforeDownload;
import com.geccocrawler.gecco.downloader.DownloadException;
import com.geccocrawler.gecco.downloader.Downloader;
import com.geccocrawler.gecco.pipeline.Pipeline;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.scheduler.Scheduler;
import com.geccocrawler.gecco.scheduler.SpiderScheduler;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.SpiderBeanContext;
import com.geccocrawler.gecco.spider.SpiderThreadLocal;
import com.geccocrawler.gecco.spider.render.Render;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Spider
implements Runnable {
    private static Log log = LogFactory.getLog(Spider.class);
    public GeccoEngine engine;
    public Scheduler spiderScheduler;
    public Class<? extends SpiderBean> currSpiderBeanClass;

    public Spider(GeccoEngine engine) {
        this.engine = engine;
        this.spiderScheduler = new SpiderScheduler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SpiderThreadLocal.set(this);
        while (true) {
            boolean start = false;
            HttpRequest request = this.spiderScheduler.out();
            if (request == null) {
                request = this.engine.getScheduler().out();
                if (request == null) break;
                start = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("match url : " + request.getUrl()));
            }
            this.currSpiderBeanClass = this.engine.getSpiderBeanFactory().matchSpider(request);
            try (HttpResponse response = null;){
                if (this.currSpiderBeanClass == null) {
                    response = this.defaultDownload(request);
                    if (response.getStatus() == 302 || response.getStatus() == 301) {
                        this.spiderScheduler.into(request.subRequest(response.getContent()));
                    } else {
                        log.error((Object)("cant't match url : " + request.getUrl()));
                    }
                } else {
                    SpiderBeanContext context = this.getSpiderBeanContext();
                    response = this.download(context, request);
                    if (response.getStatus() == 200) {
                        Render render = context.getRender();
                        SpiderBean spiderBean = render.inject(this.currSpiderBeanClass, request, response);
                        this.pipelines(spiderBean, context);
                    } else if (response.getStatus() == 302 || response.getStatus() == 301) {
                        this.spiderScheduler.into(request.subRequest(response.getContent()));
                    }
                }
            }
            this.interval();
            if (!start || !this.engine.isLoop()) continue;
            this.engine.getScheduler().into(request);
        }
        this.engine.notifyComplemet();
    }

    private void pipelines(SpiderBean spiderBean, SpiderBeanContext context) {
        List<Pipeline> pipelines = context.getPipelines();
        if (pipelines != null) {
            for (Pipeline pipeline : pipelines) {
                pipeline.process(spiderBean);
            }
        }
    }

    private void interval() {
        int interval = this.engine.getInterval();
        if (interval > 0) {
            try {
                Thread.sleep(this.randomInterval(interval));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private HttpResponse defaultDownload(HttpRequest request) throws DownloadException {
        HttpResponse response = this.download(null, request);
        return response;
    }

    private HttpResponse download(SpiderBeanContext context, HttpRequest request) throws DownloadException {
        Downloader currDownloader = null;
        BeforeDownload before = null;
        AfterDownload after = null;
        int timeout = 1000;
        if (context != null) {
            currDownloader = context.getDownloader();
            before = context.getBeforeDownload();
            after = context.getAfterDownload();
            timeout = context.getTimeout();
        } else {
            currDownloader = this.engine.getSpiderBeanFactory().getDownloaderFactory().defaultDownloader();
        }
        if (before != null) {
            before.process(request);
        }
        HttpResponse response = currDownloader.download(request, timeout);
        if (after != null) {
            after.process(request, response);
        }
        return response;
    }

    private int randomInterval(int interval) {
        int min = interval - 1000;
        if (min < 1) {
            min = 1;
        }
        int max = interval + 1000;
        return (int)Math.rint(Math.random() * (double)(max - min) + (double)min);
    }

    public GeccoEngine getEngine() {
        return this.engine;
    }

    public Scheduler getSpiderScheduler() {
        return this.spiderScheduler;
    }

    public void setSpiderScheduler(Scheduler spiderScheduler) {
        this.spiderScheduler = spiderScheduler;
    }

    public SpiderBeanContext getSpiderBeanContext() {
        return this.engine.getSpiderBeanFactory().getContext(this.currSpiderBeanClass);
    }
}

