/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.request;

import com.alibaba.fastjson.JSON;
import com.geccocrawler.gecco.request.HttpRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractHttpRequest
implements HttpRequest,
Comparable<HttpRequest>,
Serializable {
    private static final long serialVersionUID = -7284636094595149962L;
    private String url;
    private String charset;
    private Map<String, String> parameters = new HashMap<String, String>(1);
    private Map<String, String> cookies;
    private Map<String, String> headers = new HashMap<String, String>(1);
    private int priority;

    public AbstractHttpRequest() {
        this.cookies = new HashMap<String, String>(1);
    }

    public AbstractHttpRequest(String url) {
        this();
        this.setUrl(url);
    }

    @Override
    public void clearHeader() {
        Iterator<Map.Entry<String, String>> it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public void clearCookie() {
        Iterator<Map.Entry<String, String>> it = this.cookies.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    @Override
    public void addCookie(String name, String value) {
        this.cookies.put(name, value);
    }

    @Override
    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters.putAll(parameters);
    }

    @Override
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public HttpRequest subRequest(String url) {
        try {
            HttpRequest request = (HttpRequest)this.clone();
            request.setUrl(url);
            request.refer(this.getUrl());
            return request;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, String> getHeaders() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
        }
        this.headers.put("Cookie", sb.toString());
        return this.headers;
    }

    @Override
    public void refer(String refer) {
        this.addHeader("Referer", refer);
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int prio) {
        this.priority = prio;
    }

    @Override
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public void setUrl(String url) {
        this.url = StringUtils.substringBefore((String)url, (String)"#");
    }

    @Override
    public int compareTo(HttpRequest o) {
        return this.priority > o.getPriority() ? 1 : (this.priority < o.getPriority() ? -1 : 0);
    }

    protected Object clone() throws CloneNotSupportedException {
        String text = JSON.toJSONString((Object)this);
        HttpRequest request = (HttpRequest)JSON.parseObject((String)text, this.getClass());
        return request;
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", "2");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        System.out.println(map);
    }
}

