/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.pipeline;

import com.geccocrawler.gecco.annotation.PipelineName;
import com.geccocrawler.gecco.pipeline.Pipeline;
import com.geccocrawler.gecco.pipeline.PipelineFactory;
import com.geccocrawler.gecco.spider.SpiderBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public class DefaultPipelineFactory
implements PipelineFactory {
    private Map<String, Pipeline<? extends SpiderBean>> pipelines = new HashMap<String, Pipeline<? extends SpiderBean>>();

    public DefaultPipelineFactory(Reflections reflections) {
        Set pipelineClasses = reflections.getTypesAnnotatedWith(PipelineName.class);
        for (Class pipelineClass : pipelineClasses) {
            PipelineName spiderFilter = pipelineClass.getAnnotation(PipelineName.class);
            try {
                this.pipelines.put(spiderFilter.value(), (Pipeline)pipelineClass.newInstance());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Pipeline<? extends SpiderBean> getPipeline(String name) {
        return this.pipelines.get(name);
    }
}

