/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.downloader.Proxy;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;

public class Proxys {
    private static Log log = LogFactory.getLog(Proxys.class);
    private static ConcurrentLinkedQueue<Proxy> proxyQueue;
    private static Map<String, Proxy> proxys;

    public static HttpHost getProxy() {
        if (proxys == null || proxys.size() == 0) {
            return null;
        }
        Proxy proxy = proxyQueue.poll();
        log.debug((Object)("use proxy : " + proxy));
        if (proxy == null) {
            return null;
        }
        return proxy.getHttpHost();
    }

    public static void addProxy(String host, int port) {
        Proxy proxy = new Proxy(host, port);
        proxys.put(proxy.toHostString(), proxy);
        proxyQueue.offer(proxy);
    }

    public static void failure(String host) {
        Proxy proxy = proxys.get(host);
        if (proxy != null) {
            long failure = proxy.getFailureCount().incrementAndGet();
            long success = proxy.getSuccessCount().get();
            Proxys.reProxy(proxy, success, failure);
        }
    }

    public static void success(String host) {
        Proxy proxy = proxys.get(host);
        if (proxy != null) {
            long success = proxy.getSuccessCount().incrementAndGet();
            long failure = proxy.getFailureCount().get();
            Proxys.reProxy(proxy, success, failure);
        }
    }

    private static void reProxy(Proxy proxy, long success, long failure) {
        long sum = failure + success;
        if (sum < 10L) {
            proxyQueue.offer(proxy);
        } else if ((float)success / (float)sum >= 0.5f) {
            proxyQueue.offer(proxy);
        }
    }

    static {
        proxys = null;
        try {
            URL url = Resources.getResource((String)"proxys");
            File file = new File(url.getPath());
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            if (lines.size() > 0) {
                proxys = new ConcurrentHashMap<String, Proxy>(lines.size());
                proxyQueue = new ConcurrentLinkedQueue();
                for (String line : lines) {
                    String[] hostPort;
                    if ((line = line.trim()).startsWith("#") || (hostPort = line.split(":")).length != 2) continue;
                    String host = hostPort[0];
                    int port = NumberUtils.toInt((String)hostPort[1], (int)80);
                    Proxy proxy = new Proxy(host, port);
                    proxys.put(proxy.toHostString(), proxy);
                    proxyQueue.offer(proxy);
                }
            }
        }
        catch (Exception ex) {
            log.info((Object)"proxys not load");
        }
    }
}

