/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.annotation.Downloader;
import com.geccocrawler.gecco.downloader.AbstractDownloader;
import com.geccocrawler.gecco.downloader.DownloadException;
import com.geccocrawler.gecco.downloader.DownloadServerException;
import com.geccocrawler.gecco.downloader.Proxys;
import com.geccocrawler.gecco.downloader.UserAgent;
import com.geccocrawler.gecco.request.HttpPostRequest;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderThreadLocal;
import com.geccocrawler.gecco.utils.UrlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.CharArrayBuffer;

@Downloader(value="httpClientDownloader")
public class HttpClientDownloader
extends AbstractDownloader {
    private static Log log = LogFactory.getLog(HttpClientDownloader.class);
    private CloseableHttpClient httpClient;

    public HttpClientDownloader() {
        Registry socketFactoryRegistry = null;
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
            socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
        }
        catch (Exception ex) {
            socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        }
        RequestConfig clientConfig = RequestConfig.custom().setRedirectsEnabled(false).build();
        PoolingHttpClientConnectionManager syncConnectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        syncConnectionManager.setMaxTotal(1000);
        syncConnectionManager.setDefaultMaxPerRoute(50);
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(clientConfig).setConnectionManager((HttpClientConnectionManager)syncConnectionManager).build();
    }

    @Override
    public HttpResponse download(HttpRequest request, int timeout) throws DownloadException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("downloading..." + request.getUrl()));
        }
        HttpGet reqObj = null;
        if (request instanceof HttpPostRequest) {
            HttpPostRequest post = (HttpPostRequest)request;
            reqObj = new HttpPost(post.getUrl());
            ArrayList<BasicNameValuePair> fields = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : post.getFields().entrySet()) {
                BasicNameValuePair nvp = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                fields.add(nvp);
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(fields, "UTF-8");
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        } else {
            reqObj = new HttpGet(request.getUrl());
        }
        boolean isMobile = SpiderThreadLocal.get().getEngine().isMobile();
        reqObj.addHeader("User-Agent", UserAgent.getUserAgent(isMobile));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            reqObj.addHeader(entry.getKey(), entry.getValue());
        }
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).setConnectionRequestTimeout(timeout).setRedirectsEnabled(false);
        HttpHost proxy = Proxys.getProxy();
        if (proxy != null) {
            builder.setProxy(proxy);
        }
        reqObj.setConfig(builder.build());
        try {
            HttpClientContext context = HttpClientContext.create();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)reqObj, (HttpContext)context);
            int status = response.getStatusLine().getStatusCode();
            HttpResponse resp = new HttpResponse();
            resp.setStatus(status);
            if (status == 302 || status == 301) {
                String redirectUrl = response.getFirstHeader("Location").getValue();
                resp.setContent(UrlUtils.relative2Absolute(request.getUrl(), redirectUrl));
            } else if (status == 200) {
                HttpEntity responseEntity = response.getEntity();
                resp.setRaw(responseEntity.getContent());
                String contentType = responseEntity.getContentType().getValue();
                resp.setContentType(contentType);
                String charset = this.getCharset(request.getCharset(), contentType);
                resp.setCharset(charset);
                String content = this.getContent(responseEntity, charset);
                resp.setContent(content);
            } else {
                if (proxy != null) {
                    Proxys.failure(proxy.toHostString());
                }
                throw new DownloadServerException("" + status);
            }
            if (proxy != null) {
                Proxys.success(proxy.toHostString());
            }
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
        catch (IOException e) {
            if (proxy != null) {
                Proxys.failure(proxy.toHostString());
            }
            throw new DownloadException(e);
        }
        finally {
            reqObj.releaseConnection();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            this.httpClient = null;
        }
    }

    public String getContent(HttpEntity entity, String charset) throws IOException {
        int l;
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        int i = (int)entity.getContentLength();
        if (i < 0) {
            i = 4096;
        }
        InputStreamReader reader = new InputStreamReader(instream, charset);
        CharArrayBuffer buffer = new CharArrayBuffer(i);
        char[] tmp = new char[1024];
        while ((l = reader.read(tmp)) != -1) {
            buffer.append(tmp, 0, l);
        }
        return buffer.toString();
    }
}

