/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.downloader.Downloader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public abstract class DownloaderFactory {
    public static final String DEFAULT_DWONLODER = "httpClientDownloader";
    private Map<String, Downloader> downloaders = new HashMap<String, Downloader>();

    public DownloaderFactory(Reflections reflections) {
        Set classes = reflections.getTypesAnnotatedWith(com.geccocrawler.gecco.annotation.Downloader.class);
        for (Class downloaderClass : classes) {
            com.geccocrawler.gecco.annotation.Downloader downloader = downloaderClass.getAnnotation(com.geccocrawler.gecco.annotation.Downloader.class);
            try {
                Object o = this.createDownloader(downloaderClass);
                if (!(o instanceof Downloader)) continue;
                Downloader downloaderInstance = (Downloader)o;
                String name = downloader.value();
                this.downloaders.put(name, downloaderInstance);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public Downloader getDownloader(String name) {
        Downloader downloader = this.downloaders.get(name);
        if (downloader == null) {
            return this.defaultDownloader();
        }
        return downloader;
    }

    public Downloader defaultDownloader() {
        return this.downloaders.get(DEFAULT_DWONLODER);
    }

    protected abstract Object createDownloader(Class<?> var1) throws Exception;

    public void closeAll() {
        for (Downloader downloader : this.downloaders.values()) {
            downloader.shutdown();
        }
    }
}

