/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.annotation.GeccoClass;
import com.geccocrawler.gecco.downloader.AfterDownload;
import com.geccocrawler.gecco.downloader.BeforeDownload;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public class DownloaderAOPFactory {
    private Map<String, BeforeDownload> beforeDownloads = new HashMap<String, BeforeDownload>();
    private Map<String, AfterDownload> afterDownloads = new HashMap<String, AfterDownload>();

    public DownloaderAOPFactory(Reflections reflections) {
        Set classes = reflections.getTypesAnnotatedWith(GeccoClass.class);
        for (Class aopClass : classes) {
            GeccoClass geccoClass = aopClass.getAnnotation(GeccoClass.class);
            try {
                String name = geccoClass.value().getName();
                Object o = aopClass.newInstance();
                if (o instanceof BeforeDownload) {
                    this.beforeDownloads.put(name, (BeforeDownload)o);
                    continue;
                }
                if (!(o instanceof AfterDownload)) continue;
                this.afterDownloads.put(name, (AfterDownload)o);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public BeforeDownload getBefore(String spiderName) {
        return this.beforeDownloads.get(spiderName);
    }

    public AfterDownload getAfter(String spiderName) {
        return this.afterDownloads.get(spiderName);
    }
}

