/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.downloader.Downloader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractDownloader
implements Downloader {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    protected String getCharset(String requestCharset, String contentType) {
        String charset = this.getCharsetFromContentType(contentType);
        if (charset == null) {
            charset = requestCharset;
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        return charset;
    }
}

