/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco;

import com.alibaba.fastjson.JSON;
import com.geccocrawler.gecco.monitor.GeccoJmx;
import com.geccocrawler.gecco.monitor.GeccoMonitor;
import com.geccocrawler.gecco.pipeline.PipelineFactory;
import com.geccocrawler.gecco.request.HttpGetRequest;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.request.StartRequestList;
import com.geccocrawler.gecco.scheduler.NoLoopStartScheduler;
import com.geccocrawler.gecco.scheduler.Scheduler;
import com.geccocrawler.gecco.scheduler.StartScheduler;
import com.geccocrawler.gecco.spider.Spider;
import com.geccocrawler.gecco.spider.SpiderBeanFactory;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GeccoEngine
extends Thread {
    private static Log log = LogFactory.getLog(GeccoEngine.class);
    private Date startTime;
    private List<HttpRequest> startRequests = new ArrayList<HttpRequest>();
    private Scheduler scheduler;
    public SpiderBeanFactory spiderBeanFactory;
    public PipelineFactory pipelineFactory;
    private List<Spider> spiders;
    private String classpath;
    private int threadCount;
    private CountDownLatch cdl;
    private int interval;
    private boolean loop;
    private boolean mobile;
    private boolean debug;

    private GeccoEngine() {
    }

    public static GeccoEngine create() {
        GeccoEngine geccoEngine = new GeccoEngine();
        geccoEngine.setName("GeccoEngine");
        return geccoEngine;
    }

    public GeccoEngine start(String url) {
        return this.start(new HttpGetRequest(url));
    }

    public GeccoEngine start(HttpRequest request) {
        this.startRequests.add(request);
        return this;
    }

    public GeccoEngine start(List<HttpRequest> requests) {
        this.startRequests = requests;
        return this;
    }

    public GeccoEngine scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public GeccoEngine thread(int count) {
        this.threadCount = count;
        return this;
    }

    public GeccoEngine interval(int interval) {
        this.interval = interval;
        return this;
    }

    public GeccoEngine loop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public GeccoEngine mobile(boolean mobile) {
        this.mobile = mobile;
        return this;
    }

    public GeccoEngine debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public GeccoEngine classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public GeccoEngine pipelineFactory(PipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
        return this;
    }

    @Override
    public void run() {
        if (this.debug) {
            Logger log = LogManager.getLogger((String)"com.geccocrawler.gecco.spider.render");
            log.setLevel(Level.DEBUG);
        }
        if (this.scheduler == null) {
            this.scheduler = this.loop ? new StartScheduler() : new NoLoopStartScheduler();
        }
        if (this.spiderBeanFactory == null) {
            if (StringUtils.isEmpty((CharSequence)this.classpath)) {
                throw new IllegalArgumentException("classpath cannot be empty");
            }
            this.spiderBeanFactory = new SpiderBeanFactory(this.classpath, this.pipelineFactory);
        }
        if (this.threadCount <= 0) {
            this.threadCount = 1;
        }
        this.cdl = new CountDownLatch(this.threadCount);
        this.startsJson();
        if (this.startRequests.isEmpty()) {
            throw new IllegalArgumentException("startRequests cannot be empty");
        }
        for (HttpRequest startRequest : this.startRequests) {
            this.scheduler.into(startRequest);
        }
        this.spiders = new ArrayList<Spider>(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            Spider spider = new Spider(this);
            this.spiders.add(spider);
            Thread thread = new Thread((Runnable)spider, "Spider-" + i);
            thread.start();
        }
        this.startTime = new Date();
        GeccoMonitor.monitor(this);
        GeccoJmx.export(this.classpath);
        this.closeUnitlComplete();
    }

    private GeccoEngine startsJson() {
        try {
            URL url = Resources.getResource((String)"starts.json");
            File file = new File(url.getPath());
            if (file.exists()) {
                String json = Files.toString((File)file, (Charset)Charset.forName("UTF-8"));
                List list = JSON.parseArray((String)json, StartRequestList.class);
                for (StartRequestList start : list) {
                    this.start(start.toRequest());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            log.info((Object)"starts.json not found");
        }
        catch (IOException ioex) {
            log.error((Object)ioex);
        }
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SpiderBeanFactory getSpiderBeanFactory() {
        return this.spiderBeanFactory;
    }

    public int getInterval() {
        return this.interval;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public List<HttpRequest> getStartRequests() {
        return this.startRequests;
    }

    public List<Spider> getSpiders() {
        return this.spiders;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void notifyComplemet() {
        this.cdl.countDown();
    }

    public void closeUnitlComplete() {
        if (!this.loop) {
            try {
                this.cdl.await();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            if (this.spiderBeanFactory != null) {
                this.spiderBeanFactory.getDownloaderFactory().closeAll();
            }
            GeccoJmx.unexport();
            log.info((Object)"close gecco!");
        }
    }
}

