/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.SysUserEntity;
import com.gccloud.starter.common.module.register.dto.SysRegPhoneDTO;
import com.gccloud.starter.common.module.user.dto.SysUserDTO;
import com.gccloud.starter.common.utils.BeanConvertUtils;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.core.service.ISysTenantService;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.ISysDefaultUserService;
import com.gccloud.starter.oauth.service.service.sys.service.ISysPhoneRegisterService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysPhoneCaptchaServiceImpl;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysPhoneRegisterService"}, havingValue="SysPhoneRegisterServiceImpl", matchIfMissing=true)
public class SysPhoneRegisterServiceImpl
implements ISysPhoneRegisterService {
    @Resource
    private SysPhoneCaptchaServiceImpl phoneCaptchaService;
    @Resource
    private ISysUserService sysUserService;
    @Resource
    private ISysTokenService sysTokenService;
    @Autowired
    private ISysDefaultUserService sysDefaultUserService;
    @Resource
    private ISysTenantService sysTenantService;

    @Override
    public SysTokenVO register(SysRegPhoneDTO regPhoneDTO) {
        ValidatorUtils.validateEntity((Object)regPhoneDTO, (Class[])new Class[0]);
        this.phoneCaptchaService.validate("register-" + regPhoneDTO.getPhone(), regPhoneDTO.getCaptcha());
        SysUserDTO userDTO = (SysUserDTO)BeanConvertUtils.convert((Object)regPhoneDTO, SysUserDTO.class);
        userDTO.setUsername(regPhoneDTO.getPhone());
        userDTO.setCompanyId("0");
        userDTO.setTenantId(this.sysTenantService.getDefaultTenant().getId());
        this.sysUserService.add(userDTO);
        this.sysDefaultUserService.setDefaultUserProp(userDTO);
        SysUserEntity userEntity = (SysUserEntity)BeanConvertUtils.convert((Object)userDTO, SysUserEntity.class);
        userEntity.setUsernameUpdated(GlobalConst.User.UsernameUpdated.NO);
        userEntity.setCreateBy(userDTO.getId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(SysUserEntity::getId, (Object)userEntity.getId())).set(SysUserEntity::getUsernameUpdated, (Object)userEntity.getUsernameUpdated())).set(SysUserEntity::getCreateBy, (Object)userEntity.getId());
        this.sysUserService.update((Wrapper)updateWrapper);
        return this.sysTokenService.create(userDTO.getId());
    }
}

