/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.cache.SysSmsCaptchaCache;
import com.gccloud.starter.oauth.service.service.sys.service.ISysCaptchaService;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import com.gccloud.starter.plugins.cache.common.policy.GetPolicy;
import com.gccloud.starter.plugins.cache.common.policy.PutPolicy;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysCaptchaService"}, havingValue="SysPhoneCaptchaServiceImpl", matchIfMissing=true)
public class SysPhoneCaptchaServiceImpl
implements ISysCaptchaService {
    @Resource
    private IStarterCache starterCache;

    @Override
    public void saveCaptcha(String phone, String code) {
        this.starterCache.put(SysSmsCaptchaCache.class, (Serializable)((Object)phone), (Object)code, PutPolicy.L2);
    }

    @Override
    public void validate(String phone, String code) {
        String captchaCode = (String)this.starterCache.get(SysSmsCaptchaCache.class, (Serializable)((Object)phone), String.class, GetPolicy.L2);
        if (StringUtils.isBlank((CharSequence)captchaCode)) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
        }
        if (captchaCode.equalsIgnoreCase(code)) {
            this.starterCache.invalidate(SysSmsCaptchaCache.class, (Serializable)((Object)phone));
            return;
        }
        throw new GlobalException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
    }
}

