/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.SysUserEntity;
import com.gccloud.starter.common.module.register.dto.SysRegEmailDTO;
import com.gccloud.starter.common.module.user.dto.SysUserDTO;
import com.gccloud.starter.common.utils.BeanConvertUtils;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.core.service.ISysTenantService;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.ISysDefaultUserService;
import com.gccloud.starter.oauth.service.service.sys.service.ISysEmailRegisterService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysEmailCaptchaServiceImpl;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysEmailRegisterService"}, havingValue="SysEmailRegisterServiceImpl", matchIfMissing=true)
public class SysEmailRegisterServiceImpl
implements ISysEmailRegisterService {
    private static final Logger log = LoggerFactory.getLogger(SysEmailRegisterServiceImpl.class);
    @Resource
    private SysEmailCaptchaServiceImpl emailCaptchaService;
    @Resource
    private ISysUserService sysUserService;
    @Resource
    private ISysTokenService sysTokenService;
    @Autowired
    private ISysDefaultUserService sysDefaultUserService;
    @Resource
    private ISysTenantService sysTenantService;

    @Override
    public SysTokenVO register(SysRegEmailDTO regEmailDTO) {
        ValidatorUtils.validateEntity((Object)regEmailDTO, (Class[])new Class[0]);
        this.emailCaptchaService.validate("register-" + regEmailDTO.getEmail(), regEmailDTO.getCaptcha());
        SysUserDTO userDTO = (SysUserDTO)BeanConvertUtils.convert((Object)regEmailDTO, SysUserDTO.class);
        userDTO.setCompanyId("0");
        userDTO.setUsername(regEmailDTO.getEmail());
        userDTO.setTenantId(this.sysTenantService.getDefaultTenant().getId());
        this.sysUserService.add(userDTO);
        this.sysDefaultUserService.setDefaultUserProp(userDTO);
        SysUserEntity userEntity = (SysUserEntity)BeanConvertUtils.convert((Object)userDTO, SysUserEntity.class);
        userEntity.setUsernameUpdated(GlobalConst.User.UsernameUpdated.NO);
        userEntity.setCreateBy(userDTO.getId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(SysUserEntity::getId, (Object)userEntity.getId())).set(SysUserEntity::getUsernameUpdated, (Object)userEntity.getUsernameUpdated())).set(SysUserEntity::getCreateBy, (Object)userEntity.getId());
        this.sysUserService.update((Wrapper)updateWrapper);
        SysTokenVO tokenVO = this.sysTokenService.create(userDTO.getId());
        return tokenVO;
    }
}

