/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.entity.SysOrgEntity;
import com.gccloud.starter.common.entity.SysRoleEntity;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.user.dto.SysUserDTO;
import com.gccloud.starter.core.dto.SysUserOrgDTO;
import com.gccloud.starter.core.dto.SysUserRoleDTO;
import com.gccloud.starter.core.service.ISysOrgService;
import com.gccloud.starter.core.service.ISysRoleService;
import com.gccloud.starter.core.service.ISysUserOrgService;
import com.gccloud.starter.core.service.ISysUserRoleService;
import com.gccloud.starter.oauth.service.service.sys.service.ISysDefaultUserService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysDefaultUserService"}, havingValue="SysDefaultUserServiceImpl", matchIfMissing=true)
public class SysDefaultUserServiceImpl
implements ISysDefaultUserService {
    private static final Logger log = LoggerFactory.getLogger(SysDefaultUserServiceImpl.class);
    @Autowired
    private GlobalConfig globalConfig;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysOrgService sysOrgService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserOrgService sysUserOrgService;

    @Override
    public void setDefaultUserProp(SysUserDTO userDTO) {
        String roleCode = this.globalConfig.getDefaultUser().getRoleCode();
        String orgCode = this.globalConfig.getDefaultUser().getOrgCode();
        SysRoleEntity roleEntity = (SysRoleEntity)this.sysRoleService.getEntityByField(SysRoleEntity::getCode, (Object)roleCode);
        if (roleEntity == null) {
            throw new GlobalException(String.format("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u89d2\u8272\u7f16\u7801\u4e3a%s\u7684\u89d2\u8272", roleCode));
        }
        SysOrgEntity orgEntity = (SysOrgEntity)this.sysOrgService.getEntityByField(SysOrgEntity::getCode, (Object)orgCode);
        if (orgEntity == null) {
            throw new GlobalException(String.format("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u673a\u6784\u7f16\u7801\u4e3a%s\u7684\u673a\u6784", orgCode));
        }
        SysUserRoleDTO userRoleDTO = new SysUserRoleDTO();
        userRoleDTO.setUserId(userDTO.getId());
        ArrayList roleList = Lists.newArrayList();
        roleList.add(roleEntity.getId());
        userRoleDTO.setRoleIdList((List)roleList);
        userRoleDTO.setOrgId("-1");
        this.sysUserRoleService.update(userRoleDTO);
        SysUserOrgDTO userOrgDTO = new SysUserOrgDTO();
        userOrgDTO.setUserId(userDTO.getId());
        userOrgDTO.setOrgId(orgEntity.getId());
        this.sysUserOrgService.addOrUpdate(userOrgDTO);
    }
}

