/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.login.cache.SysCaptchaCache;
import com.gccloud.starter.oauth.service.service.sys.service.ISysCaptchaService;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import com.gccloud.starter.plugins.cache.common.policy.GetPolicy;
import com.gccloud.starter.plugins.cache.common.policy.PutPolicy;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysCaptchaService"}, havingValue="SysCaptchaServiceImpl", matchIfMissing=true)
public class SysCaptchaServiceImpl
implements ISysCaptchaService {
    @Resource
    private IStarterCache starterCache;

    @Override
    public void saveCaptcha(String uuid, String code) {
        this.starterCache.put(SysCaptchaCache.class, (Serializable)((Object)uuid), (Object)code, PutPolicy.L2);
    }

    @Override
    public void validate(String uuid, String code) {
        String captchaCode = (String)this.starterCache.get(SysCaptchaCache.class, (Serializable)((Object)uuid), String.class, GetPolicy.L2);
        if (StringUtils.isBlank((CharSequence)captchaCode)) {
            throw new GlobalException("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
        }
        this.starterCache.invalidate(SysCaptchaCache.class.getSimpleName(), (Serializable)((Object)uuid));
        if (captchaCode.equalsIgnoreCase(code)) {
            return;
        }
        throw new GlobalException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
    }
}

