/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.oauth.service.service.sys.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.entity.SysOrgEntity;
import com.gccloud.starter.common.entity.SysUserEntity;
import com.gccloud.starter.common.exception.GlobalException;
import com.gccloud.starter.common.module.register.dto.SysRegDTO;
import com.gccloud.starter.common.module.user.dto.SysUserDTO;
import com.gccloud.starter.common.utils.BeanConvertUtils;
import com.gccloud.starter.common.validator.ValidatorUtils;
import com.gccloud.starter.common.validator.group.Captcha;
import com.gccloud.starter.common.validator.group.Uuid;
import com.gccloud.starter.core.service.ISysOrgService;
import com.gccloud.starter.core.service.ISysTenantService;
import com.gccloud.starter.core.service.ISysTokenService;
import com.gccloud.starter.core.service.ISysUserService;
import com.gccloud.starter.core.vo.SysTokenVO;
import com.gccloud.starter.oauth.service.service.sys.service.ISysAccountRegisterService;
import com.gccloud.starter.oauth.service.service.sys.service.ISysDefaultUserService;
import com.gccloud.starter.oauth.service.service.sys.service.impl.SysCaptchaServiceImpl;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="gc.starter.component", name={"ISysAccountRegisterService"}, havingValue="SysAccountRegisterServiceImpl", matchIfMissing=true)
public class SysAccountRegisterServiceImpl
implements ISysAccountRegisterService {
    @Autowired
    private GlobalConfig globalConfig;
    @Resource
    private SysCaptchaServiceImpl sysCaptchaService;
    @Resource
    private ISysUserService sysUserService;
    @Resource
    private ISysTokenService sysTokenService;
    @Autowired
    private ISysDefaultUserService sysDefaultUserService;
    @Resource
    private ISysTenantService sysTenantService;
    @Resource
    private ISysOrgService orgService;

    @Override
    public SysTokenVO register(SysRegDTO regDTO) {
        ValidatorUtils.validateEntity((Object)regDTO, (Class[])new Class[0]);
        if (this.globalConfig.getCaptcha().isEnable()) {
            ValidatorUtils.validateEntity((Object)regDTO, (Class[])new Class[]{Uuid.class, Captcha.class});
            this.sysCaptchaService.validate(regDTO.getUuid(), regDTO.getCaptcha());
        }
        SysUserDTO userDTO = (SysUserDTO)BeanConvertUtils.convert((Object)regDTO, SysUserDTO.class);
        userDTO.setTenantId(this.sysTenantService.getDefaultTenant().getId());
        userDTO.setCompanyId("0");
        String orgCode = this.globalConfig.getDefaultUser().getOrgCode();
        SysOrgEntity orgEntity = (SysOrgEntity)this.orgService.getEntityByField(SysOrgEntity::getCode, (Object)orgCode);
        if (orgEntity == null) {
            throw new GlobalException(String.format("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u673a\u6784\u7f16\u7801\u4e3a%s\u7684\u673a\u6784", orgCode));
        }
        userDTO.setOrgId(orgEntity.getId());
        this.sysUserService.add(userDTO);
        this.sysDefaultUserService.setDefaultUserProp(userDTO);
        SysUserEntity userEntity = (SysUserEntity)BeanConvertUtils.convert((Object)userDTO, SysUserEntity.class);
        userEntity.setCreateBy(userDTO.getId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(SysUserEntity::getCreateBy, (Object)userEntity.getId())).eq(SysUserEntity::getId, (Object)userEntity.getId());
        this.sysUserService.update((Wrapper)updateWrapper);
        SysTokenVO tokenVO = this.sysTokenService.create(userDTO.getId());
        return tokenVO;
    }
}

