/*
 * Decompiled with CFR 0.152.
 */
package udtudrmgr;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import udtudrmgr.CodeGenUtil;
import udtudrmgr.UDRManager;
import udtudrmgr.UDTMetaData;

public class UDTManager {
    private IfxConnection conn = null;
    private String jarTmpPath = null;
    private String gbasedbtdir = null;
    private Locale locale = Locale.getDefault();
    private Trace trace = null;
    private boolean isInUserTx = false;
    private boolean hasDefltIOmthd = false;

    public UDTManager(Connection conn) throws SQLException {
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        this.conn = (IfxConnection)conn;
        this.jarTmpPath = UDRManager.isNTServer(this.conn) ? "c:\\Temp\\" : "/tmp/";
        if (TraceFlag.compiletrace) {
            this.trace = this.conn.getTrace();
            if (this.trace == null) {
                System.out.println("UDTManager: Trace is NULL");
            } else {
                this.trace.writeTrace(99, "UDTManager: constructor exited");
            }
        }
    }

    public void createUDT(UDTMetaData mdata, String jarfile, String classname, int deploy) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDT(mata,jarfile,classname,deploy) entered");
        }
        if (mdata == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (classname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (mdata.sqlname == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        UDRManager.checkJarFile(jarfile, this.locale);
        int dbtype = this.conn.getDatabaseType();
        if (dbtype == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        this.checkUDTClass(classname);
        if (this.isUDTInSysCatalog(mdata.sqlname)) {
            throw IfxErrMsg.getSQLException(-79848, "", this.locale);
        }
        String jarFileSQLName = mdata.jarFileSQLName;
        if (jarFileSQLName == null) {
            throw IfxErrMsg.getSQLException(-79843, "", this.locale);
        }
        UDRManager.checkJarInSysCatalog(jarFileSQLName, this.conn, this.locale);
        String jarFileInServer = UDRManager.transportJarToServer(jarfile, this.jarTmpPath, this.conn, this.locale);
        if (dbtype == 1 || dbtype == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "UDTManager.createUDT(): start new tx");
                }
                this.conn.setAutoCommit(false);
            }
        }
        try {
            UDRManager.installJarNow(jarFileSQLName, jarFileInServer, deploy, this.conn);
            this.registerUDT(mdata);
            this.registerSupportUDRs(mdata, classname);
            UDRManager.registerUDRs(mdata, classname, mdata.sqlname, this.conn, this.locale);
            this.registerImplCasts(mdata.implCasts, mdata.sqlname);
            this.registerExplCasts(mdata.explCasts, mdata.sqlname);
            this.setExternalName(mdata.sqlname, jarFileSQLName, classname);
        }
        catch (SQLException e2) {
            if (!this.isInUserTx) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(2, "UDTManager.createUDT(): rollback new tx");
                }
                this.conn.rollback();
                throw e2;
            }
            throw e2;
        }
        if (!(dbtype != 1 && dbtype != 2 || this.isInUserTx)) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "UDTManager.createUDT(): commit new tx");
            }
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        UDRManager.removeFileInServer(jarFileInServer, this.conn);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDT(mata,jarfile,classname,deploy) exited");
        }
    }

    public String createUDTClass(UDTMetaData mdata) throws SQLException {
        Vector<CodeGenUtil.Field> fields = new Vector<CodeGenUtil.Field>();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createUDTClass() entered");
        }
        if (mdata == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (mdata.getSQLName() == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        if (mdata.getFieldCount() < 1) {
            throw IfxErrMsg.getSQLException(-79850, "", this.locale);
        }
        if (mdata.getLength() == -1) {
            throw IfxErrMsg.getSQLException(-79851, "", this.locale);
        }
        CodeGenUtil cg = new CodeGenUtil();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "count is " + mdata.getFieldCount());
        }
        for (int iCount = 1; iCount <= mdata.getFieldCount(); ++iCount) {
            String name = mdata.getFieldName(iCount);
            int type = mdata.getFieldType(iCount);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "Field = " + iCount + ", '" + name + "'");
            }
            if (name == null || type == -1) {
                throw IfxErrMsg.getSQLException(-79852, "", this.locale);
            }
            int len = mdata.getFieldLength(iCount);
            String typeName = cg.toStringType(type, (short)len);
            if (len == -1 && (IfxTypes.isString(type) || type == 10 || type == 14)) {
                throw IfxErrMsg.getSQLException(-79863, "", this.locale);
            }
            String readProcName = CodeGenUtil.getReadProcName(typeName, len);
            String writeProcName = CodeGenUtil.getWriteProcName(typeName, name, len);
            CodeGenUtil codeGenUtil = cg;
            codeGenUtil.getClass();
            fields.addElement(codeGenUtil.new CodeGenUtil.Field(name, typeName, readProcName, writeProcName));
        }
        String javafilename = this.compilesource(cg.generateFile(mdata.getSQLName(), mdata.getClassName(), fields));
        String classname = javafilename.substring(0, javafilename.indexOf(46));
        if (!mdata.keepJavaFile) {
            this.removeClientFile(javafilename);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "keepJavaFile = " + mdata.keepJavaFile);
            this.trace.writeTrace(3, "classname = '" + classname + "'");
            this.trace.writeTrace(1, "UDTManager:createUDTClass() exited");
        }
        return classname;
    }

    public String createJar(UDTMetaData mdata, String[] classnames) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createJar() entered");
        }
        if (mdata == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (mdata.sqlname == null) {
            throw IfxErrMsg.getSQLException(-79849, "", this.locale);
        }
        if (classnames == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        if (classnames.length == 0) {
            throw IfxErrMsg.getSQLException(-79853, "", this.locale);
        }
        String jarfilename = mdata.sqlname + ".jar";
        StringBuffer cls = new StringBuffer();
        File clsFileObj = null;
        for (int i2 = 0; i2 < classnames.length; ++i2) {
            clsFileObj = new File(classnames[i2]);
            if (!clsFileObj.exists()) {
                throw IfxErrMsg.getSQLException(-79853, "", this.locale);
            }
            cls = cls.append(" " + classnames[i2]);
        }
        String cmd = "jar cf " + jarfilename + cls.toString();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + cmd + "'");
        }
        try {
            Process p2 = Runtime.getRuntime().exec(cmd);
            if (p2.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79847, "", this.locale);
            }
        }
        catch (Exception e2) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exeception occurs : " + e2.toString());
            }
            throw IfxErrMsg.getSQLException(-79847, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:createJar() exited");
        }
        return jarfilename;
    }

    public void removeUDT(String sqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeUDT() entered");
        }
        if (sqlname == null) {
            throw IfxErrMsg.getSQLException(-79708, "", this.locale);
        }
        int dbtype = this.conn.getDatabaseType();
        if (dbtype == 0) {
            throw IfxErrMsg.getSQLException(-79844, "", this.locale);
        }
        int xid = this.getUDTXid(sqlname);
        if (dbtype == 1 || dbtype == 2) {
            if (((IfxSqliConnect)this.conn).isInUserTransaction()) {
                this.isInUserTx = true;
            } else {
                this.conn.setAutoCommit(false);
            }
        }
        try {
            this.unsetExternalName(sqlname);
            this.unregisterCastsAndCastUDRs(sqlname, xid);
            this.unregisterNonCastUDRs(sqlname, xid);
            this.unregisterUDT(sqlname);
        }
        catch (SQLException e2) {
            if (!this.isInUserTx) {
                this.conn.rollback();
                throw e2;
            }
            throw e2;
        }
        if (!(dbtype != 1 && dbtype != 2 || this.isInUserTx)) {
            this.conn.commit();
            this.conn.setAutoCommit(true);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeUDT() exited");
        }
    }

    public void removeJar(String jarfilesqlname, int undeploy) throws SQLException {
        UDRManager.removeJarNow(jarfilesqlname, undeploy, this.conn, this.locale);
    }

    public void setJarTmpPath(String path) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setJarTmpPath() entered");
        }
        this.jarTmpPath = UDRManager.getJarTmpPathNow(this.conn, path, this.locale);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setJarTmpPath() exited");
        }
    }

    private void checkUDTClass(String classname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:checkUDTClass() entered");
        }
        try {
            int i2;
            Class<?> c2 = Class.forName(classname);
            Class<?>[] interfaces = c2.getInterfaces();
            for (i2 = 0; i2 < interfaces.length && !interfaces[i2].getName().equals("java.sql.SQLData"); ++i2) {
            }
            if (i2 == interfaces.length) {
                throw IfxErrMsg.getSQLException(-79854, "", this.locale);
            }
        }
        catch (ClassNotFoundException e2) {
            throw IfxErrMsg.getSQLException(-79855, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:checkUDTClass() exited");
        }
    }

    private boolean isUDTInSysCatalog(String sqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:isUDTInSysCatalog() entered");
        }
        String sql = null;
        sql = this.conn.getDatabaseType() == 1 ? "select name from gbasedbt.sysxtdtypes where name = '" + sqlname + "' and owner = '" + this.conn.getUserName() + "' and mode = 'B'" : "select name from gbasedbt.sysxtdtypes where name = '" + sqlname + "' and mode = 'B'";
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean udtExists = rs.next();
        rs.close();
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
            this.trace.writeTrace(1, "UDTManager:isUDTInSysCatalog() exited");
        }
        return udtExists;
    }

    private int getUDTXid(String sqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:getUDTXid() entered");
        }
        String sql = null;
        sql = this.conn.getDatabaseType() == 1 ? "select extended_id from gbasedbt.sysxtdtypes where owner = '" + this.conn.getUserName() + "' and name = '" + sqlname + "' and mode = 'B'" : "select extended_id from gbasedbt.sysxtdtypes where name = '" + sqlname + "' and mode = 'B'";
        int xid = -1;
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        boolean udtExists = rs.next();
        if (udtExists) {
            xid = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        if (!udtExists) {
            throw IfxErrMsg.getSQLException(-79856, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
            this.trace.writeTrace(3, "xid = " + xid);
            this.trace.writeTrace(1, "UDTManager:getUDTXid() exited");
        }
        return xid;
    }

    private void registerUDT(UDTMetaData mdata) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerUDT() entered");
        }
        String udtSQLName = mdata.sqlname;
        int udtLength = mdata.length;
        StringBuffer buf = new StringBuffer(30);
        buf.append("CREATE OPAQUE TYPE " + udtSQLName + " (");
        if (mdata.length == -1) {
            buf.append("internallength = variable");
        } else {
            buf.append("internallength = " + mdata.length);
        }
        if (mdata.align != -1) {
            buf.append(", alignment = " + mdata.align);
        }
        buf.append(")");
        String sql = buf.toString().trim();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
        }
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerUDT() exited");
        }
    }

    private void unregisterUDT(String udtsqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterUDT() entered");
        }
        String sql = "DROP TYPE " + udtsqlname + " RESTRICT";
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
            this.trace.writeTrace(1, "UDTManager:unregisterUDT() exited");
        }
    }

    private void registerSupportUDRs(UDTMetaData mdata, String classname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() entered");
        }
        boolean[] useDefault = new boolean[8];
        for (int mType = 0; mType < 8; ++mType) {
            useDefault[mType] = true;
        }
        Method m2 = null;
        String mName = null;
        String mSQLName = null;
        String mSQLParams = null;
        String mJavaParams = null;
        String mSQLReturn = null;
        String sql = null;
        Hashtable supportudrs = mdata.supportudrs;
        String udtSQLName = mdata.sqlname;
        String jarFileSQLName = mdata.jarFileSQLName;
        Statement stmt = this.conn.createStatement();
        if (supportudrs != null && supportudrs.size() != 0) {
            int numUdrs = supportudrs.size();
            UDTMetaData.supportudrinfo[] supportUDRInfo = new UDTMetaData.supportudrinfo[numUdrs];
            int i2 = 0;
            Enumeration e2 = supportudrs.elements();
            while (e2.hasMoreElements()) {
                supportUDRInfo[i2] = (UDTMetaData.supportudrinfo)e2.nextElement();
                m2 = supportUDRInfo[i2].method;
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "m = " + m2.toString());
                }
                mName = m2.getName();
                mSQLName = supportUDRInfo[i2].sqlname;
                mSQLParams = UDRManager.fromClassesToIfxNames(m2.getParameterTypes(), classname, udtSQLName, this.trace, this.locale);
                mJavaParams = UDRManager.fromClassesToJavaNames(m2.getParameterTypes(), this.trace);
                mSQLReturn = UDRManager.fromClassesToIfxNames(new Class[]{m2.getReturnType()}, classname, udtSQLName, this.trace, this.locale);
                sql = "CREATE FUNCTION " + mSQLName + " (" + mSQLParams + ") RETURNS " + mSQLReturn + " EXTERNAL NAME '" + jarFileSQLName + ":" + classname + "." + mName + "(" + mJavaParams + ")' LANGUAGE JAVA NOT VARIANT END FUNCTION";
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "sql = " + sql);
                }
                stmt.executeUpdate(sql);
                useDefault[supportUDRInfo[i2].type] = false;
                ++i2;
            }
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() exited");
            }
            return;
        }
        block12: for (int mType = 0; mType < 8; ++mType) {
            if (!useDefault[mType]) continue;
            switch (mType) {
                case 0: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_input (lvarchar) RETURNS " + udtSQLName + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE IMPLICIT CAST (lvarchar as " + udtSQLName + " with " + udtSQLName + "_input)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 1: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_output (" + udtSQLName + ") RETURNS lvarchar EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE EXPLICIT CAST (" + udtSQLName + " as lvarchar with " + udtSQLName + "_output)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 2: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_send (" + udtSQLName + ") RETURNS sendrecv EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE EXPLICIT CAST (" + udtSQLName + " as sendrecv with " + udtSQLName + "_send)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 3: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_receive (sendrecv) RETURNS " + udtSQLName + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE IMPLICIT CAST (sendrecv as " + udtSQLName + " with " + udtSQLName + "_receive)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 4: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_import (impexp) RETURNS " + udtSQLName + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE IMPLICIT CAST (impexp as " + udtSQLName + " with " + udtSQLName + "_import)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 5: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_export (" + udtSQLName + ") RETURNS impexp EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE EXPLICIT CAST (" + udtSQLName + " as impexp with " + udtSQLName + "_export)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 6: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_binaryimport (impexpbin) RETURNS " + udtSQLName + " EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataInput(java.lang.Object)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE IMPLICIT CAST (impexpbin as " + udtSQLName + " with " + udtSQLName + "_binaryimport)";
                    stmt.executeUpdate(sql);
                    continue block12;
                }
                case 7: {
                    sql = "CREATE FUNCTION " + udtSQLName + "_binaryexport (" + udtSQLName + ") RETURNS impexpbin EXTERNAL NAME 'com.gbasedbt.jdbc.IfxDataPointer.IfxDataOutput(java.sql.SQLData)' LANGUAGE JAVA VARIANT END FUNCTION";
                    stmt.executeUpdate(sql);
                    sql = "CREATE EXPLICIT CAST (" + udtSQLName + " as impexpbin with " + udtSQLName + "_binaryexport)";
                    stmt.executeUpdate(sql);
                }
            }
        }
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerSupportUDRs() exited");
        }
    }

    private void registerImplCasts(Vector castVec, String udtsqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerImplCasts() entered");
        }
        String sql = null;
        String ifxname = null;
        UDTMetaData.castinfo cast = null;
        if (castVec != null && castVec.size() != 0) {
            Statement stmt = this.conn.createStatement();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "castVec's size = " + castVec.size());
            }
            for (int i2 = 0; i2 < castVec.size(); ++i2) {
                cast = (UDTMetaData.castinfo)castVec.elementAt(i2);
                ifxname = IfxTypes.IfxTypeToName(cast.ifxtype);
                sql = "CREATE IMPLICIT CAST (" + ifxname + " as " + udtsqlname + " with " + cast.methodsqlname + ")";
                stmt.executeUpdate(sql);
            }
            stmt.close();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerImplCasts() exited");
        }
    }

    private void registerExplCasts(Vector castVec, String udtsqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerExplCasts() entered");
        }
        String sql = null;
        String ifxname = null;
        UDTMetaData.castinfo cast = null;
        if (castVec != null && castVec.size() != 0) {
            Statement stmt = this.conn.createStatement();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "castVec's size = " + castVec.size());
            }
            for (int i2 = 0; i2 < castVec.size(); ++i2) {
                cast = (UDTMetaData.castinfo)castVec.elementAt(i2);
                ifxname = IfxTypes.IfxTypeToName(cast.ifxtype);
                sql = "CREATE EXPLICIT CAST (" + udtsqlname + " as " + ifxname + " with " + cast.methodsqlname + ")";
                stmt.executeUpdate(sql);
            }
            stmt.close();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:registerExplCasts() exited");
        }
    }

    private void unregisterCastsAndCastUDRs(String udtsqlname, int udtxid) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterCastsAndCastUDRs() entered");
        }
        String sql = null;
        Statement drop_stmt = this.conn.createStatement();
        Statement type_stmt = this.conn.createStatement();
        sql = this.conn.getDatabaseType() == 1 ? "select argument_type, argument_xid, result_type, result_xid, routine_name, class from gbasedbt.syscasts where (argument_xid = " + udtxid + " or result_xid = " + udtxid + ") and owner = '" + this.conn.getUserName() + "'" : "select argument_type, argument_xid, result_type, result_xid, routine_name, class from gbasedbt.syscasts where (argument_xid = " + udtxid + " or result_xid = " + udtxid + ")";
        ResultSet type_rs = type_stmt.executeQuery(sql);
        while (type_rs.next()) {
            String ifxname;
            int argument_type = type_rs.getInt(1);
            int argument_xid = type_rs.getInt(2);
            int result_type = type_rs.getInt(3);
            int result_xid = type_rs.getInt(4);
            String routine = type_rs.getString(5);
            String castclass = type_rs.getString(6);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "UDTManager: ");
                this.trace.writeTrace(3, "\targument_type = " + argument_type + ", argument_xid = " + argument_xid);
                this.trace.writeTrace(3, "\tresult_type = " + result_type + ", result_xid = " + result_xid);
                this.trace.writeTrace(3, "\troutine = " + routine);
                this.trace.writeTrace(3, "\tcastclass = " + castclass);
            }
            if (castclass.equals("I")) {
                ifxname = argument_type <= 18 ? IfxTypes.IfxTypeToName(argument_type) : this.getXTypeName(argument_xid);
                sql = "DROP CAST (" + ifxname + " as " + udtsqlname + ")";
            } else {
                ifxname = result_type <= 18 ? IfxTypes.IfxTypeToName(result_type) : this.getXTypeName(result_xid);
                sql = "DROP CAST (" + udtsqlname + " as " + ifxname + ")";
            }
            drop_stmt.executeUpdate(sql);
            sql = "DROP ROUTINE " + routine;
            drop_stmt.executeUpdate(sql);
        }
        type_rs.close();
        drop_stmt.close();
        type_stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterCastsAndCastUDRs() exited");
        }
    }

    private void unregisterNonCastUDRs(String udtsqlname, int udtxid) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterNonCastUDRs() entered");
        }
        String sql = null;
        Statement drop_stmt = this.conn.createStatement();
        Statement proc_stmt = this.conn.createStatement();
        sql = this.conn.getDatabaseType() == 1 ? "select procname, isproc, paramtypes::lvarchar from gbasedbt.sysprocedures where paramtypes::lvarchar like '%" + udtsqlname + "%' and langid = (select langid from gbasedbt.sysroutinelangs where langname = 'java') and owner = '" + this.conn.getUserName() + "'" : "select procname, isproc, paramtypes::lvarchar from gbasedbt.sysprocedures where paramtypes::lvarchar like '%" + udtsqlname + "%' and langid = (select langid from gbasedbt.sysroutinelangs where langname = 'java')";
        ResultSet proc_rs = proc_stmt.executeQuery(sql);
        while (proc_rs.next()) {
            String procname = proc_rs.getString(1);
            String isproc = proc_rs.getString(2);
            String paramtypes = proc_rs.getString(3);
            sql = isproc.equals("f") ? "DROP FUNCTION " + procname + " (" + paramtypes + ")" : "DROP PROCEDURE " + procname + " (" + paramtypes + ")";
            drop_stmt.executeUpdate(sql);
        }
        proc_rs.close();
        drop_stmt.close();
        proc_stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unregisterNonCastUDRs() exited");
        }
    }

    private void setExternalName(String udtsqlname, String jarfilesqlname, String classname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setExternalName() entered");
        }
        Statement stmt = this.conn.createStatement();
        String sql = "EXECUTE PROCEDURE sqlj.setUDTExtName('" + udtsqlname + "', '" + jarfilesqlname + ":" + classname + "')";
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:setExternalName() exited");
        }
    }

    private void unsetExternalName(String udtsqlname) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unsetExternalName() entered");
        }
        Statement stmt = this.conn.createStatement();
        String sql = "EXECUTE PROCEDURE sqlj.unsetUDTExtName('" + udtsqlname + "')";
        stmt.executeUpdate(sql);
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:unsetExternalName() exited");
        }
    }

    private String compilesource(String javafilename) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:compilesource() entered");
        }
        String cmd = "javac " + javafilename;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + cmd + "'");
        }
        try {
            Process child = Runtime.getRuntime().exec(cmd);
            if (child.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79847, "", this.locale);
            }
        }
        catch (Exception e2) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exception occurs : " + e2.toString());
            }
            throw IfxErrMsg.getSQLException(-79847, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:compilesource() exited");
        }
        return javafilename;
    }

    private String getXTypeName(int xid) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:getXTypeName() entered");
        }
        String sql = "select name from gbasedbt.sysxtdtypes where extended_id = " + xid;
        String name = null;
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        if (rs.next()) {
            name = rs.getString(1);
        }
        rs.close();
        stmt.close();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "sql = " + sql);
            this.trace.writeTrace(3, "name = " + name);
            this.trace.writeTrace(1, "UDTManager:getXTypeName() exited");
        }
        return name;
    }

    private void removeClientFile(String filename) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeClientFile() entered");
        }
        String cmd = "rm -f " + filename;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "cmd is '" + cmd + "'");
        }
        try {
            Process child = Runtime.getRuntime().exec(cmd);
            if (child.waitFor() != 0) {
                throw IfxErrMsg.getSQLException(-79858, "", this.locale);
            }
        }
        catch (Exception e2) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "exception occurs : " + e2.toString());
            }
            throw IfxErrMsg.getSQLException(-79858, "", this.locale);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "UDTManager:removeClientFile() exited");
        }
    }
}

