/*
 * Decompiled with CFR 0.152.
 */
package sqlj.codegen;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import sqlj.codegen.CodeGenerator;
import sqlj.codegen.JSClassType;
import sqlj.codegen.TypedExpression;
import sqlj.codegen.engine.ClassDecl;
import sqlj.codegen.engine.CodegenException;
import sqlj.codegen.engine.FieldDecl;
import sqlj.codegen.engine.IndentationWriter;
import sqlj.codegen.engine.Initializer;
import sqlj.codegen.engine.Modifiers;
import sqlj.codegen.engine.Streamable;
import sqlj.framework.error.JSError;
import sqlj.syntax.ClassElem;
import sqlj.syntax.Elem;
import sqlj.util.OutputContext;
import sqlj.util.Parselet;

abstract class BaseCodegen
implements CodeGenerator {
    protected Elem m_elem;

    @Override
    public boolean generate(OutputContext outputContext) throws IOException {
        IndentationWriter indentationWriter = new IndentationWriter(outputContext.getWriter());
        try {
            this.generate(indentationWriter);
        }
        catch (CodegenException codegenException) {
            this.m_elem.getErrorLog().addEntry(new JSError(codegenException.getMessage()));
            return false;
        }
        if (indentationWriter.checkError()) {
            throw new IOException("<CODEGEN>");
        }
        return true;
    }

    public static boolean generate(Writer writer, Streamable streamable) throws IOException {
        IndentationWriter indentationWriter = new IndentationWriter(writer);
        try {
            streamable.stream(indentationWriter);
        }
        catch (CodegenException codegenException) {
            return false;
        }
        if (indentationWriter.checkError()) {
            throw new IOException();
        }
        return true;
    }

    public abstract void generate(PrintWriter var1) throws IOException, CodegenException;

    protected BaseCodegen(Elem elem) {
        this.m_elem = elem;
    }

    protected void addClassInfo(ClassDecl classDecl, ClassElem classElem, JSClassType.Factory factory) throws ClassNotFoundException {
        String string;
        classDecl.modifiers(new Modifiers(classElem.getModifiers()));
        Enumeration enumeration = classElem.getInterfaces();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            classDecl.addImplements(string);
        }
        enumeration = classElem.getWithKeywords();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Parselet parselet = classElem.getWithValue(string);
            classDecl.addBodyDecl(this.newWithField(string, parselet, factory));
        }
    }

    private FieldDecl newWithField(String string, Parselet parselet, JSClassType.Factory factory) throws ClassNotFoundException {
        TypedExpression typedExpression = new TypedExpression(parselet, factory);
        FieldDecl fieldDecl = new FieldDecl();
        fieldDecl.name(string);
        fieldDecl.modifiers(Modifiers.STATIC_PUBLIC_FINAL);
        fieldDecl.type(typedExpression.getType());
        fieldDecl.initializer(new Initializer(typedExpression));
        return fieldDecl;
    }
}

