/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.lang;

import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;

public class IntervalDF
extends Interval {
    protected long seconds;
    protected long nanos;
    String locale = null;
    protected static final int NanosPerSecond = 1000000000;
    protected static final int MilliPerSecond = 1000;
    protected static final int SecondsPerMinute = 60;
    protected static final int SecondsPerHour = 3600;
    protected static final int SecondsPerDay = 86400;

    public IntervalDF() throws SQLException {
        this.setQualifier((byte)4, (byte)15);
    }

    public IntervalDF(Connection connection) throws SQLException {
        this();
        this.setConnection(connection);
    }

    public IntervalDF(Timestamp timestamp, Timestamp timestamp2) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(timestamp, timestamp2);
    }

    public IntervalDF(Timestamp timestamp, Timestamp timestamp2, Connection connection) throws SQLException {
        this(timestamp, timestamp2);
        this.setConnection(connection);
    }

    public IntervalDF(long l2, long l3) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(l2, l3);
    }

    public IntervalDF(long l2, long l3, Connection connection) throws SQLException {
        this(l2, l3);
        this.setConnection(connection);
    }

    public IntervalDF(long l2, long l3, short s2) throws SQLException {
        this.setQualifier(s2);
        this.set(l2, l3);
    }

    public IntervalDF(long l2, long l3, short s2, Connection connection) throws SQLException {
        this(l2, l3, s2);
        this.setConnection(connection);
    }

    public IntervalDF(String string) throws SQLException {
        this.setQualifier((byte)4, (byte)15);
        this.set(string);
    }

    public IntervalDF(String string, Connection connection) throws SQLException {
        this(string);
        this.setConnection(connection);
    }

    public IntervalDF(String string, short s2) throws SQLException {
        this.setQualifier(s2);
        this.set(string);
    }

    public IntervalDF(String string, short s2, Connection connection) throws SQLException {
        this(string, s2);
        this.set(string);
        this.setConnection(connection);
    }

    public IntervalDF(String string, int n2, byte by, byte by2) throws SQLException {
        this.setQualifier((byte)n2, by, by2);
        this.set(string);
    }

    public IntervalDF(String string, int n2, byte by, byte by2, Connection connection) throws SQLException {
        this(string, n2, by, by2);
        this.setConnection(connection);
    }

    public void set(Timestamp timestamp, Timestamp timestamp2) {
        long l2 = timestamp.getTime() / 1000L;
        long l3 = timestamp2.getTime() / 1000L;
        long l4 = l2 - l3;
        long l5 = timestamp.getNanos() - timestamp2.getNanos();
        this.set(l4, l5);
    }

    public void set(long l2, long l3) {
        if (l2 < 0L) {
            if (l3 > 0L) {
                ++l2;
                l3 -= 1000000000L;
            }
        } else if (l3 < 0L && l2 > 0L) {
            --l2;
            l3 += 1000000000L;
        }
        this.seconds = l2;
        this.nanos = l3;
    }

    public void set(String string) throws SQLException {
        if (string == null) {
            return;
        }
        this.fromString(string);
    }

    public String toString() {
        int n2;
        int n3;
        long l2 = this.seconds;
        long l3 = this.nanos;
        StringBuffer stringBuffer = new StringBuffer();
        short s2 = this.getQualifier();
        int n4 = IntervalDF.getEndCode(s2);
        byte by = IntervalDF.getStartCode(s2);
        IntervalDF.println("IntervalDF.toString() secs = " + l2 + " nans = " + l3 + " start = " + by + " end = " + n4);
        boolean bl = false;
        if (this.seconds < 0L || this.seconds == 0L && this.nanos < 0L) {
            bl = true;
            l2 = -this.seconds;
            l3 = -l3;
        }
        if (by == 4) {
            long l4 = l2 / 86400L;
            l2 %= 86400L;
            stringBuffer.append(l4);
            if (n4 > 4) {
                stringBuffer.append(dtdelim[2]);
            }
            IntervalDF.println("After processing Days: " + stringBuffer);
        }
        if (by <= 6 && n4 >= 6) {
            long l5 = l2 / 3600L;
            l2 %= 3600L;
            if (l5 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l5);
            if (n4 > 6) {
                stringBuffer.append(dtdelim[3]);
            }
            IntervalDF.println("After processing Hours: " + stringBuffer);
        }
        if (by <= 8 && n4 >= 8) {
            long l6 = l2 / 60L;
            l2 %= 60L;
            if (l6 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l6);
            if (n4 > 8) {
                stringBuffer.append(dtdelim[4]);
            }
            IntervalDF.println("After processing Minutes: " + stringBuffer);
        }
        if (by <= 10 && n4 >= 10) {
            if (l2 < 10L) {
                stringBuffer.append('0');
            }
            stringBuffer.append(l2);
            IntervalDF.println("After processing Seconds: " + stringBuffer);
        }
        if (n4 > 10) {
            stringBuffer.append(dtdelim[5]);
            if (l3 == 0L) {
                for (n3 = 11; n3 <= n4; ++n3) {
                    stringBuffer.append('0');
                }
            } else {
                int n5;
                n3 = n4 - 10;
                n2 = 0;
                long l7 = 100000000L;
                for (n5 = 11; n5 <= n4 && l3 != 0L; ++n5) {
                    if (l3 < l7) {
                        stringBuffer.append('0');
                        ++n2;
                    } else {
                        stringBuffer.append((long)((int)l3) / l7);
                        ++n2;
                        l3 %= l7;
                    }
                    l7 /= 10L;
                }
                for (n5 = n2; n5 < n3; ++n5) {
                    stringBuffer.append('0');
                }
            }
            IntervalDF.println("After processing Fractions: " + stringBuffer);
        }
        IntervalDF.println("IntervalDF.toString no strip |" + stringBuffer.toString());
        n2 = stringBuffer.length() - 1;
        for (n3 = 0; n3 < n2 && stringBuffer.charAt(n3) == '0' && Character.isDigit(stringBuffer.charAt(n3 + 1)); ++n3) {
            stringBuffer.setCharAt(n3, ' ');
        }
        if (bl) {
            stringBuffer.insert(n3, '-');
        }
        IntervalDF.println("IntervalDF.toString return |" + stringBuffer.toString());
        return stringBuffer.toString();
    }

    public void fromString(String string) throws SQLException {
        if (string == null) {
            return;
        }
        short s2 = this.getQualifier();
        string = string.trim();
        boolean bl = false;
        if (string.length() > 0 && (string.charAt(0) == '-' || string.charAt(0) == '+')) {
            if (string.length() == 1) {
                throw IfxErrMsg.getLocSQLException(-79706, this.locale);
            }
            if (string.charAt(0) == '-') {
                bl = true;
            }
            string = string.substring(1);
        }
        int[] nArray = this.stringToUnits(string, s2);
        this.seconds = (long)nArray[2] * 86400L;
        this.seconds += (long)nArray[3] * 3600L;
        this.seconds += (long)nArray[4] * 60L;
        this.seconds += (long)nArray[5];
        this.nanos = nArray[6];
        if (bl) {
            this.seconds = -this.seconds;
            this.nanos = -this.nanos;
        }
        IntervalDF.println("IntervalDF.fromString() seconds = " + this.seconds + " nanos: " + this.nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public long getNanoSeconds() {
        return this.nanos;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof IntervalDF && object != null) {
            bl = this.seconds == ((IntervalDF)object).getSeconds() && this.nanos == ((IntervalDF)object).getNanoSeconds();
        }
        return bl;
    }

    public boolean greaterThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l2 = intervalDF.getSeconds();
            bl = this.seconds > l2 ? true : this.seconds == l2 && this.nanos > intervalDF.getNanoSeconds();
        }
        return bl;
    }

    public boolean lessThan(IntervalDF intervalDF) {
        boolean bl = false;
        if (intervalDF != null) {
            long l2 = intervalDF.getSeconds();
            bl = this.seconds < l2 ? true : this.seconds == l2 && this.nanos < intervalDF.getNanoSeconds();
        }
        return bl;
    }

    private void setQualifier(byte by, byte by2) throws SQLException {
        this.setQualifier((byte)2, by, by2);
    }

    public void setQualifier(byte by, byte by2, byte by3) throws SQLException {
        IntervalDF.println("Interval.setQualifier(" + by + " , " + by2 + " , " + by3 + ")");
        if (by2 < 4 || by3 < 4 || by2 > by3) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = (short)(by3 - by2 + by << 8 | by2 << 4 | by3);
    }

    public void setQualifier(short s2) throws SQLException {
        IntervalDF.println("Interval.setQualifier(" + Integer.toString(s2, 16) + ")");
        byte by = IntervalDF.getStartCode(s2);
        byte by2 = IntervalDF.getEndCode(s2);
        if (by > by2 && by == 12 && by2 == 11) {
            by2 = by;
        }
        if (by < 4 || by2 < 4 || by > by2) {
            throw IfxErrMsg.getLocSQLException(-79707, this.locale);
        }
        this.int_qual = s2;
    }
}

