/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.crypto.engines;

import thirdparty.org.bouncycastle.crypto.CipherParameters;
import thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import thirdparty.org.bouncycastle.crypto.Wrapper;
import thirdparty.org.bouncycastle.crypto.engines.GOST28147Engine;
import thirdparty.org.bouncycastle.crypto.macs.GOST28147Mac;
import thirdparty.org.bouncycastle.crypto.params.ParametersWithIV;
import thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import thirdparty.org.bouncycastle.crypto.params.ParametersWithUKM;
import thirdparty.org.bouncycastle.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            cipherParameters = ((ParametersWithRandom)cipherParameters2).getParameters();
        }
        cipherParameters2 = (ParametersWithUKM)cipherParameters;
        this.cipher.init(bl, ((ParametersWithUKM)cipherParameters2).getParameters());
        this.mac.init(new ParametersWithIV(((ParametersWithUKM)cipherParameters2).getParameters(), ((ParametersWithUKM)cipherParameters2).getUKM()));
    }

    @Override
    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
        byte[] byArray2 = new byte[n2 + this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n, byArray2, 0);
        this.cipher.processBlock(byArray, n + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n + 24, byArray2, 24);
        this.mac.doFinal(byArray2, n2);
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n2 - this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n, byArray2, 0);
        this.cipher.processBlock(byArray, n + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.mac.getMacSize()];
        System.arraycopy(byArray, n + n2 - 4, byArray4, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual(byArray3, byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

